/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.util.Set;
import org.apache.cassandra.diag.DiagnosticEventService;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.schema.SchemaAnnouncementEvent;
import org.apache.cassandra.schema.SchemaTransformation;

final class SchemaAnnouncementDiagnostics {
    private static final DiagnosticEventService service = DiagnosticEventService.instance();

    private SchemaAnnouncementDiagnostics() {
    }

    static void schemaMutationsAnnounced(Set<InetAddressAndPort> schemaDestinationEndpoints, Set<InetAddressAndPort> schemaEndpointsIgnored) {
        if (SchemaAnnouncementDiagnostics.isEnabled(SchemaAnnouncementEvent.SchemaAnnouncementEventType.SCHEMA_MUTATIONS_ANNOUNCED)) {
            service.publish(new SchemaAnnouncementEvent(SchemaAnnouncementEvent.SchemaAnnouncementEventType.SCHEMA_MUTATIONS_ANNOUNCED, schemaDestinationEndpoints, schemaEndpointsIgnored, null, null));
        }
    }

    public static void schemataMutationsReceived(InetAddressAndPort from) {
        if (SchemaAnnouncementDiagnostics.isEnabled(SchemaAnnouncementEvent.SchemaAnnouncementEventType.SCHEMA_MUTATIONS_RECEIVED)) {
            service.publish(new SchemaAnnouncementEvent(SchemaAnnouncementEvent.SchemaAnnouncementEventType.SCHEMA_MUTATIONS_RECEIVED, null, null, null, from));
        }
    }

    static void schemaTransformationAnnounced(Set<InetAddressAndPort> schemaDestinationEndpoints, Set<InetAddressAndPort> schemaEndpointsIgnored, SchemaTransformation transformation) {
        if (SchemaAnnouncementDiagnostics.isEnabled(SchemaAnnouncementEvent.SchemaAnnouncementEventType.SCHEMA_TRANSFORMATION_ANNOUNCED)) {
            service.publish(new SchemaAnnouncementEvent(SchemaAnnouncementEvent.SchemaAnnouncementEventType.SCHEMA_TRANSFORMATION_ANNOUNCED, schemaDestinationEndpoints, schemaEndpointsIgnored, transformation, null));
        }
    }

    private static boolean isEnabled(SchemaAnnouncementEvent.SchemaAnnouncementEventType type) {
        return service.isEnabled(SchemaAnnouncementEvent.class, type);
    }
}

