/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.cypherbuilder.operation;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.metadata.api.IHopMetadataObjectFactory;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.CreateOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.DeleteOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.EdgeCreateOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.EdgeMatchOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.EdgeMergeOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.IOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.MatchOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.MergeOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.OperationType;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.OrderByOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.ReturnOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.SetOperation;

public class OperationFactory
implements IHopMetadataObjectFactory {
    public static IOperation createOperation(OperationType operationType) {
        assert (operationType != null) : "Please specify an operation type";
        switch (operationType) {
            case MATCH: {
                return new MatchOperation();
            }
            case MERGE: {
                return new MergeOperation();
            }
            case CREATE: {
                return new CreateOperation();
            }
            case RETURN: {
                return new ReturnOperation();
            }
            case DELETE: {
                return new DeleteOperation();
            }
            case SET: {
                return new SetOperation();
            }
            case ORDER_BY: {
                return new OrderByOperation();
            }
            case EDGE_MATCH: {
                return new EdgeMatchOperation();
            }
            case EDGE_CREATE: {
                return new EdgeCreateOperation();
            }
            case EDGE_MERGE: {
                return new EdgeMergeOperation();
            }
        }
        throw new RuntimeException("Operation type " + String.valueOf((Object)operationType) + " is not supported");
    }

    public Object createObject(String id, Object parentObject) throws HopException {
        try {
            OperationType operationType = OperationType.valueOf(id);
            return OperationFactory.createOperation(operationType);
        }
        catch (Exception e) {
            throw new HopException("Error creating operation object ", (Throwable)e);
        }
    }

    public String getObjectId(Object object) throws HopException {
        if (object instanceof IOperation) {
            IOperation iOperation = (IOperation)object;
            return iOperation.getOperationType().name();
        }
        throw new HopException("Unexpected object class received: " + object.getClass().getName());
    }
}

