/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.TaskContext;
import org.apache.flink.runtime.operators.util.JoinTaskIterator;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.runtime.operators.util.metrics.CountingCollector;
import org.apache.flink.runtime.operators.util.metrics.CountingMutableObjectIterator;
import org.apache.flink.util.MutableObjectIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOuterJoinDriver<IT1, IT2, OT>
implements Driver<FlatJoinFunction<IT1, IT2, OT>, OT> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractOuterJoinDriver.class);
    protected TaskContext<FlatJoinFunction<IT1, IT2, OT>, OT> taskContext;
    protected volatile JoinTaskIterator<IT1, IT2, OT> outerJoinIterator;
    protected volatile boolean running;

    @Override
    public void setup(TaskContext<FlatJoinFunction<IT1, IT2, OT>, OT> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 2;
    }

    @Override
    public Class<FlatJoinFunction<IT1, IT2, OT>> getStubType() {
        Class<FlatJoinFunction> clazz = FlatJoinFunction.class;
        return clazz;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 2;
    }

    @Override
    public void prepare() throws Exception {
        TaskConfig config = this.taskContext.getTaskConfig();
        MemoryManager memoryManager = this.taskContext.getMemoryManager();
        IOManager ioManager = this.taskContext.getIOManager();
        double driverMemFraction = config.getRelativeMemoryDriver();
        DriverStrategy ls = config.getDriverStrategy();
        Counter numRecordsIn = this.taskContext.getMetricGroup().getIOMetricGroup().getNumRecordsInCounter();
        CountingMutableObjectIterator in1 = new CountingMutableObjectIterator(this.taskContext.getInput(0), numRecordsIn);
        CountingMutableObjectIterator in2 = new CountingMutableObjectIterator(this.taskContext.getInput(1), numRecordsIn);
        TypeSerializer serializer1 = this.taskContext.getInputSerializer(0).getSerializer();
        TypeSerializer serializer2 = this.taskContext.getInputSerializer(1).getSerializer();
        TypeComparator comparator1 = this.taskContext.getDriverComparator(0);
        TypeComparator comparator2 = this.taskContext.getDriverComparator(1);
        TypePairComparatorFactory pairComparatorFactory = config.getPairComparatorFactory(this.taskContext.getUserCodeClassLoader());
        if (pairComparatorFactory == null) {
            throw new Exception("Missing pair comparator factory for outer join driver");
        }
        ExecutionConfig executionConfig = this.taskContext.getExecutionConfig();
        boolean objectReuseEnabled = executionConfig.isObjectReuseEnabled();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Outer Join Driver object reuse: " + (objectReuseEnabled ? "ENABLED" : "DISABLED") + ".");
        }
        this.outerJoinIterator = objectReuseEnabled ? this.getReusingOuterJoinIterator(ls, in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory, memoryManager, ioManager, driverMemFraction) : this.getNonReusingOuterJoinIterator(ls, in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory, memoryManager, ioManager, driverMemFraction);
        this.outerJoinIterator.open();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.taskContext.formatLogString("outer join task iterator ready."));
        }
    }

    @Override
    public void run() throws Exception {
        Counter numRecordsOut = this.taskContext.getMetricGroup().getIOMetricGroup().getNumRecordsOutCounter();
        FlatJoinFunction<IT1, IT2, OT> joinStub = this.taskContext.getStub();
        CountingCollector<OT> collector = new CountingCollector<OT>(this.taskContext.getOutputCollector(), numRecordsOut);
        JoinTaskIterator<IT1, IT2, OT> outerJoinIterator = this.outerJoinIterator;
        while (this.running && outerJoinIterator.callWithNextKey(joinStub, collector)) {
        }
    }

    @Override
    public void cleanup() throws Exception {
        if (this.outerJoinIterator != null) {
            this.outerJoinIterator.close();
            this.outerJoinIterator = null;
        }
    }

    @Override
    public void cancel() {
        this.running = false;
        if (this.outerJoinIterator != null) {
            this.outerJoinIterator.abort();
        }
    }

    protected abstract JoinTaskIterator<IT1, IT2, OT> getReusingOuterJoinIterator(DriverStrategy var1, MutableObjectIterator<IT1> var2, MutableObjectIterator<IT2> var3, TypeSerializer<IT1> var4, TypeComparator<IT1> var5, TypeSerializer<IT2> var6, TypeComparator<IT2> var7, TypePairComparatorFactory<IT1, IT2> var8, MemoryManager var9, IOManager var10, double var11) throws Exception;

    protected abstract JoinTaskIterator<IT1, IT2, OT> getNonReusingOuterJoinIterator(DriverStrategy var1, MutableObjectIterator<IT1> var2, MutableObjectIterator<IT2> var3, TypeSerializer<IT1> var4, TypeComparator<IT1> var5, TypeSerializer<IT2> var6, TypeComparator<IT2> var7, TypePairComparatorFactory<IT1, IT2> var8, MemoryManager var9, IOManager var10, double var11) throws Exception;
}

