/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.output;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.neo4j.core.Neo4jUtil;
import org.apache.hop.neo4j.model.GraphPropertyType;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.neo4j.transforms.output.Neo4JOutputMeta;
import org.apache.hop.neo4j.transforms.output.fields.LabelField;
import org.apache.hop.neo4j.transforms.output.fields.PropertyField;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageDialogWithToggle;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Neo4JOutputDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = Neo4JOutputMeta.class;
    public static final String CONST_NEO_4_JOUTPUT_DIALOG_GET_FIELDS_BUTTON = "Neo4JOutputDialog.GetFields.Button";
    public static final String CONST_NEO_4_JOUTPUT_DIALOG_PROP_TYPE = "Neo4JOutputDialog.PropType";
    private Neo4JOutputMeta input;
    private MetaSelectionLine<NeoConnection> wConnection;
    private Label wlBatchSize;
    private TextVar wBatchSize;
    private Label wlCreateIndexes;
    private Button wCreateIndexes;
    private Label wlUseCreate;
    private Button wUseCreate;
    private Label wlOnlyCreateRelationships;
    private Button wOnlyCreateRelationships;
    private Button wReturnGraph;
    private Label wlReturnGraphField;
    private TextVar wReturnGraphField;
    private Combo wRel;
    private TextVar wRelValue;
    private TableView wFromPropsGrid;
    private TableView wFromLabelGrid;
    private TableView wToPropsGrid;
    private TableView wToLabelGrid;
    private TableView wRelPropsGrid;
    private Button wReadOnlyFromNode;
    private Button wReadOnlyToNode;
    public static final String STRING_DYNAMIC_LABELS_WARNING = "NEO4J_OUTPUT_SHOW_DYNAMIC_LABELS_WARNING";

    public Neo4JOutputDialog(Shell parent, IVariables variables, Neo4JOutputMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        String[] fieldNames;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        try {
            IRowMeta prevFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            fieldNames = prevFields.getFieldNames();
        }
        catch (HopTransformException kse) {
            this.logError(BaseMessages.getString(PKG, (String)"TripleOutput.Log.ErrorGettingFieldNames", (String[])new String[0]));
            fieldNames = new String[]{};
        }
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.StepName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, margin);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        TextVar lastControl = this.wTransformName;
        this.wConnection = new MetaSelectionLine(this.variables, this.metadataProvider, NeoConnection.class, (Composite)this.shell, 18436, "Neo4j Connection", "The name of the Neo4j connection to use");
        PropsUi.setLook(this.wConnection);
        this.wConnection.addModifyListener(lsMod);
        FormData fdConnection = new FormData();
        fdConnection.left = new FormAttachment(0, 0);
        fdConnection.right = new FormAttachment(100, 0);
        fdConnection.top = new FormAttachment((Control)lastControl, margin);
        this.wConnection.setLayoutData((Object)fdConnection);
        try {
            this.wConnection.fillItems();
        }
        catch (Exception e2) {
            new ErrorDialog(this.shell, "Error", "Error getting list of connections", e2);
        }
        lastControl = this.wConnection;
        this.wlBatchSize = new Label((Composite)this.shell, 131072);
        this.wlBatchSize.setText("Batch size (rows)");
        PropsUi.setLook((Widget)this.wlBatchSize);
        FormData fdlBatchSize = new FormData();
        fdlBatchSize.left = new FormAttachment(0, 0);
        fdlBatchSize.right = new FormAttachment(middle, -margin);
        fdlBatchSize.top = new FormAttachment(lastControl, 2 * margin);
        this.wlBatchSize.setLayoutData((Object)fdlBatchSize);
        this.wBatchSize = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wBatchSize);
        this.wBatchSize.addModifyListener(lsMod);
        FormData fdBatchSize = new FormData();
        fdBatchSize.left = new FormAttachment(middle, 0);
        fdBatchSize.right = new FormAttachment(100, 0);
        fdBatchSize.top = new FormAttachment((Control)this.wlBatchSize, 0, 0x1000000);
        this.wBatchSize.setLayoutData((Object)fdBatchSize);
        lastControl = this.wBatchSize;
        this.wlCreateIndexes = new Label((Composite)this.shell, 131072);
        this.wlCreateIndexes.setText("Create indexes? ");
        PropsUi.setLook((Widget)this.wlCreateIndexes);
        FormData fdlCreateIndexes = new FormData();
        fdlCreateIndexes.left = new FormAttachment(0, 0);
        fdlCreateIndexes.right = new FormAttachment(middle, -margin);
        fdlCreateIndexes.top = new FormAttachment((Control)lastControl, 2 * margin);
        this.wlCreateIndexes.setLayoutData((Object)fdlCreateIndexes);
        this.wCreateIndexes = new Button((Composite)this.shell, 2080);
        PropsUi.setLook((Widget)this.wCreateIndexes);
        FormData fdCreateIndexes = new FormData();
        fdCreateIndexes.left = new FormAttachment(middle, 0);
        fdCreateIndexes.right = new FormAttachment(100, 0);
        fdCreateIndexes.top = new FormAttachment((Control)this.wlCreateIndexes, 0, 0x1000000);
        this.wCreateIndexes.setLayoutData((Object)fdCreateIndexes);
        lastControl = this.wCreateIndexes;
        this.wlUseCreate = new Label((Composite)this.shell, 131072);
        this.wlUseCreate.setText("Use CREATE instead of MERGE? ");
        PropsUi.setLook((Widget)this.wlUseCreate);
        FormData fdlUseCreate = new FormData();
        fdlUseCreate.left = new FormAttachment(0, 0);
        fdlUseCreate.right = new FormAttachment(middle, -margin);
        fdlUseCreate.top = new FormAttachment((Control)lastControl, 2 * margin);
        this.wlUseCreate.setLayoutData((Object)fdlUseCreate);
        this.wUseCreate = new Button((Composite)this.shell, 2080);
        PropsUi.setLook((Widget)this.wUseCreate);
        FormData fdUseCreate = new FormData();
        fdUseCreate.left = new FormAttachment(middle, 0);
        fdUseCreate.right = new FormAttachment(100, 0);
        fdUseCreate.top = new FormAttachment((Control)this.wlUseCreate, 0, 0x1000000);
        this.wUseCreate.setLayoutData((Object)fdUseCreate);
        lastControl = this.wUseCreate;
        this.wlOnlyCreateRelationships = new Label((Composite)this.shell, 131072);
        this.wlOnlyCreateRelationships.setText("Only create relationships? ");
        PropsUi.setLook((Widget)this.wlOnlyCreateRelationships);
        FormData fdlOnlyCreateRelationships = new FormData();
        fdlOnlyCreateRelationships.left = new FormAttachment(0, 0);
        fdlOnlyCreateRelationships.right = new FormAttachment(middle, -margin);
        fdlOnlyCreateRelationships.top = new FormAttachment((Control)lastControl, 2 * margin);
        this.wlOnlyCreateRelationships.setLayoutData((Object)fdlOnlyCreateRelationships);
        this.wOnlyCreateRelationships = new Button((Composite)this.shell, 2080);
        PropsUi.setLook((Widget)this.wOnlyCreateRelationships);
        FormData fdOnlyCreateRelationships = new FormData();
        fdOnlyCreateRelationships.left = new FormAttachment(middle, 0);
        fdOnlyCreateRelationships.right = new FormAttachment(100, 0);
        fdOnlyCreateRelationships.top = new FormAttachment((Control)this.wlOnlyCreateRelationships, 0, 0x1000000);
        this.wOnlyCreateRelationships.setLayoutData((Object)fdOnlyCreateRelationships);
        this.wOnlyCreateRelationships.addListener(13, e -> this.enableFields());
        lastControl = this.wOnlyCreateRelationships;
        Label wlReturnGraph = new Label((Composite)this.shell, 131072);
        wlReturnGraph.setText("Return graph data?");
        String returnGraphTooltipText = "The update data to be updated in the form of Graph a value in the output of this transform";
        wlReturnGraph.setToolTipText(returnGraphTooltipText);
        PropsUi.setLook((Widget)wlReturnGraph);
        FormData fdlReturnGraph = new FormData();
        fdlReturnGraph.left = new FormAttachment(0, 0);
        fdlReturnGraph.right = new FormAttachment(middle, -margin);
        fdlReturnGraph.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlReturnGraph.setLayoutData((Object)fdlReturnGraph);
        this.wReturnGraph = new Button((Composite)this.shell, 2080);
        this.wReturnGraph.setToolTipText(returnGraphTooltipText);
        PropsUi.setLook((Widget)this.wReturnGraph);
        FormData fdReturnGraph = new FormData();
        fdReturnGraph.left = new FormAttachment(middle, 0);
        fdReturnGraph.right = new FormAttachment(100, 0);
        fdReturnGraph.top = new FormAttachment((Control)wlReturnGraph, 0, 0x1000000);
        this.wReturnGraph.setLayoutData((Object)fdReturnGraph);
        this.wReturnGraph.addListener(13, e -> this.enableFields());
        lastControl = this.wReturnGraph;
        this.wlReturnGraphField = new Label((Composite)this.shell, 131072);
        this.wlReturnGraphField.setText("Graph output field name");
        PropsUi.setLook((Widget)this.wlReturnGraphField);
        FormData fdlReturnGraphField = new FormData();
        fdlReturnGraphField.left = new FormAttachment(0, 0);
        fdlReturnGraphField.right = new FormAttachment(middle, -margin);
        fdlReturnGraphField.top = new FormAttachment((Control)lastControl, 2 * margin);
        this.wlReturnGraphField.setLayoutData((Object)fdlReturnGraphField);
        this.wReturnGraphField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wReturnGraphField);
        this.wReturnGraphField.addModifyListener(lsMod);
        FormData fdReturnGraphField = new FormData();
        fdReturnGraphField.left = new FormAttachment(middle, 0);
        fdReturnGraphField.right = new FormAttachment(100, 0);
        fdReturnGraphField.top = new FormAttachment((Control)this.wlReturnGraphField, 0, 0x1000000);
        this.wReturnGraphField.setLayoutData((Object)fdReturnGraphField);
        lastControl = this.wReturnGraphField;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)margin, null);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)lastControl, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        CTabItem wFromTab = new CTabItem(wTabFolder, 0);
        wFromTab.setFont(GuiResource.getInstance().getFontDefault());
        wFromTab.setText(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.FromTab", (String[])new String[0]));
        FormLayout fromLayout = new FormLayout();
        fromLayout.marginWidth = 3;
        fromLayout.marginHeight = 3;
        Composite wFromComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wFromComp);
        wFromComp.setLayout((Layout)fromLayout);
        this.wReadOnlyFromNode = new Button(wFromComp, 32);
        this.wReadOnlyFromNode.setText(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.LabelsField.ReadOnlyFromNode", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wReadOnlyFromNode);
        FormData fdReadOnlyFromNode = new FormData();
        fdReadOnlyFromNode.left = new FormAttachment(middle, margin);
        fdReadOnlyFromNode.right = new FormAttachment(100, 0);
        fdReadOnlyFromNode.top = new FormAttachment(0, margin * 3);
        this.wReadOnlyFromNode.setLayoutData((Object)fdReadOnlyFromNode);
        Button lastFromControl = this.wReadOnlyFromNode;
        Label wlFromLabel = new Label(wFromComp, 131072);
        wlFromLabel.setText(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.LabelsField.FromLabel", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFromLabel);
        FormData fdlFromLabels = new FormData();
        fdlFromLabels.left = new FormAttachment(0, 0);
        fdlFromLabels.right = new FormAttachment(middle, 0);
        fdlFromLabels.top = new FormAttachment((Control)lastFromControl, margin);
        wlFromLabel.setLayoutData((Object)fdlFromLabels);
        int fromLabelRows = !this.input.getNodeFromField().getLabels().isEmpty() ? this.input.getNodeFromField().getLabels().size() : 10;
        ColumnInfo[] fromLabelInf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.FromLabelsTable.FromFields", (String[])new String[0]), 2, fieldNames), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.FromLabelsTable.FromValues", (String[])new String[0]), 1, false, false)};
        fromLabelInf[1].setUsingVariables(true);
        this.wFromLabelGrid = new TableView(Variables.getADefaultVariableSpace(), wFromComp, 67586, fromLabelInf, fromLabelRows, null, PropsUi.getInstance());
        PropsUi.setLook((Widget)this.wFromLabelGrid);
        Button wGetFromLabel = new Button(wFromComp, 8);
        wGetFromLabel.setText(BaseMessages.getString(PKG, (String)CONST_NEO_4_JOUTPUT_DIALOG_GET_FIELDS_BUTTON, (String[])new String[0]));
        wGetFromLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Neo4JOutputDialog.this.get(0);
            }
        });
        FormData fdGetFromLabel = new FormData();
        fdGetFromLabel.right = new FormAttachment(100, 0);
        fdGetFromLabel.top = new FormAttachment((Control)lastFromControl, margin);
        wGetFromLabel.setLayoutData((Object)fdGetFromLabel);
        FormData fdFromLabelGrid = new FormData();
        fdFromLabelGrid.left = new FormAttachment(middle, margin);
        fdFromLabelGrid.top = new FormAttachment((Control)lastFromControl, margin);
        fdFromLabelGrid.right = new FormAttachment((Control)wGetFromLabel, 0);
        fdFromLabelGrid.bottom = new FormAttachment(0, margin * 2 + (int)(this.props.getZoomFactor() * 150.0));
        this.wFromLabelGrid.setLayoutData((Object)fdFromLabelGrid);
        lastFromControl = this.wFromLabelGrid;
        Label wlFromFields = new Label(wFromComp, 131072);
        wlFromFields.setText(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.FromFields.Properties", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFromFields);
        FormData fdlFromFields = new FormData();
        fdlFromFields.left = new FormAttachment(0, 0);
        fdlFromFields.right = new FormAttachment(middle, 0);
        fdlFromFields.top = new FormAttachment((Control)lastFromControl, margin);
        wlFromFields.setLayoutData((Object)fdlFromFields);
        int fromPropsRows = this.input.getNodeFromField().getProperties() != null ? this.input.getNodeFromField().getProperties().size() : 10;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.FromFieldsTable.FromPropFields", (String[])new String[0]), 2, fieldNames, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.FromFieldsTable.FromPropFieldsName", (String[])new String[0]), 1, fieldNames, false), new ColumnInfo(BaseMessages.getString(PKG, (String)CONST_NEO_4_JOUTPUT_DIALOG_PROP_TYPE, (String[])new String[0]), 2, GraphPropertyType.getNames(), false), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.PropPrimary", (String[])new String[0]), 2, new String[]{"Y", "N"}, false)};
        this.wFromPropsGrid = new TableView(Variables.getADefaultVariableSpace(), wFromComp, 67586, colinf, fromPropsRows, null, this.props);
        PropsUi.setLook((Widget)this.wFromPropsGrid);
        Button wGetFromProps = new Button(wFromComp, 8);
        wGetFromProps.setText(BaseMessages.getString(PKG, (String)CONST_NEO_4_JOUTPUT_DIALOG_GET_FIELDS_BUTTON, (String[])new String[0]));
        wGetFromProps.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Neo4JOutputDialog.this.get(1);
            }
        });
        FormData fdGetFromProps = new FormData();
        fdGetFromProps.right = new FormAttachment(100, 0);
        fdGetFromProps.top = new FormAttachment((Control)lastFromControl, margin);
        wGetFromProps.setLayoutData((Object)fdGetFromProps);
        FormData fdFromPropsGrid = new FormData();
        fdFromPropsGrid.left = new FormAttachment(middle, margin);
        fdFromPropsGrid.right = new FormAttachment((Control)wGetFromProps, 0);
        fdFromPropsGrid.top = new FormAttachment((Control)lastFromControl, margin);
        fdFromPropsGrid.bottom = new FormAttachment(100, 0);
        this.wFromPropsGrid.setLayoutData((Object)fdFromPropsGrid);
        FormData fdFromComp = new FormData();
        fdFromComp.left = new FormAttachment(0, 0);
        fdFromComp.top = new FormAttachment(0, 0);
        fdFromComp.right = new FormAttachment(100, 0);
        fdFromComp.bottom = new FormAttachment(100, 0);
        wFromComp.setLayoutData((Object)fdFromComp);
        wFromComp.layout();
        wFromTab.setControl((Control)wFromComp);
        CTabItem wToTab = new CTabItem(wTabFolder, 0);
        wToTab.setFont(GuiResource.getInstance().getFontDefault());
        wToTab.setText(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.ToTab", (String[])new String[0]));
        FormLayout toLayout = new FormLayout();
        toLayout.marginWidth = 3;
        toLayout.marginHeight = 3;
        Composite wToComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wToComp);
        wToComp.setLayout((Layout)toLayout);
        this.wReadOnlyToNode = new Button(wToComp, 32);
        this.wReadOnlyToNode.setText(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.LabelsField.ReadOnlyToNode", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wReadOnlyToNode);
        FormData fdReadOnlyToNode = new FormData();
        fdReadOnlyToNode.left = new FormAttachment(middle, margin);
        fdReadOnlyToNode.right = new FormAttachment(100, 0);
        fdReadOnlyToNode.top = new FormAttachment(0, margin * 3);
        this.wReadOnlyToNode.setLayoutData((Object)fdReadOnlyToNode);
        Button lastToControl = this.wReadOnlyToNode;
        Label wlToLabel = new Label(wToComp, 131072);
        wlToLabel.setText(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.LabelsField.ToLabel", (String[])new String[0]));
        PropsUi.setLook((Widget)wlToLabel);
        FormData fdlToLabels = new FormData();
        fdlToLabels.left = new FormAttachment(0, 0);
        fdlToLabels.right = new FormAttachment(middle, 0);
        fdlToLabels.top = new FormAttachment((Control)lastToControl, margin);
        wlToLabel.setLayoutData((Object)fdlToLabels);
        int toLabelRows = this.input.getNodeToField().getLabels() != null ? this.input.getNodeToField().getLabels().size() : 10;
        ColumnInfo[] toLabelInf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.ToLabelsTable.ToFields", (String[])new String[0]), 2, fieldNames), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.ToLabelsTable.ToValues", (String[])new String[0]), 1, false, false)};
        toLabelInf[1].setUsingVariables(true);
        this.wToLabelGrid = new TableView(Variables.getADefaultVariableSpace(), wToComp, 67586, toLabelInf, toLabelRows, null, PropsUi.getInstance());
        PropsUi.setLook((Widget)this.wToLabelGrid);
        Button wGetToLabel = new Button(wToComp, 8);
        wGetToLabel.setText(BaseMessages.getString(PKG, (String)CONST_NEO_4_JOUTPUT_DIALOG_GET_FIELDS_BUTTON, (String[])new String[0]));
        wGetToLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Neo4JOutputDialog.this.get(2);
            }
        });
        FormData fdGetToLabel = new FormData();
        fdGetToLabel.right = new FormAttachment(100, 0);
        fdGetToLabel.top = new FormAttachment((Control)lastToControl, margin);
        wGetToLabel.setLayoutData((Object)fdGetToLabel);
        FormData fdToLabelGrid = new FormData();
        fdToLabelGrid.left = new FormAttachment(middle, margin);
        fdToLabelGrid.right = new FormAttachment((Control)wGetToLabel, 0);
        fdToLabelGrid.top = new FormAttachment((Control)lastToControl, margin);
        fdToLabelGrid.bottom = new FormAttachment(0, margin * 2 + (int)(this.props.getZoomFactor() * 150.0));
        fdToLabelGrid.bottom = new FormAttachment(0, margin * 2 + (int)(this.props.getZoomFactor() * 150.0));
        this.wToLabelGrid.setLayoutData((Object)fdToLabelGrid);
        lastToControl = this.wToLabelGrid;
        Label wlToFields = new Label(wToComp, 131072);
        wlToFields.setText(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.ToFields.Properties", (String[])new String[0]));
        PropsUi.setLook((Widget)wlToFields);
        FormData fdlToFields = new FormData();
        fdlToFields.left = new FormAttachment(0, 0);
        fdlToFields.right = new FormAttachment(middle, 0);
        fdlToFields.top = new FormAttachment((Control)lastToControl, margin);
        wlToFields.setLayoutData((Object)fdlToFields);
        int toPropsRows = this.input.getNodeToField().getProperties() != null ? this.input.getNodeToField().getProperties().size() : 10;
        ColumnInfo[] toColinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.ToFieldsTable.ToFields", (String[])new String[0]), 2, fieldNames, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.ToFieldsTable.ToFieldsName", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)CONST_NEO_4_JOUTPUT_DIALOG_PROP_TYPE, (String[])new String[0]), 2, GraphPropertyType.getNames(), false), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.PropPrimary", (String[])new String[0]), 2, new String[]{"Y", "N"}, false)};
        this.wToPropsGrid = new TableView(Variables.getADefaultVariableSpace(), wToComp, 67586, toColinf, toPropsRows, null, PropsUi.getInstance());
        PropsUi.setLook((Widget)this.wToPropsGrid);
        Button wGetToProps = new Button(wToComp, 8);
        wGetToProps.setText(BaseMessages.getString(PKG, (String)CONST_NEO_4_JOUTPUT_DIALOG_GET_FIELDS_BUTTON, (String[])new String[0]));
        wGetToProps.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Neo4JOutputDialog.this.get(3);
            }
        });
        FormData fdGetToProps = new FormData();
        fdGetToProps.right = new FormAttachment(100, 0);
        fdGetToProps.top = new FormAttachment((Control)lastToControl, margin);
        wGetToProps.setLayoutData((Object)fdGetToProps);
        FormData fdToPropsGrid = new FormData();
        fdToPropsGrid.left = new FormAttachment(middle, margin);
        fdToPropsGrid.right = new FormAttachment((Control)wGetToProps, 0);
        fdToPropsGrid.top = new FormAttachment((Control)lastToControl, margin);
        fdToPropsGrid.bottom = new FormAttachment(100, 0);
        this.wToPropsGrid.setLayoutData((Object)fdToPropsGrid);
        FormData fdToComp = new FormData();
        fdToComp.left = new FormAttachment(0, 0);
        fdToComp.top = new FormAttachment(0, 0);
        fdToComp.right = new FormAttachment(100, 0);
        fdToComp.bottom = new FormAttachment(100, 0);
        wToComp.setLayoutData((Object)fdToComp);
        wToComp.layout();
        wToTab.setControl((Control)wToComp);
        CTabItem wRelationshipsTab = new CTabItem(wTabFolder, 0);
        wRelationshipsTab.setFont(GuiResource.getInstance().getFontDefault());
        wRelationshipsTab.setText(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.RelationshipsTab", (String[])new String[0]));
        FormLayout relationshipsLayout = new FormLayout();
        relationshipsLayout.marginWidth = 3;
        relationshipsLayout.marginHeight = 3;
        Composite wRelationshipsComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wRelationshipsComp);
        wRelationshipsComp.setLayout((Layout)relationshipsLayout);
        Label wlRel = new Label(wRelationshipsComp, 131072);
        wlRel.setText(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.Relationship.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRel);
        FormData fdlRel = new FormData();
        fdlRel.left = new FormAttachment(0, 0);
        fdlRel.top = new FormAttachment(0, 0);
        fdlRel.right = new FormAttachment(middle, -margin);
        wlRel.setLayoutData((Object)fdlRel);
        this.wRel = new Combo(wRelationshipsComp, 18436);
        this.wRel.setItems(fieldNames);
        PropsUi.setLook((Widget)this.wRel);
        this.wRel.addModifyListener(lsMod);
        FormData fdRel = new FormData();
        fdRel.left = new FormAttachment((Control)wlRel, margin);
        fdRel.right = new FormAttachment(100, 0);
        fdRel.top = new FormAttachment((Control)wlRel, 0, 0x1000000);
        this.wRel.setLayoutData((Object)fdRel);
        lastControl = this.wRel;
        Label wlRelValue = new Label(wRelationshipsComp, 131072);
        wlRelValue.setText(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.RelationshipValue.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRelValue);
        FormData fdlRelValue = new FormData();
        fdlRelValue.left = new FormAttachment(0, 0);
        fdlRelValue.top = new FormAttachment((Control)lastControl, margin * 2);
        fdlRelValue.right = new FormAttachment(middle, -margin);
        wlRelValue.setLayoutData((Object)fdlRelValue);
        this.wRelValue = new TextVar(this.variables, wRelationshipsComp, 18436);
        PropsUi.setLook((Widget)this.wRelValue);
        this.wRelValue.addModifyListener(lsMod);
        FormData fdRelValue = new FormData();
        fdRelValue.left = new FormAttachment((Control)wlRelValue, margin);
        fdRelValue.right = new FormAttachment(100, 0);
        fdRelValue.top = new FormAttachment((Control)wlRelValue, 0, 0x1000000);
        this.wRelValue.setLayoutData((Object)fdRelValue);
        lastControl = this.wRelValue;
        Label wlRelProps = new Label(wRelationshipsComp, 131072);
        wlRelProps.setText(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.RelationshipProperties.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRelProps);
        FormData fdlRelProps = new FormData();
        fdlRelProps.left = new FormAttachment(0, 0);
        fdlRelProps.top = new FormAttachment((Control)lastControl, margin * 3);
        fdlRelProps.right = new FormAttachment(middle, -margin);
        wlRelProps.setLayoutData((Object)fdlRelProps);
        int relPropsRows = this.input.getRelProps() != null ? this.input.getRelProps().size() : 10;
        ColumnInfo[] relPropsInf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.RelPropsTable.PropertiesField", (String[])new String[0]), 2, fieldNames, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.RelPropsTable.PropertiesFieldName", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)CONST_NEO_4_JOUTPUT_DIALOG_PROP_TYPE, (String[])new String[0]), 2, GraphPropertyType.getNames(), false)};
        this.wRelPropsGrid = new TableView(Variables.getADefaultVariableSpace(), wRelationshipsComp, 67586, relPropsInf, relPropsRows, null, PropsUi.getInstance());
        PropsUi.setLook((Widget)this.wRelPropsGrid);
        Button wbRelProps = new Button(wRelationshipsComp, 8);
        wbRelProps.setText(BaseMessages.getString(PKG, (String)CONST_NEO_4_JOUTPUT_DIALOG_GET_FIELDS_BUTTON, (String[])new String[0]));
        wbRelProps.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Neo4JOutputDialog.this.get(4);
            }
        });
        FormData fdRelProps = new FormData();
        fdRelProps.right = new FormAttachment(100, 0);
        fdRelProps.top = new FormAttachment((Control)lastControl, margin * 3);
        wbRelProps.setLayoutData((Object)fdRelProps);
        FormData fdRelPropsGrid = new FormData();
        fdRelPropsGrid.left = new FormAttachment((Control)wlRelProps, margin);
        fdRelPropsGrid.right = new FormAttachment((Control)wbRelProps, -margin);
        fdRelPropsGrid.top = new FormAttachment((Control)lastControl, margin * 3);
        fdRelPropsGrid.bottom = new FormAttachment(100, 0);
        this.wRelPropsGrid.setLayoutData((Object)fdRelPropsGrid);
        FormData fdRelationshipsComp = new FormData();
        fdRelationshipsComp.left = new FormAttachment(0, 0);
        fdRelationshipsComp.top = new FormAttachment(0, 0);
        fdRelationshipsComp.right = new FormAttachment(100, 0);
        fdRelationshipsComp.bottom = new FormAttachment(100, 0);
        wRelationshipsComp.setLayoutData((Object)fdRelationshipsComp);
        wRelationshipsComp.layout();
        wRelationshipsTab.setControl((Control)wRelationshipsComp);
        wTabFolder.setSelection(0);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void enableFields() {
        boolean toNeo = !this.wReturnGraph.getSelection();
        this.wConnection.setEnabled(toNeo);
        this.wlBatchSize.setEnabled(toNeo);
        this.wBatchSize.setEnabled(toNeo);
        this.wlCreateIndexes.setEnabled(toNeo);
        this.wCreateIndexes.setEnabled(toNeo);
        this.wlUseCreate.setEnabled(toNeo);
        this.wUseCreate.setEnabled(toNeo);
        this.wlOnlyCreateRelationships.setEnabled(toNeo);
        this.wOnlyCreateRelationships.setEnabled(toNeo);
        this.wlReturnGraphField.setEnabled(!toNeo);
        this.wReturnGraphField.setEnabled(!toNeo);
        boolean onlyCreateRelationships = this.wOnlyCreateRelationships.getSelection();
        this.wReadOnlyFromNode.setEnabled(!onlyCreateRelationships);
        this.wReadOnlyToNode.setEnabled(!onlyCreateRelationships);
    }

    private void getData() {
        TableItem item;
        int i;
        this.wTransformName.setText(this.transformName);
        this.wTransformName.selectAll();
        this.wConnection.setText(Const.NVL((String)this.input.getConnection(), (String)""));
        this.wBatchSize.setText(Const.NVL((String)this.input.getBatchSize(), (String)""));
        this.wCreateIndexes.setSelection(this.input.isCreatingIndexes());
        this.wUseCreate.setSelection(this.input.isUsingCreate());
        this.wOnlyCreateRelationships.setSelection(this.input.isOnlyCreatingRelationships());
        this.wReturnGraph.setSelection(this.input.isReturningGraph());
        this.wReturnGraphField.setText(Const.NVL((String)this.input.getReturnGraphField(), (String)""));
        this.wReadOnlyFromNode.setSelection(this.input.getNodeFromField().isReadOnly());
        this.wReadOnlyToNode.setSelection(this.input.getNodeToField().isReadOnly());
        if (this.input.getNodeFromField().getLabels() != null) {
            List<LabelField> labels = this.input.getNodeFromField().getLabels();
            for (i = 0; i < labels.size(); ++i) {
                item = this.wFromLabelGrid.table.getItem(i);
                item.setText(1, Const.NVL((String)labels.get(i).getLabelField(), (String)""));
                item.setText(2, Const.NVL((String)labels.get(i).getLabel(), (String)""));
            }
        }
        if (this.input.getNodeFromField().getProperties() != null) {
            for (int i2 = 0; i2 < this.input.getNodeFromField().getProperties().size(); ++i2) {
                TableItem item2 = this.wFromPropsGrid.table.getItem(i2);
                item2.setText(1, Const.NVL((String)this.input.getNodeFromField().getProperties().get(i2).getPropertyValue(), (String)""));
                item2.setText(2, Const.NVL((String)this.input.getNodeFromField().getProperties().get(i2).getPropertyName(), (String)""));
                item2.setText(3, Const.NVL((String)this.input.getNodeFromField().getProperties().get(i2).getPropertyType(), (String)""));
                item2.setText(4, this.input.getNodeFromField().getProperties().get(i2).isPropertyPrimary() ? "Y" : "N");
            }
        }
        if (this.input.getNodeToField().getLabels() != null) {
            List<LabelField> toLabels = this.input.getNodeToField().getLabels();
            for (i = 0; i < toLabels.size(); ++i) {
                item = this.wToLabelGrid.table.getItem(i);
                item.setText(1, Const.NVL((String)toLabels.get(i).getLabelField(), (String)""));
                item.setText(2, Const.NVL((String)toLabels.get(i).getLabel(), (String)""));
            }
        }
        if (this.input.getNodeToField().getProperties() != null) {
            for (int i3 = 0; i3 < this.input.getNodeToField().getProperties().size(); ++i3) {
                TableItem item3 = this.wToPropsGrid.table.getItem(i3);
                item3.setText(1, Const.NVL((String)this.input.getNodeToField().getProperties().get(i3).getPropertyValue(), (String)""));
                item3.setText(2, Const.NVL((String)this.input.getNodeToField().getProperties().get(i3).getPropertyName(), (String)""));
                item3.setText(3, Const.NVL((String)this.input.getNodeToField().getProperties().get(i3).getPropertyType(), (String)""));
                item3.setText(4, this.input.getNodeToField().getProperties().get(i3).isPropertyPrimary() ? "Y" : "N");
            }
        }
        this.wRel.setText(Const.NVL((String)this.input.getRelationship(), (String)""));
        this.wRelValue.setText(Const.NVL((String)this.input.getRelationshipValue(), (String)""));
        if (this.input.getRelProps() != null) {
            for (int i4 = 0; i4 < this.input.getRelProps().size(); ++i4) {
                TableItem item4 = this.wRelPropsGrid.table.getItem(i4);
                item4.setText(1, Const.NVL((String)this.input.getRelProps().get(i4).getPropertyValue(), (String)""));
                item4.setText(2, Const.NVL((String)this.input.getRelProps().get(i4).getPropertyName(), (String)""));
                item4.setText(3, Const.NVL((String)this.input.getRelProps().get(i4).getPropertyType(), (String)""));
            }
        }
        this.enableFields();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        this.transformName = this.wTransformName.getText();
        this.input.setConnection(this.wConnection.getText());
        this.input.setBatchSize(this.wBatchSize.getText());
        this.input.setCreatingIndexes(this.wCreateIndexes.getSelection());
        this.input.setUsingCreate(this.wUseCreate.getSelection());
        this.input.setOnlyCreatingRelationships(this.wOnlyCreateRelationships.getSelection());
        this.input.setReturningGraph(this.wReturnGraph.getSelection());
        this.input.setReturnGraphField(this.wReturnGraphField.getText());
        this.input.getNodeFromField().setReadOnly(this.wReadOnlyFromNode.getSelection());
        this.input.getNodeToField().setReadOnly(this.wReadOnlyToNode.getSelection());
        ArrayList<LabelField> fromNodeLabels = new ArrayList<LabelField>();
        for (int i = 0; i < this.wFromLabelGrid.nrNonEmpty(); ++i) {
            TableItem item = this.wFromLabelGrid.table.getItem(i);
            LabelField labelField = new LabelField();
            labelField.setLabelField(item.getText(1));
            labelField.setLabel(item.getText(2));
            fromNodeLabels.add(labelField);
        }
        this.input.getNodeFromField().setLabels(fromNodeLabels);
        ArrayList<LabelField> toNodeLabels = new ArrayList<LabelField>();
        for (int i = 0; i < this.wToLabelGrid.nrNonEmpty(); ++i) {
            TableItem item = this.wToLabelGrid.table.getItem(i);
            LabelField labelField = new LabelField();
            labelField.setLabelField(item.getText(1));
            labelField.setLabel(item.getText(2));
            toNodeLabels.add(labelField);
        }
        this.input.getNodeToField().setLabels(toNodeLabels);
        int nbFromPropLines = this.wFromPropsGrid.nrNonEmpty();
        ArrayList<PropertyField> fromNodeProps = new ArrayList<PropertyField>();
        for (int i = 0; i < nbFromPropLines; ++i) {
            TableItem item = this.wFromPropsGrid.table.getItem(i);
            PropertyField nodePropertyField = new PropertyField();
            nodePropertyField.setPropertyValue(item.getText(1));
            nodePropertyField.setPropertyName(item.getText(2));
            nodePropertyField.setPropertyType(item.getText(3));
            nodePropertyField.setPropertyPrimary("Y".equalsIgnoreCase(item.getText(4)));
            fromNodeProps.add(nodePropertyField);
        }
        this.input.getNodeFromField().setProperties(fromNodeProps);
        ArrayList<PropertyField> toNodeProps = new ArrayList<PropertyField>();
        for (int i = 0; i < this.wToPropsGrid.nrNonEmpty(); ++i) {
            TableItem item = this.wToPropsGrid.table.getItem(i);
            PropertyField nodePropertyField = new PropertyField();
            nodePropertyField.setPropertyValue(item.getText(1));
            nodePropertyField.setPropertyName(item.getText(2));
            nodePropertyField.setPropertyType(item.getText(3));
            nodePropertyField.setPropertyPrimary("Y".equalsIgnoreCase(item.getText(4)));
            toNodeProps.add(nodePropertyField);
        }
        this.input.getNodeToField().setProperties(toNodeProps);
        this.input.setRelationship(this.wRel.getText());
        this.input.setRelationshipValue(this.wRelValue.getText());
        int nbRelProps = this.wRelPropsGrid.nrNonEmpty();
        ArrayList<PropertyField> relProps = new ArrayList<PropertyField>();
        for (int i = 0; i < nbRelProps; ++i) {
            TableItem item = this.wRelPropsGrid.table.getItem(i);
            PropertyField relPropField = new PropertyField();
            relPropField.setPropertyValue(item.getText(1));
            relPropField.setPropertyName(item.getText(2));
            relPropField.setPropertyType(item.getText(3));
            relProps.add(relPropField);
        }
        this.input.setRelProps(relProps);
        this.transformMeta.setChanged();
        this.validateAndWarn(this.input);
        this.dispose();
    }

    private void validateAndWarn(Neo4JOutputMeta input) {
        boolean dynamicTo;
        boolean dynamicFrom;
        StringBuffer message = new StringBuffer();
        boolean bl = dynamicFrom = input.dynamicFromLabels() && input.isUsingCreate();
        if (dynamicFrom) {
            message.append(Const.CR);
            message.append(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.Warning.SortDynamicFromLabels", (String[])new String[]{Const.CR}));
        }
        boolean bl2 = dynamicTo = input.dynamicToLabels() && input.isUsingCreate();
        if (dynamicTo) {
            message.append(Const.CR);
            message.append(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.Warning.SortDynamicToLabels", (String[])new String[]{Const.CR}));
        }
        if (input.isOnlyCreatingRelationships() && input.isCreatingRelationships() && (input.dynamicFromLabels() || input.dynamicToLabels())) {
            message.append(Const.CR);
            message.append(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.Warning.SortDynamicRelationshipLabel", (String[])new String[]{Const.CR}));
        }
        try {
            IHopMetadataSerializer connectionSerializer = this.metadataProvider.getSerializer(NeoConnection.class);
            NeoConnection connection = (NeoConnection)connectionSerializer.load(input.getConnection());
            if (connection == null) {
                message.append(Const.CR);
                message.append(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.Warning.ReferencedNeo4jConnectionDoesntExist", (String[])new String[]{input.getConnection(), Const.CR}));
            }
        }
        catch (Exception e) {
            message.append("There was an error verifying the existence of the used Neo4j connection").append(Const.CR).append(Const.getStackTracker((Throwable)e)).append(Const.CR);
        }
        if (input.isCreatingIndexes() && (input.dynamicFromLabels() || input.dynamicToLabels())) {
            message.append(Const.CR);
            message.append(BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.Warning.CreateIndexesIsLimited", (String[])new String[]{Const.CR}));
        }
        if (message.length() > 0 && "Y".equalsIgnoreCase(this.props.getCustomParameter(STRING_DYNAMIC_LABELS_WARNING, "Y"))) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.DynamicLabelsWarning.DialogTitle", (String[])new String[0]), String.valueOf(message) + Const.CR, 8, new String[]{BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.DynamicLabelsWarning.Understood", (String[])new String[0])}, BaseMessages.getString(PKG, (String)"Neo4JOutputDialog.DynamicLabelsWarning.HideNextTime", (String[])new String[0]), "N".equalsIgnoreCase(this.props.getCustomParameter(STRING_DYNAMIC_LABELS_WARNING, "Y")));
            md.open();
            this.props.setCustomParameter(STRING_DYNAMIC_LABELS_WARNING, md.getToggleState() ? "N" : "Y");
        }
    }

    private void get(int button) {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                switch (button) {
                    case 0: {
                        BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFromLabelGrid, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, null);
                        break;
                    }
                    case 1: {
                        BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFromPropsGrid, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, (item, valueMeta) -> Neo4JOutputDialog.getPropertyNameTypePrimary(item, valueMeta, new int[]{2}, new int[]{3}, 4));
                        break;
                    }
                    case 2: {
                        BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wToLabelGrid, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, null);
                        break;
                    }
                    case 3: {
                        BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wToPropsGrid, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, (item, valueMeta) -> Neo4JOutputDialog.getPropertyNameTypePrimary(item, valueMeta, new int[]{2}, new int[]{3}, 4));
                        break;
                    }
                    case 4: {
                        BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wRelPropsGrid, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, (item, valueMeta) -> Neo4JOutputDialog.getPropertyNameTypePrimary(item, valueMeta, new int[]{2}, new int[]{3}, 4));
                    }
                }
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SelectValuesDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SelectValuesDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public static boolean getPropertyNameTypePrimary(TableItem item, IValueMeta valueMeta, int[] nameColumns, int[] typeColumns, int primaryColumn) {
        for (int nameColumn : nameColumns) {
            String propertyName = Neo4jUtil.standardizePropertyName(valueMeta);
            item.setText(nameColumn, propertyName);
        }
        for (int typeColumn : typeColumns) {
            GraphPropertyType type = GraphPropertyType.getTypeFromHop(valueMeta);
            item.setText(typeColumn, type.name());
        }
        if (primaryColumn > 0) {
            item.setText(primaryColumn, "N");
        }
        return true;
    }
}

