/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaTypeConverter;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@io.swagger.v3.oas.annotations.media.Schema(description="Schema")
public class Schema
implements Comparable<Schema> {
    public static final String SUBJECT_DESC = "Name of the subject";
    public static final String SUBJECT_EXAMPLE = "User";
    public static final String VERSION_DESC = "Version number";
    public static final String VERSION_EXAMPLE = "1";
    public static final String ID_DESC = "Globally unique identifier of the schema";
    public static final String ID_EXAMPLE = "100001";
    public static final String TYPE_DESC = "Schema type";
    public static final String TYPE_EXAMPLE = "AVRO";
    public static final String REFERENCES_DESC = "References to other schemas";
    public static final String METADATA_DESC = "User-defined metadata";
    public static final String RULESET_DESC = "Schema rule set";
    public static final String SCHEMA_DESC = "Schema definition string";
    public static final String SCHEMA_EXAMPLE = "{\"schema\": \"{\"type\": \"string\"}\"}";
    private String subject;
    private Integer version;
    private Integer id;
    private String schemaType;
    private List<SchemaReference> references;
    private Metadata metadata;
    private RuleSet ruleSet;
    private String schema;

    @JsonCreator
    public Schema(@JsonProperty(value="subject") String subject, @JsonProperty(value="version") Integer version, @JsonProperty(value="id") Integer id, @JsonProperty(value="schemaType") String schemaType, @JsonProperty(value="references") List<SchemaReference> references, @JsonProperty(value="metadata") Metadata metadata, @JsonProperty(value="ruleset") RuleSet ruleSet, @JsonProperty(value="schema") String schema) {
        this.subject = subject;
        this.version = version;
        this.id = id;
        this.schemaType = schemaType != null ? schemaType : TYPE_EXAMPLE;
        this.references = references != null ? references : Collections.emptyList();
        this.metadata = metadata;
        this.ruleSet = ruleSet;
        this.schema = schema;
    }

    public Schema(@JsonProperty(value="subject") String subject, @JsonProperty(value="version") Integer version, @JsonProperty(value="id") Integer id, @JsonProperty(value="schemaType") String schemaType, @JsonProperty(value="references") List<SchemaReference> references, @JsonProperty(value="schema") String schema) {
        this.subject = subject;
        this.version = version;
        this.id = id;
        this.schemaType = schemaType != null ? schemaType : TYPE_EXAMPLE;
        this.references = references != null ? references : Collections.emptyList();
        this.metadata = null;
        this.ruleSet = null;
        this.schema = schema;
    }

    public Schema(String subject, SchemaMetadata schemaMetadata) {
        this.subject = subject;
        this.version = schemaMetadata.getVersion();
        this.id = schemaMetadata.getId();
        this.schemaType = schemaMetadata.getSchemaType() != null ? schemaMetadata.getSchemaType() : TYPE_EXAMPLE;
        this.references = schemaMetadata.getReferences() != null ? schemaMetadata.getReferences() : Collections.emptyList();
        this.metadata = schemaMetadata.getMetadata();
        this.ruleSet = schemaMetadata.getRuleSet();
        this.schema = schemaMetadata.getSchema();
    }

    public Schema(String subject, Integer version, Integer id, SchemaString schemaString) {
        this.subject = subject;
        this.version = version;
        this.id = id;
        this.schemaType = schemaString.getSchemaType() != null ? schemaString.getSchemaType() : TYPE_EXAMPLE;
        this.references = schemaString.getReferences() != null ? schemaString.getReferences() : Collections.emptyList();
        this.metadata = schemaString.getMetadata();
        this.ruleSet = schemaString.getRuleSet();
        this.schema = schemaString.getSchemaString();
    }

    public Schema(String subject, Integer version, Integer id, ParsedSchema schema) {
        this.subject = subject;
        this.version = version;
        this.id = id;
        this.schemaType = schema.schemaType() != null ? schema.schemaType() : TYPE_EXAMPLE;
        this.references = schema.references() != null ? schema.references() : Collections.emptyList();
        this.metadata = schema.metadata();
        this.ruleSet = schema.ruleSet();
        this.schema = schema.canonicalString();
    }

    public Schema(String subject, Integer version, Integer id) {
        this.subject = subject;
        this.version = version;
        this.id = id;
    }

    public Schema(String subject, Integer id) {
        this.subject = subject;
        this.id = id;
    }

    public Schema(String subject, RegisterSchemaRequest request) {
        this.subject = subject;
        this.version = request.getVersion() != null ? request.getVersion() : 0;
        this.id = request.getId() != null ? request.getId() : -1;
        this.schemaType = request.getSchemaType() != null ? request.getSchemaType() : TYPE_EXAMPLE;
        this.references = request.getReferences() != null ? request.getReferences() : Collections.emptyList();
        this.metadata = request.getMetadata();
        this.ruleSet = request.getRuleSet();
        this.schema = request.getSchema();
    }

    public Schema(String subject, RegisterSchemaResponse response) {
        this.subject = subject;
        this.version = response.getVersion() != null ? response.getVersion() : 0;
        this.id = response.getId();
        this.schemaType = response.getSchemaType() != null ? response.getSchemaType() : TYPE_EXAMPLE;
        this.references = response.getReferences() != null ? response.getReferences() : Collections.emptyList();
        this.metadata = response.getMetadata();
        this.ruleSet = response.getRuleSet();
        this.schema = response.getSchema();
    }

    public Schema copy() {
        return new Schema(this.subject, this.version, this.id, this.schemaType, this.references, this.metadata, this.ruleSet, this.schema);
    }

    public Schema copy(Integer version, Integer id) {
        return new Schema(this.subject, version, id, this.schemaType, this.references, this.metadata, this.ruleSet, this.schema);
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Name of the subject", example="User")
    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Version number", example="1")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Globally unique identifier of the schema", example="100001")
    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Schema type", example="AVRO")
    @JsonProperty(value="schemaType")
    @JsonSerialize(converter=SchemaTypeConverter.class)
    public String getSchemaType() {
        return this.schemaType;
    }

    @JsonProperty(value="schemaType")
    public void setSchemaType(String schemaType) {
        this.schemaType = schemaType;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="References to other schemas")
    @JsonProperty(value="references")
    public List<SchemaReference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    public void setReferences(List<SchemaReference> references) {
        this.references = references;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="User-defined metadata")
    @JsonProperty(value="metadata")
    public Metadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Schema rule set")
    @JsonProperty(value="ruleSet")
    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    @JsonProperty(value="ruleSet")
    public void setRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Schema definition string", example="{\"schema\": \"{\"type\": \"string\"}\"}")
    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    public void setSchema(String schema) {
        this.schema = schema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema schema1 = (Schema)o;
        return Objects.equals(this.subject, schema1.subject) && Objects.equals(this.version, schema1.version) && Objects.equals(this.id, schema1.id) && Objects.equals(this.schemaType, schema1.schemaType) && Objects.equals(this.references, schema1.references) && Objects.equals(this.metadata, schema1.metadata) && Objects.equals(this.ruleSet, schema1.ruleSet) && Objects.equals(this.schema, schema1.schema);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.version, this.id, this.schemaType, this.references, this.metadata, this.ruleSet, this.schema);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{subject=" + this.subject + ",");
        sb.append("version=" + this.version + ",");
        sb.append("id=" + this.id + ",");
        sb.append("schemaType=" + this.schemaType + ",");
        sb.append("references=" + this.references + ",");
        sb.append("metadata=" + this.metadata + ",");
        sb.append("ruleSet=" + this.ruleSet + ",");
        sb.append("schema=" + this.schema + "}");
        return sb.toString();
    }

    @Override
    public int compareTo(Schema that) {
        int result = this.subject.compareTo(that.subject);
        if (result != 0) {
            return result;
        }
        result = this.version - that.version;
        return result;
    }

    public void updateHash(MessageDigest md) {
        if (this.schema != null) {
            md.update(this.schema.getBytes(StandardCharsets.UTF_8));
        }
        if (this.references != null) {
            this.references.forEach(r -> r.updateHash(md));
        }
        if (this.metadata != null) {
            md.update((byte)1);
            this.metadata.updateHash(md);
        }
        if (this.ruleSet != null) {
            md.update((byte)1);
            this.ruleSet.updateHash(md);
        }
    }
}

