/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.jdbc.types;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;

public final class INET
implements SQLData {
    private String inet;

    @Override
    public String getSQLTypeName() {
        return "inet";
    }

    @Override
    public void readSQL(SQLInput sQLInput, String string) throws SQLException {
        if (!"inet".equals(string)) {
            throw new SQLException("can only use this class with 'inet' type", "M1M05");
        }
        this.inet = sQLInput.readString();
    }

    @Override
    public void writeSQL(SQLOutput sQLOutput) throws SQLException {
        sQLOutput.writeString(this.inet);
    }

    public String toString() {
        return this.inet;
    }

    public void fromString(String string) throws SQLException {
        String[] stringArray;
        if (string == null) {
            this.inet = string;
            return;
        }
        String string2 = string;
        int n = string.indexOf(47);
        if (n != -1) {
            int n2;
            try {
                n2 = Integer.parseInt(string.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLDataException("cannot parse netmask bits: " + string.substring(n + 1), "22M29");
            }
            if (n2 <= 0 || n2 > 32) {
                throw new SQLDataException("netmask must be >0 and <32", "22M29");
            }
            string2 = string.substring(0, n);
        }
        if ((stringArray = string2.split("\\.")).length != 4) {
            throw new SQLDataException("expected dotted quad (xxx.xxx.xxx.xxx)", "22M29");
        }
        for (int i = 0; i < 4; ++i) {
            int n3;
            try {
                n3 = Integer.parseInt(stringArray[i]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLDataException("cannot parse number: " + stringArray[i], "22M29");
            }
            if (n3 >= 0 && n3 <= 255) continue;
            throw new SQLDataException("value must be between 0 and 255: " + stringArray[i], "22M29");
        }
        this.inet = string;
    }

    public String getAddress() {
        if (this.inet == null) {
            return null;
        }
        int n = this.inet.indexOf(47);
        if (n != -1) {
            return this.inet.substring(0, n);
        }
        return this.inet;
    }

    public void setAddress(String string) throws Exception {
        if (string == null) {
            this.inet = string;
            return;
        }
        if (string.indexOf(47) != -1) {
            throw new Exception("IPv4 address cannot contain '/' (use fromString() instead)");
        }
        this.fromString(string);
    }

    public int getNetmaskBits() throws SQLException {
        if (this.inet == null) {
            return 0;
        }
        int n = this.inet.indexOf(47);
        if (n == -1) {
            return 32;
        }
        try {
            return Integer.parseInt(this.inet.substring(n + 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLDataException("cannot parse netmask bits: " + this.inet.substring(n + 1), "22M29");
        }
    }

    public void setNetmaskBits(int n) throws Exception {
        int n2;
        String string = this.inet;
        string = string == null ? "0.0.0.0/" + n : ((n2 = string.indexOf(47)) != -1 ? string.substring(0, n2 + 1) + n : string + "/" + n);
        this.fromString(string);
    }

    public InetAddress getInetAddress() throws SQLException {
        if (this.inet == null) {
            return null;
        }
        try {
            return InetAddress.getByName(this.getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            throw new SQLDataException("could not resolve IP address", "22M29");
        }
    }

    public void setInetAddress(InetAddress inetAddress) throws Exception {
        if (!(inetAddress instanceof Inet4Address)) {
            throw new Exception("only IPv4 are supported currently");
        }
        this.fromString(inetAddress.getHostAddress());
    }
}

