/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class TreeNode {
    private String label;
    private Image image;
    private List<TreeNode> children = new ArrayList<TreeNode>();
    private Font font;
    private Color foreground;
    private Color background;
    private boolean expanded = false;
    private boolean hidden = false;
    private Map<String, Object> data = new HashMap<String, Object>();
    private int index = -1;

    public TreeNode() {
    }

    public TreeNode(String label, Image image, boolean expanded) {
        this.label = label;
        this.image = image;
        this.expanded = expanded;
    }

    public List<TreeNode> getChildren() {
        return this.children;
    }

    public void addChild(TreeNode treeNode) {
        this.children.add(treeNode);
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public void removeAll() {
        this.children.clear();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setData(String key, Object value) {
        this.data.put(key, value);
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

