/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.PxRepSV;
import com.ibm.as400.access.PxReqSV;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.Verbose;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.SocketException;

class PSTunnelConnection {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private boolean closed_ = false;
    private long connectionId_;
    private PrintWriter trace_;

    public PSTunnelConnection(long connectionId) {
        this.connectionId_ = connectionId;
        if (Trace.isTraceProxyOn()) {
            this.trace_ = Trace.getPrintWriter();
            Trace.log(6, "Px server tunnel connection " + this + " opened.");
        }
    }

    public void close() {
        this.closed_ = true;
        if (Trace.isTraceProxyOn()) {
            Trace.log(6, "Px server tunnel connection " + this + " closed.");
        }
        Verbose.println(ResourceBundleLoader.getText("PROXY_CONNECTION_CLOSED", Long.toString(this.connectionId_)));
    }

    protected void finalize() throws Throwable {
        if (!this.closed_) {
            this.close();
        }
        super.finalize();
    }

    private void handleIOException(IOException e) {
        if (Trace.isTraceErrorOn() && (!(e instanceof SocketException) && !(e instanceof EOFException) || e.getMessage() != null && e.getMessage().indexOf("JVM_recv") < 0)) {
            Trace.log(2, "IOException in PSConnection", (Throwable)e);
        }
        if (!this.closed_) {
            this.close();
        }
    }

    public void runRequest(PxReqSV request, OutputStream outputStream) {
        PxRepSV reply = request.process();
        if (reply != null) {
            reply.setCorrelationId(request.getCorrelationId());
            reply.setClientId(request.getClientId());
            this.sendTunneling(reply, outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTunneling(PxRepSV reply, OutputStream outputStream) {
        block6: {
            try {
                if (reply == null) break block6;
                OutputStream outputStream2 = outputStream;
                synchronized (outputStream2) {
                    if (Trace.isTraceProxyOn()) {
                        reply.dump(this.trace_);
                    }
                    reply.writeTo(outputStream);
                    outputStream.flush();
                }
            }
            catch (IOException e) {
                this.handleIOException(e);
            }
        }
    }
}

