/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.beam.model.jobmanagement.v1.ArtifactApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.metrics.MetricsPusher;
import org.apache.beam.runners.flink.FlinkBatchPortablePipelineTranslator;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.FlinkPortablePipelineTranslator;
import org.apache.beam.runners.flink.FlinkPortableRunnerResult;
import org.apache.beam.runners.flink.FlinkStreamingPortablePipelineTranslator;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.fnexecution.translation.PipelineTranslatorUtils;
import org.apache.beam.runners.jobsubmission.PortablePipelineJarUtils;
import org.apache.beam.runners.jobsubmission.PortablePipelineResult;
import org.apache.beam.runners.jobsubmission.PortablePipelineRunner;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.metrics.MetricsOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.SdkHarnessOptions;
import org.apache.beam.sdk.util.construction.PipelineOptionsTranslation;
import org.apache.beam.sdk.util.construction.resources.PipelineResources;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.Struct;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.flink.api.common.JobExecutionResult;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkPipelineRunner
implements PortablePipelineRunner {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FlinkPipelineRunner.class);
    private final @UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions pipelineOptions;
    private final @UnknownKeyFor @NonNull @Initialized String confDir;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> filesToStage;

    public FlinkPipelineRunner(@UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions pipelineOptions, @Nullable @UnknownKeyFor @Initialized String confDir, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> filesToStage) {
        this.pipelineOptions = pipelineOptions;
        this.confDir = pipelineOptions.getFlinkConfDir() != null ? pipelineOptions.getFlinkConfDir() : confDir;
        this.filesToStage = filesToStage;
    }

    public @UnknownKeyFor @NonNull @Initialized PortablePipelineResult run(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo) throws @UnknownKeyFor @NonNull @Initialized Exception {
        MetricsEnvironment.setMetricsSupported((boolean)false);
        SdkHarnessOptions.getConfiguredLoggerFromOptions((SdkHarnessOptions)((SdkHarnessOptions)this.pipelineOptions.as(SdkHarnessOptions.class)));
        FlinkPortablePipelineTranslator<FlinkStreamingPortablePipelineTranslator.StreamingTranslationContext> translator = !this.pipelineOptions.isStreaming() && !PipelineTranslatorUtils.hasUnboundedPCollections((RunnerApi.Pipeline)pipeline) ? FlinkBatchPortablePipelineTranslator.createTranslator() : new FlinkStreamingPortablePipelineTranslator();
        return this.runPipelineWithTranslator(pipeline, jobInfo, translator);
    }

    private <T extends FlinkPortablePipelineTranslator.TranslationContext> @UnknownKeyFor @NonNull @Initialized PortablePipelineResult runPipelineWithTranslator(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo, @UnknownKeyFor @NonNull @Initialized FlinkPortablePipelineTranslator<T> translator) throws @UnknownKeyFor @NonNull @Initialized Exception {
        LOG.info("Translating pipeline to Flink program.");
        FlinkPortablePipelineTranslator.Executor executor = translator.translate(translator.createTranslationContext(jobInfo, this.pipelineOptions, this.confDir, this.filesToStage), translator.prepareForTranslation(pipeline));
        JobExecutionResult result = executor.execute(this.pipelineOptions.getJobName());
        return this.createPortablePipelineResult(result, this.pipelineOptions);
    }

    private @UnknownKeyFor @NonNull @Initialized PortablePipelineResult createPortablePipelineResult(@UnknownKeyFor @NonNull @Initialized JobExecutionResult result, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        String resultClassName = result.getClass().getCanonicalName();
        if (resultClassName.equals("org.apache.flink.core.execution.DetachedJobExecutionResult")) {
            LOG.info("Pipeline submitted in Detached mode");
            return new FlinkPortableRunnerResult.Detached();
        }
        LOG.info("Execution finished in {} msecs", (Object)result.getNetRuntime());
        Map accumulators = result.getAllAccumulatorResults();
        if (accumulators != null && !accumulators.isEmpty()) {
            LOG.info("Final accumulator values:");
            for (Map.Entry entry : result.getAllAccumulatorResults().entrySet()) {
                LOG.info("{} : {}", entry.getKey(), entry.getValue());
            }
        }
        FlinkPortableRunnerResult flinkRunnerResult = new FlinkPortableRunnerResult(accumulators, result.getNetRuntime());
        MetricsPusher metricsPusher = new MetricsPusher(flinkRunnerResult.getMetricsContainerStepMap(), (MetricsOptions)options.as(MetricsOptions.class), (PipelineResult)flinkRunnerResult);
        metricsPusher.start();
        return flinkRunnerResult;
    }

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) throws @UnknownKeyFor @NonNull @Initialized Exception {
        FileSystems.setDefaultPipelineOptions((PipelineOptions)PipelineOptionsFactory.create());
        FlinkPipelineRunnerConfiguration configuration = FlinkPipelineRunner.parseArgs(args);
        String baseJobName = configuration.baseJobName == null ? PortablePipelineJarUtils.getDefaultJobName() : configuration.baseJobName;
        Preconditions.checkArgument((baseJobName != null ? 1 : 0) != 0, (Object)"No default job name found. Job name must be set using --base-job-name.");
        RunnerApi.Pipeline pipeline = PortablePipelineJarUtils.getPipelineFromClasspath((String)baseJobName);
        Struct originalOptions = PortablePipelineJarUtils.getPipelineOptionsFromClasspath((String)baseJobName);
        String retrievalToken = (String)ArtifactApi.CommitManifestResponse.Constants.NO_ARTIFACTS_STAGED_TOKEN.getValueDescriptor().getOptions().getExtension(RunnerApi.beamConstant);
        FlinkPipelineOptions flinkOptions = (FlinkPipelineOptions)PipelineOptionsTranslation.fromProto((Struct)originalOptions).as(FlinkPipelineOptions.class);
        String invocationId = String.format("%s_%s", flinkOptions.getJobName(), UUID.randomUUID().toString());
        FlinkPipelineRunner runner = new FlinkPipelineRunner(flinkOptions, configuration.flinkConfDir, PipelineResources.detectClassPathResourcesToStage((ClassLoader)FlinkPipelineRunner.class.getClassLoader(), (PipelineOptions)flinkOptions));
        JobInfo jobInfo = JobInfo.create((String)invocationId, (String)flinkOptions.getJobName(), (String)retrievalToken, (Struct)PipelineOptionsTranslation.toProto((PipelineOptions)flinkOptions));
        try {
            runner.run(pipeline, jobInfo);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Job %s failed.", invocationId), e);
        }
        LOG.info("Job {} finished successfully.", (Object)invocationId);
    }

    private static @UnknownKeyFor @NonNull @Initialized FlinkPipelineRunnerConfiguration parseArgs(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        FlinkPipelineRunnerConfiguration configuration = new FlinkPipelineRunnerConfiguration();
        CmdLineParser parser = new CmdLineParser((Object)configuration);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            LOG.error("Unable to parse command line arguments.", (Throwable)e);
            parser.printUsage((OutputStream)System.err);
            throw new IllegalArgumentException("Unable to parse command line arguments.", e);
        }
        return configuration;
    }

    private static class FlinkPipelineRunnerConfiguration {
        @Option(name="--flink-conf-dir", usage="Directory containing Flink YAML configuration files. These properties will be set to all jobs submitted to Flink and take precedence over configurations in FLINK_CONF_DIR.")
        private @UnknownKeyFor @NonNull @Initialized String flinkConfDir = null;
        @Option(name="--base-job-name", usage="The job to run. This must correspond to a subdirectory of the jar's BEAM-PIPELINE directory. *Only needs to be specified if the jar contains multiple pipelines.*")
        private @UnknownKeyFor @NonNull @Initialized String baseJobName = null;

        private FlinkPipelineRunnerConfiguration() {
        }
    }
}

