/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.SqlTypes;
import org.apache.beam.sdk.util.AutoValue_RowJson_RowJsonDeserializer_FieldValue;
import org.apache.beam.sdk.util.RowJsonValueExtractors;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.ReadableInstant;

public class RowJson {
    private static final @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized Schema.TypeName> SUPPORTED_TYPES = ImmutableSet.of((Object)((Object)Schema.TypeName.BYTE), (Object)((Object)Schema.TypeName.INT16), (Object)((Object)Schema.TypeName.INT32), (Object)((Object)Schema.TypeName.INT64), (Object)((Object)Schema.TypeName.FLOAT), (Object)((Object)Schema.TypeName.DOUBLE), (Object[])new Schema.TypeName[]{Schema.TypeName.BOOLEAN, Schema.TypeName.STRING, Schema.TypeName.DECIMAL, Schema.TypeName.DATETIME});
    private static final @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String> KNOWN_LOGICAL_TYPE_IDENTIFIERS = ImmutableSet.of((Object)SqlTypes.DATE.getIdentifier(), (Object)SqlTypes.TIME.getIdentifier(), (Object)SqlTypes.DATETIME.getIdentifier());

    public static void verifySchemaSupported(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        ImmutableList<UnsupportedField> unsupportedFields = RowJson.findUnsupportedFields(schema);
        if (!unsupportedFields.isEmpty()) {
            throw new UnsupportedRowJsonException(String.format("Field type%s %s not supported when converting between JSON and Rows. Supported types are: %s", unsupportedFields.size() > 1 ? "s" : "", unsupportedFields.toString(), SUPPORTED_TYPES.toString()));
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized UnsupportedField> findUnsupportedFields(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return (ImmutableList)schema.getFields().stream().flatMap(field -> RowJson.findUnsupportedFields(field).stream()).collect(ImmutableList.toImmutableList());
    }

    private static @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized UnsupportedField> findUnsupportedFields(@UnknownKeyFor @NonNull @Initialized Schema.Field field) {
        return RowJson.findUnsupportedFields(field.getType(), field.getName());
    }

    private static @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized UnsupportedField> findUnsupportedFields(@UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, @UnknownKeyFor @NonNull @Initialized String fieldName) {
        Schema.TypeName fieldTypeName = fieldType.getTypeName();
        if (fieldTypeName.isCompositeType()) {
            return (ImmutableList)fieldType.getRowSchema().getFields().stream().flatMap(field -> RowJson.findUnsupportedFields(field.getType(), fieldName + "." + field.getName()).stream()).collect(ImmutableList.toImmutableList());
        }
        if (fieldTypeName.isCollectionType()) {
            return RowJson.findUnsupportedFields(fieldType.getCollectionElementType(), fieldName + "[]");
        }
        if (fieldTypeName.isLogicalType()) {
            if (KNOWN_LOGICAL_TYPE_IDENTIFIERS.contains((Object)fieldType.getLogicalType().getIdentifier())) {
                return ImmutableList.of();
            }
            return RowJson.findUnsupportedFields(fieldType.getLogicalType().getBaseType(), fieldName);
        }
        if (!SUPPORTED_TYPES.contains((Object)fieldTypeName)) {
            return ImmutableList.of((Object)new UnsupportedField(fieldName, fieldTypeName));
        }
        return ImmutableList.of();
    }

    public static class UnsupportedRowJsonException
    extends RuntimeException {
        UnsupportedRowJsonException(@UnknownKeyFor @NonNull @Initialized String message, @UnknownKeyFor @NonNull @Initialized Throwable reason) {
            super(message, reason);
        }

        UnsupportedRowJsonException(@UnknownKeyFor @NonNull @Initialized String message) {
            super(message);
        }
    }

    public static class RowJsonSerializer
    extends StdSerializer<Row> {
        private final @UnknownKeyFor @NonNull @Initialized Schema schema;
        private @UnknownKeyFor @NonNull @Initialized Boolean dropNullsOnWrite = false;

        public static @UnknownKeyFor @NonNull @Initialized RowJsonSerializer forSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            RowJson.verifySchemaSupported(schema);
            return new RowJsonSerializer(schema);
        }

        private RowJsonSerializer(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            super(Row.class);
            this.schema = schema;
        }

        public @UnknownKeyFor @NonNull @Initialized RowJsonSerializer withDropNullsOnWrite(@UnknownKeyFor @NonNull @Initialized Boolean dropNullsOnWrite) {
            this.dropNullsOnWrite = dropNullsOnWrite;
            return this;
        }

        public void serialize(@UnknownKeyFor @NonNull @Initialized Row value, @UnknownKeyFor @NonNull @Initialized JsonGenerator gen, @UnknownKeyFor @NonNull @Initialized SerializerProvider provider) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.writeRow(value, this.schema, gen);
        }

        private void writeRow(@UnknownKeyFor @NonNull @Initialized Row row, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized JsonGenerator gen) throws @UnknownKeyFor @NonNull @Initialized IOException {
            gen.writeStartObject();
            for (int i = 0; i < schema.getFieldCount(); ++i) {
                Schema.Field field = schema.getField(i);
                Object value = row.getValue(i);
                if (this.dropNullsOnWrite.booleanValue() && value == null && field.getType().getNullable().booleanValue()) continue;
                gen.writeFieldName(field.getName());
                if (field.getType().getNullable().booleanValue() && value == null) {
                    gen.writeNull();
                    continue;
                }
                this.writeValue(gen, field.getType(), value);
            }
            gen.writeEndObject();
        }

        private void writeValue(@UnknownKeyFor @NonNull @Initialized JsonGenerator gen, @UnknownKeyFor @NonNull @Initialized Schema.FieldType type, @UnknownKeyFor @NonNull @Initialized Object value) throws @UnknownKeyFor @NonNull @Initialized IOException {
            switch (type.getTypeName()) {
                case BOOLEAN: {
                    gen.writeBoolean(((Boolean)value).booleanValue());
                    break;
                }
                case STRING: {
                    gen.writeString((String)value);
                    break;
                }
                case BYTE: {
                    gen.writeNumber((short)((Byte)value).byteValue());
                    break;
                }
                case DOUBLE: {
                    gen.writeNumber(((Double)value).doubleValue());
                    break;
                }
                case FLOAT: {
                    gen.writeNumber(((Float)value).floatValue());
                    break;
                }
                case INT16: {
                    gen.writeNumber(((Short)value).shortValue());
                    break;
                }
                case INT32: {
                    gen.writeNumber(((Integer)value).intValue());
                    break;
                }
                case INT64: {
                    gen.writeNumber(((Long)value).longValue());
                    break;
                }
                case DECIMAL: {
                    gen.writeNumber((BigDecimal)value);
                    break;
                }
                case DATETIME: {
                    gen.writeString(((ReadableInstant)value).toString());
                    break;
                }
                case ARRAY: 
                case ITERABLE: {
                    gen.writeStartArray();
                    for (Object element : (Iterable)value) {
                        this.writeValue(gen, type.getCollectionElementType(), element);
                    }
                    gen.writeEndArray();
                    break;
                }
                case ROW: {
                    this.writeRow((Row)value, type.getRowSchema(), gen);
                    break;
                }
                case LOGICAL_TYPE: {
                    String identifier = type.getLogicalType().getIdentifier();
                    if (SqlTypes.DATE.getIdentifier().equals(identifier)) {
                        gen.writeString(((LocalDate)value).toString());
                        break;
                    }
                    if (SqlTypes.TIME.getIdentifier().equals(identifier)) {
                        gen.writeString(((LocalTime)value).toString());
                        break;
                    }
                    if (SqlTypes.DATETIME.getIdentifier().equals(identifier)) {
                        gen.writeString(((LocalDateTime)value).toString());
                        break;
                    }
                    this.writeValue(gen, type.getLogicalType().getBaseType(), value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported field type: " + type);
                }
            }
        }
    }

    public static class RowJsonDeserializer
    extends StdDeserializer<Row> {
        private static final @UnknownKeyFor @NonNull @Initialized boolean SEQUENTIAL = false;
        private static final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Schema.TypeName, @UnknownKeyFor @NonNull @Initialized RowJsonValueExtractors.ValueExtractor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> JSON_VALUE_GETTERS = ImmutableMap.builder().put((Object)Schema.TypeName.BYTE, RowJsonValueExtractors.byteValueExtractor()).put((Object)Schema.TypeName.INT16, RowJsonValueExtractors.shortValueExtractor()).put((Object)Schema.TypeName.INT32, RowJsonValueExtractors.intValueExtractor()).put((Object)Schema.TypeName.INT64, RowJsonValueExtractors.longValueExtractor()).put((Object)Schema.TypeName.FLOAT, RowJsonValueExtractors.floatValueExtractor()).put((Object)Schema.TypeName.DOUBLE, RowJsonValueExtractors.doubleValueExtractor()).put((Object)Schema.TypeName.BOOLEAN, RowJsonValueExtractors.booleanValueExtractor()).put((Object)Schema.TypeName.STRING, RowJsonValueExtractors.stringValueExtractor()).put((Object)Schema.TypeName.DECIMAL, RowJsonValueExtractors.decimalValueExtractor()).put((Object)Schema.TypeName.DATETIME, RowJsonValueExtractors.datetimeValueExtractor()).build();
        private final @UnknownKeyFor @NonNull @Initialized Schema schema;
        private @UnknownKeyFor @NonNull @Initialized NullBehavior nullBehavior = NullBehavior.ACCEPT_MISSING_OR_NULL;

        public static @UnknownKeyFor @NonNull @Initialized RowJsonDeserializer forSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            RowJson.verifySchemaSupported(schema);
            return new RowJsonDeserializer(schema);
        }

        private RowJsonDeserializer(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            super(Row.class);
            this.schema = schema;
        }

        public @UnknownKeyFor @NonNull @Initialized RowJsonDeserializer withNullBehavior(@UnknownKeyFor @NonNull @Initialized NullBehavior behavior) {
            this.nullBehavior = behavior;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Row deserialize(@UnknownKeyFor @NonNull @Initialized JsonParser jsonParser, @UnknownKeyFor @NonNull @Initialized DeserializationContext deserializationContext) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return (Row)this.extractJsonNodeValue(FieldValue.of("root", Schema.FieldType.row(this.schema), (JsonNode)jsonParser.readValueAsTree()));
        }

        private @UnknownKeyFor @NonNull @Initialized Object extractJsonNodeValue(@UnknownKeyFor @NonNull @Initialized FieldValue fieldValue) {
            if (fieldValue.type().getNullable().booleanValue()) {
                if (!fieldValue.isJsonValuePresent()) {
                    switch (this.nullBehavior) {
                        case ACCEPT_MISSING_OR_NULL: 
                        case REQUIRE_MISSING: {
                            return null;
                        }
                        case REQUIRE_NULL: {
                            throw new UnsupportedRowJsonException("Field '" + fieldValue.name() + "' is not present in the JSON object.");
                        }
                    }
                }
                if (fieldValue.isJsonNull()) {
                    switch (this.nullBehavior) {
                        case ACCEPT_MISSING_OR_NULL: 
                        case REQUIRE_NULL: {
                            return null;
                        }
                        case REQUIRE_MISSING: {
                            throw new UnsupportedRowJsonException("Field '" + fieldValue.name() + "' has a null value in the JSON object.");
                        }
                    }
                }
            } else {
                if (!fieldValue.isJsonValuePresent()) {
                    throw new UnsupportedRowJsonException("Non-nullable field '" + fieldValue.name() + "' is not present in the JSON object.");
                }
                if (fieldValue.isJsonNull()) {
                    throw new UnsupportedRowJsonException("Non-nullable field '" + fieldValue.name() + "' has value null in the JSON object.");
                }
            }
            if (fieldValue.isRowType()) {
                return this.jsonObjectToRow(fieldValue);
            }
            if (fieldValue.isArrayType()) {
                return this.jsonArrayToList(fieldValue);
            }
            if (fieldValue.typeName().isLogicalType()) {
                String identifier = fieldValue.type().getLogicalType().getIdentifier();
                if (SqlTypes.DATE.getIdentifier().equals(identifier)) {
                    return RowJsonValueExtractors.dateValueExtractor().extractValue(fieldValue.jsonValue());
                }
                if (SqlTypes.TIME.getIdentifier().equals(identifier)) {
                    return RowJsonValueExtractors.timeValueExtractor().extractValue(fieldValue.jsonValue());
                }
                if (SqlTypes.DATETIME.getIdentifier().equals(identifier)) {
                    return RowJsonValueExtractors.localDatetimeValueExtractor().extractValue(fieldValue.jsonValue());
                }
                return this.extractJsonNodeValue(FieldValue.of(fieldValue.name(), fieldValue.type().getLogicalType().getBaseType(), fieldValue.jsonValue()));
            }
            return RowJsonDeserializer.extractJsonPrimitiveValue(fieldValue);
        }

        private @UnknownKeyFor @NonNull @Initialized Row jsonObjectToRow(@UnknownKeyFor @NonNull @Initialized FieldValue rowFieldValue) {
            if (!rowFieldValue.isJsonObject()) {
                throw new UnsupportedRowJsonException("Expected JSON object for field '" + rowFieldValue.name() + "'. Unable to convert '" + rowFieldValue.jsonValue().asText() + "' to Beam Row, it is not a JSON object. Currently only JSON objects can be parsed to Beam Rows");
            }
            return rowFieldValue.rowSchema().getFields().stream().map(schemaField -> this.extractJsonNodeValue(FieldValue.of(schemaField.getName(), schemaField.getType(), rowFieldValue.jsonFieldValue(schemaField.getName())))).collect(Row.toRow(rowFieldValue.rowSchema()));
        }

        private @UnknownKeyFor @NonNull @Initialized Object jsonArrayToList(@UnknownKeyFor @NonNull @Initialized FieldValue arrayFieldValue) {
            if (!arrayFieldValue.isJsonArray()) {
                throw new UnsupportedRowJsonException("Expected JSON array for field '" + arrayFieldValue.name() + "'. Instead got " + arrayFieldValue.jsonNodeType().name());
            }
            return arrayFieldValue.jsonArrayElements().map(jsonArrayElement -> this.extractJsonNodeValue(FieldValue.of(arrayFieldValue.name() + "[]", arrayFieldValue.arrayElementType(), jsonArrayElement))).collect(ImmutableList.toImmutableList());
        }

        private static @UnknownKeyFor @NonNull @Initialized Object extractJsonPrimitiveValue(@UnknownKeyFor @NonNull @Initialized FieldValue fieldValue) {
            try {
                return ((RowJsonValueExtractors.ValueExtractor)JSON_VALUE_GETTERS.get((Object)fieldValue.typeName())).extractValue(fieldValue.jsonValue());
            }
            catch (RuntimeException e) {
                throw new UnsupportedRowJsonException("Unable to get value from field '" + fieldValue.name() + "'. Schema type '" + (Object)((Object)fieldValue.typeName()) + "'. JSON node type " + fieldValue.jsonNodeType().name(), e);
            }
        }

        @AutoValue
        static abstract class FieldValue {
            FieldValue() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized String name();

            abstract @UnknownKeyFor @NonNull @Initialized Schema.FieldType type();

            abstract @Nullable @UnknownKeyFor @Initialized JsonNode jsonValue();

            @UnknownKeyFor @NonNull @Initialized Schema.TypeName typeName() {
                return this.type().getTypeName();
            }

            @UnknownKeyFor @NonNull @Initialized boolean isJsonValuePresent() {
                return this.jsonValue() != null;
            }

            @UnknownKeyFor @NonNull @Initialized boolean isJsonNull() {
                return this.jsonValue().isNull();
            }

            @UnknownKeyFor @NonNull @Initialized JsonNodeType jsonNodeType() {
                return this.jsonValue().getNodeType();
            }

            @UnknownKeyFor @NonNull @Initialized boolean isJsonArray() {
                return this.jsonValue().isArray();
            }

            @UnknownKeyFor @NonNull @Initialized Stream<@UnknownKeyFor @NonNull @Initialized JsonNode> jsonArrayElements() {
                return StreamSupport.stream(this.jsonValue().spliterator(), false);
            }

            @UnknownKeyFor @NonNull @Initialized boolean isArrayType() {
                return Schema.TypeName.ARRAY.equals((Object)this.type().getTypeName()) || Schema.TypeName.ITERABLE.equals((Object)this.type().getTypeName());
            }

            @UnknownKeyFor @NonNull @Initialized Schema.FieldType arrayElementType() {
                return this.type().getCollectionElementType();
            }

            @UnknownKeyFor @NonNull @Initialized boolean isJsonObject() {
                return this.jsonValue().isObject();
            }

            @UnknownKeyFor @NonNull @Initialized JsonNode jsonFieldValue(@UnknownKeyFor @NonNull @Initialized String fieldName) {
                return this.jsonValue().get(fieldName);
            }

            @UnknownKeyFor @NonNull @Initialized boolean isRowType() {
                return Schema.TypeName.ROW.equals((Object)this.type().getTypeName());
            }

            @UnknownKeyFor @NonNull @Initialized Schema rowSchema() {
                return this.type().getRowSchema();
            }

            static @UnknownKeyFor @NonNull @Initialized FieldValue of(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Schema.FieldType type, @UnknownKeyFor @NonNull @Initialized JsonNode jsonValue) {
                return new AutoValue_RowJson_RowJsonDeserializer_FieldValue(name, type, jsonValue);
            }
        }

        public static enum NullBehavior {
            ACCEPT_MISSING_OR_NULL,
            REQUIRE_NULL,
            REQUIRE_MISSING;

        }
    }

    private static class UnsupportedField {
        final @UnknownKeyFor @NonNull @Initialized String descriptor;
        final @UnknownKeyFor @NonNull @Initialized Schema.TypeName typeName;

        UnsupportedField(@UnknownKeyFor @NonNull @Initialized String descriptor, @UnknownKeyFor @NonNull @Initialized Schema.TypeName typeName) {
            this.descriptor = descriptor;
            this.typeName = typeName;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return this.descriptor + "=" + (Object)((Object)this.typeName);
        }
    }
}

