/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.state;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.CommonRange;
import org.apache.cassandra.repair.state.AbstractCompletable;
import org.apache.cassandra.repair.state.AbstractState;
import org.apache.cassandra.repair.state.JobState;
import org.apache.cassandra.utils.TimeUUID;

public class SessionState
extends AbstractState<State, TimeUUID> {
    public final TimeUUID parentRepairSession;
    public final String keyspace;
    public final String[] cfnames;
    public final CommonRange commonRange;
    private final ConcurrentMap<UUID, JobState> jobs = new ConcurrentHashMap<UUID, JobState>();
    public final Phase phase = new Phase();

    public SessionState(TimeUUID parentRepairSession, String keyspace, String[] cfnames, CommonRange commonRange) {
        super(TimeUUID.Generator.nextTimeUUID(), State.class);
        this.parentRepairSession = parentRepairSession;
        this.keyspace = keyspace;
        this.cfnames = cfnames;
        this.commonRange = commonRange;
    }

    public Collection<JobState> getJobs() {
        return this.jobs.values();
    }

    public JobState getJob(UUID id) {
        return (JobState)this.jobs.get(id);
    }

    public Set<UUID> getJobIds() {
        return this.jobs.keySet();
    }

    public Set<InetAddressAndPort> getParticipants() {
        return this.commonRange.endpoints;
    }

    public void register(JobState state) {
        this.jobs.put((UUID)state.id, state);
    }

    public final class Phase
    extends AbstractCompletable.BaseSkipPhase {
        public void start() {
            SessionState.this.updateState(State.START);
        }

        public void jobsSubmitted() {
            SessionState.this.updateState(State.JOBS_START);
        }
    }

    public static enum State {
        START,
        JOBS_START;

    }
}

