/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataInputStreamWrapper;
import org.apache.flink.core.fs.WrappingProxyCloseable;

public class FsSegmentDataInputStream
extends FSDataInputStreamWrapper
implements WrappingProxyCloseable<FSDataInputStream> {
    private final long startingPosition;
    private long endingPosition;

    public FsSegmentDataInputStream(FSDataInputStream inputStream, long startingPosition, long segmentSize) throws IOException {
        super(inputStream);
        if (startingPosition < 0L || segmentSize < 0L) {
            throw new IndexOutOfBoundsException("Invalid startingPosition/segmentSize: " + startingPosition + "/" + segmentSize);
        }
        this.startingPosition = startingPosition;
        this.endingPosition = startingPosition + segmentSize;
        inputStream.seek(startingPosition);
    }

    public int read() throws IOException {
        if (this.inputStream.getPos() >= this.endingPosition) {
            return -1;
        }
        int result = this.inputStream.read();
        if (result == -1) {
            return -1;
        }
        return result;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = (int)Math.min(Integer.MAX_VALUE, Math.min((long)len, this.endingPosition - this.inputStream.getPos()));
        if (n == 0) {
            return -1;
        }
        int ret = this.inputStream.read(b, off, n);
        if (ret < 0) {
            this.endingPosition = this.inputStream.getPos();
            return -1;
        }
        return ret;
    }

    public void seek(long desired) throws IOException {
        this.inputStream.seek(desired += this.startingPosition);
    }

    public long getPos() throws IOException {
        return this.inputStream.getPos() - this.startingPosition;
    }

    public long skip(long n) throws IOException {
        long len = Math.min(n, this.endingPosition - this.inputStream.getPos());
        return this.inputStream.skip(n);
    }

    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    public boolean markSupported() {
        return this.inputStream.markSupported();
    }
}

