/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.util;

import java.io.PrintWriter;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import org.monetdb.util.Exporter;

public final class XMLExporter
extends Exporter {
    private boolean useNil;
    public static final short TYPE_NIL = 1;
    public static final short VALUE_OMIT = 0;
    public static final short VALUE_XSI = 1;
    private static SimpleDateFormat xsd_ts;
    private static SimpleDateFormat xsd_tstz;

    public XMLExporter(PrintWriter printWriter) {
        super(printWriter);
    }

    @Override
    public void dumpSchema(DatabaseMetaData databaseMetaData, String string, String string2, String string3) throws SQLException {
        String string4;
        if (string.endsWith("VIEW")) {
            String string5 = XMLExporter.fetchSysTablesQueryValue(databaseMetaData.getConnection(), string2, string3);
            if (string5 != null) {
                this.out.println("<!-- " + string5 + " -->");
            } else {
                this.out.println("<!-- unknown " + string + " " + XMLExporter.dq(string2) + "." + XMLExporter.dq(string3) + ": no SQL view definition found! -->");
            }
            return;
        }
        this.out.println("<xsd:schema>");
        ResultSet resultSet = databaseMetaData.getColumns(null, string2, string3, null);
        int n = resultSet.findColumn("COLUMN_NAME");
        int n2 = resultSet.findColumn("TYPE_NAME");
        int n3 = resultSet.findColumn("DATA_TYPE");
        int n4 = resultSet.findColumn("COLUMN_SIZE");
        int n5 = resultSet.findColumn("DECIMAL_DIGITS");
        HashSet<String> hashSet = new HashSet<String>();
        while (resultSet.next()) {
            switch (resultSet.getInt(n3)) {
                case 1: {
                    string4 = "CHAR_" + resultSet.getString(n4);
                    if (hashSet.contains(string4)) break;
                    hashSet.add(string4);
                    this.out.print("  <xsd:simpleType name=");
                    this.out.print(XMLExporter.dq(string4));
                    this.out.println(">");
                    this.out.println("    <xsd:restriction base=\"xsd:string\">");
                    this.out.print("      <xsd:length value=");
                    this.out.print(XMLExporter.dq(resultSet.getString(n4)));
                    this.out.println(" />");
                    this.out.println("    </xsd:restriction>");
                    this.out.println("  </xsd:simpleType>");
                    break;
                }
                case -1: 
                case 12: {
                    string4 = "VARCHAR_" + resultSet.getString(n4);
                    if (hashSet.contains(string4)) break;
                    hashSet.add(string4);
                    this.out.print("  <xsd:simpleType name=");
                    this.out.print(XMLExporter.dq(string4));
                    this.out.println(">");
                    this.out.println("    <xsd:restriction base=\"xsd:string\">");
                    this.out.print("      <xsd:maxLength value=");
                    this.out.print(XMLExporter.dq(resultSet.getString(n4)));
                    this.out.println(" />");
                    this.out.println("    </xsd:restriction>");
                    this.out.println("  </xsd:simpleType>");
                    break;
                }
                case 2005: {
                    string4 = "CLOB";
                    if (hashSet.contains(string4)) break;
                    hashSet.add(string4);
                    this.out.print("  <xsd:simpleType name=");
                    this.out.print(XMLExporter.dq(string4));
                    this.out.println(">");
                    this.out.println("    <xsd:restriction base=\"xsd:string\" />");
                    this.out.println("  </xsd:simpleType>");
                    break;
                }
                case 2: 
                case 3: {
                    string4 = "DECIMAL_" + resultSet.getString(n4) + "_" + resultSet.getString(n5);
                    if (hashSet.contains(string4)) break;
                    hashSet.add(string4);
                    this.out.print("  <xsd:simpleType name=");
                    this.out.print(XMLExporter.dq(string4));
                    this.out.println(">");
                    this.out.println("    <xsd:restriction base=\"xsd:decimal\">");
                    this.out.print("      <xsd:totalDigits value=");
                    this.out.print(XMLExporter.dq(resultSet.getString(n4)));
                    this.out.println(" />");
                    this.out.print("      <xsd:fractionDigits value=");
                    this.out.print(XMLExporter.dq(resultSet.getString(n5)));
                    this.out.println(" />");
                    this.out.println("    </xsd:restriction>");
                    this.out.println("  </xsd:simpleType>");
                    break;
                }
                case -6: {
                    string4 = "TINYINT";
                    if (hashSet.contains(string4)) break;
                    hashSet.add(string4);
                    this.out.print("  <xsd:simpleType name=");
                    this.out.print(XMLExporter.dq(string4));
                    this.out.println(">");
                    this.out.println("    <xsd:restriction base=\"xsd:byte\" />");
                    this.out.println("  </xsd:simpleType>");
                    break;
                }
                case 5: {
                    string4 = "SMALLINT";
                    if (hashSet.contains(string4)) break;
                    hashSet.add(string4);
                    this.out.print("  <xsd:simpleType name=");
                    this.out.print(XMLExporter.dq(string4));
                    this.out.println(">");
                    this.out.println("    <xsd:restriction base=\"xsd:short\" />");
                    this.out.println("  </xsd:simpleType>");
                    break;
                }
                case 4: {
                    string4 = "INTEGER";
                    if (hashSet.contains(string4)) break;
                    hashSet.add(string4);
                    this.out.print("  <xsd:simpleType name=");
                    this.out.print(XMLExporter.dq(string4));
                    this.out.println(">");
                    this.out.println("    <xsd:restriction base=\"xsd:integer\" />");
                    this.out.println("  </xsd:simpleType>");
                    break;
                }
                case -5: {
                    string4 = "BIGINT";
                    if (hashSet.contains(string4)) break;
                    hashSet.add(string4);
                    this.out.print("  <xsd:simpleType name=");
                    this.out.print(XMLExporter.dq(string4));
                    this.out.println(">");
                    this.out.println("    <xsd:restriction base=\"xsd:long\" />");
                    this.out.println("  </xsd:simpleType>");
                    break;
                }
                case -7: {
                    string4 = "BIT";
                    if (hashSet.contains(string4)) break;
                    hashSet.add(string4);
                    this.out.print("  <xsd:simpleType name=");
                    this.out.print(XMLExporter.dq(string4));
                    this.out.println(">");
                    this.out.println("    <xsd:restriction base=\"xsd:bit\" />");
                    this.out.println("  </xsd:simpleType>");
                    break;
                }
                case 16: {
                    string4 = "BOOLEAN";
                    if (hashSet.contains(string4)) break;
                    hashSet.add(string4);
                    this.out.print("  <xsd:simpleType name=");
                    this.out.print(XMLExporter.dq(string4));
                    this.out.println(">");
                    this.out.println("    <xsd:restriction base=\"xsd:boolean\" />");
                    this.out.println("  </xsd:simpleType>");
                    break;
                }
                case 91: {
                    string4 = "DATE";
                    if (hashSet.contains(string4)) break;
                    hashSet.add(string4);
                    this.out.print("  <xsd:simpleType name=");
                    this.out.print(XMLExporter.dq(string4));
                    this.out.println(">");
                    this.out.println("    <xsd:restriction base=\"xsd:date\" />");
                    this.out.println("  </xsd:simpleType>");
                    break;
                }
                case 92: 
                case 2013: {
                    string4 = "timetz".equals(resultSet.getString(n2)) ? "TIME_WTZ" : "TIME";
                    if (hashSet.contains(string4)) break;
                    hashSet.add(string4);
                    this.out.print("  <xsd:simpleType name=");
                    this.out.print(XMLExporter.dq(string4));
                    this.out.println(">");
                    this.out.println("    <xsd:restriction base=\"xsd:time\" />");
                    this.out.println("  </xsd:simpleType>");
                    break;
                }
                case 93: 
                case 2014: {
                    string4 = "timestamptz".equals(resultSet.getString(n2)) ? "TIMESTAMP_WTZ" : "TIMESTAMP";
                    if (hashSet.contains(string4)) break;
                    hashSet.add(string4);
                    this.out.print("  <xsd:simpleType name=");
                    this.out.print(XMLExporter.dq(string4));
                    this.out.println(">");
                    this.out.println("    <xsd:restriction base=\"xsd:dateTime\" />");
                    this.out.println("  </xsd:simpleType>");
                }
            }
        }
        resultSet.beforeFirst();
        String string6 = string2.replaceAll("\\.", "_x002e_") + "." + string3.replaceAll("\\.", "_x002e_");
        this.out.print("  <xsd:complexType name=");
        this.out.print(XMLExporter.dq("RowType." + string6));
        this.out.println(">");
        this.out.println("    <xsd:sequence>");
        while (resultSet.next()) {
            this.out.print("      <xsd:element name=");
            this.out.print(XMLExporter.dq(resultSet.getString(n)));
            this.out.print(" type=");
            switch (resultSet.getInt(n3)) {
                case 1: {
                    string4 = "CHAR_" + resultSet.getString(n4);
                    break;
                }
                case -1: 
                case 12: {
                    string4 = "VARCHAR_" + resultSet.getString(n4);
                    break;
                }
                case 2005: {
                    string4 = "CLOB";
                    break;
                }
                case 2: 
                case 3: {
                    string4 = "DECIMAL_" + resultSet.getString(n4) + "_" + resultSet.getString(n5);
                    break;
                }
                case -6: {
                    string4 = "TINYINT";
                    break;
                }
                case 5: {
                    string4 = "SMALLINT";
                    break;
                }
                case 4: {
                    string4 = "INTEGER";
                    break;
                }
                case -5: {
                    string4 = "BIGINT";
                    break;
                }
                case -7: {
                    string4 = "BIT";
                    break;
                }
                case 16: {
                    string4 = "BOOLEAN";
                    break;
                }
                case 91: {
                    string4 = "DATE";
                    break;
                }
                case 92: 
                case 2013: {
                    if ("timetz".equals(resultSet.getString(n2))) {
                        string4 = "TIME_WTZ";
                        break;
                    }
                    string4 = "TIME";
                    break;
                }
                case 93: 
                case 2014: {
                    if ("timestamptz".equals(resultSet.getString(n2))) {
                        string4 = "TIMESTAMP_WTZ";
                        break;
                    }
                    string4 = "TIMESTAMP";
                    break;
                }
                default: {
                    string4 = "(unknown)";
                }
            }
            this.out.print(XMLExporter.dq(string4));
            this.out.println(" />");
        }
        this.out.println("    </xsd:sequence>");
        this.out.println("  </xsd:complexType>");
        this.out.print("  <xsd:complexType name=");
        this.out.print(XMLExporter.dq("TableType." + string6));
        this.out.println(">");
        this.out.println("    <xsd:sequence>");
        this.out.print("      <xsd:element name=\"row\" type=");
        this.out.print(XMLExporter.dq("RowType." + string6));
        this.out.println(" minOccurs=\"0\" maxOccurs=\"unbounded\" />");
        this.out.println("    </xsd:sequence>");
        this.out.println("  </xsd:complexType>");
        this.out.println("</xsd:schema>");
    }

    @Override
    public void dumpResultSet(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        String string = resultSetMetaData.getSchemaName(1);
        String string2 = (string != null && !string.isEmpty() ? string + "." : "") + resultSetMetaData.getTableName(1);
        this.out.println("<" + string2 + ">");
        while (resultSet.next()) {
            this.out.println("  <row>");
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                String string3;
                Object object;
                switch (resultSetMetaData.getColumnType(i)) {
                    case 93: 
                    case 2014: {
                        object = resultSet.getTimestamp(i);
                        if ("timestamptz".equals(resultSetMetaData.getColumnTypeName(i))) {
                            if (xsd_tstz == null) {
                                xsd_tstz = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                            }
                            string3 = xsd_tstz.format((Date)object).toString();
                            break;
                        }
                        if (xsd_ts == null) {
                            xsd_ts = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                        }
                        string3 = xsd_ts.format((Date)object).toString();
                        break;
                    }
                    default: {
                        string3 = resultSet.getString(i);
                    }
                }
                if (string3 == null) {
                    if (!this.useNil) continue;
                    this.out.println("    <" + resultSetMetaData.getColumnLabel(i) + " xsi:nil=\"true\" />");
                    continue;
                }
                if (string3.length() == 0) {
                    this.out.println("    <" + resultSetMetaData.getColumnLabel(i) + " />");
                    continue;
                }
                object = resultSetMetaData.getColumnLabel(i);
                this.out.println("    <" + (String)object + ">" + XMLExporter.escapeSpecialXMLChars(string3) + "</" + (String)object + ">");
            }
            this.out.println("  </row>");
        }
        this.out.println("</" + string2 + ">");
    }

    private static final String escapeSpecialXMLChars(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 50);
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.length() > n ? stringBuilder.toString() : string;
    }

    @Override
    public void setProperty(int n, int n2) throws Exception {
        block0 : switch (n) {
            case 1: {
                switch (n2) {
                    case 0: {
                        this.useNil = false;
                        break block0;
                    }
                    case 1: {
                        this.useNil = true;
                        break block0;
                    }
                }
                throw new Exception("Illegal value " + n2 + " for TYPE_NIL");
            }
            default: {
                throw new Exception("Illegal type " + n);
            }
        }
    }

    @Override
    public int getProperty(int n) throws Exception {
        switch (n) {
            case 1: {
                return this.useNil ? 1 : 0;
            }
        }
        throw new Exception("Illegal type " + n);
    }
}

