/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tokenreplacement;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.tokenreplacement.TokenReplacementData;
import org.apache.hop.pipeline.transforms.tokenreplacement.TokenReplacementField;
import org.apache.hop.pipeline.transforms.tokenreplacement.TokenReplacementMeta;
import org.apache.hop.pipeline.transforms.tokenreplacement.TokenReplacingReader;
import org.apache.hop.pipeline.transforms.tokenreplacement.TokenResolver;

public class TokenReplacement
extends BaseTransform<TokenReplacementMeta, TokenReplacementData> {
    private static final Class<?> PKG = TokenReplacementMeta.class;
    public static final String CONST_NOT_FOUND_ON_INPUT_STREAM = " not found on input stream.";
    public static final String CONST_FIELD = "field";

    public TokenReplacement(TransformMeta transformMeta, TokenReplacementMeta meta, TokenReplacementData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean processRow() throws HopException {
        TokenReplacingReader reader;
        String filename;
        boolean result = true;
        Object[] r = this.getRow();
        if (this.first && r != null) {
            this.first = false;
            ((TokenReplacementData)this.data).inputRowMeta = this.getInputRowMeta();
            ((TokenReplacementData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            if (((TokenReplacementMeta)this.meta).getOutputType().equalsIgnoreCase(CONST_FIELD)) {
                ((TokenReplacementMeta)this.meta).getFields(((TokenReplacementData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            }
            if (((TokenReplacementMeta)this.meta).getOutputType().equalsIgnoreCase("file") && !((TokenReplacementMeta)this.meta).isOutputFileNameInField()) {
                if (((TokenReplacementMeta)this.meta).getOutputFileName() == null) throw new HopException("Output file name cannot be null.");
                filename = ((TokenReplacementMeta)this.meta).buildFilename(((TokenReplacementMeta)this.meta).getOutputFileName(), (IVariables)this, this.getCopy(), this.getPartitionId(), ((TokenReplacementData)this.data).splitnr);
                this.openNewOutputFile(filename);
            }
        }
        if (r == null) {
            this.closeAllOutputFiles();
            this.setOutputDone();
            return false;
        }
        if (((TokenReplacementMeta)this.meta).getOutputType().equalsIgnoreCase("file") && !((TokenReplacementMeta)this.meta).isOutputFileNameInField() && ((TokenReplacementMeta)this.meta).getSplitEvery() > 0 && ((TokenReplacementData)this.data).rowNumber % ((TokenReplacementMeta)this.meta).getSplitEvery() == 0 && ((TokenReplacementData)this.data).rowNumber > 0) {
            this.closeAllOutputFiles();
            ++((TokenReplacementData)this.data).splitnr;
            filename = ((TokenReplacementMeta)this.meta).buildFilename(((TokenReplacementMeta)this.meta).getOutputFileName(), (IVariables)this, this.getCopy(), this.getPartitionId(), ((TokenReplacementData)this.data).splitnr);
            this.openNewOutputFile(filename);
        }
        String outputFilename = "";
        if (((TokenReplacementMeta)this.meta).getOutputType().equalsIgnoreCase("file") && !((TokenReplacementMeta)this.meta).isOutputFileNameInField()) {
            outputFilename = ((TokenReplacementMeta)this.meta).buildFilename(((TokenReplacementMeta)this.meta).getOutputFileName(), (IVariables)this, this.getCopy(), this.getPartitionId(), ((TokenReplacementData)this.data).splitnr);
        } else if (((TokenReplacementMeta)this.meta).getOutputType().equalsIgnoreCase("file") && ((TokenReplacementMeta)this.meta).isOutputFileNameInField()) {
            String filenameValue = ((TokenReplacementData)this.data).inputRowMeta.getString(r, this.resolve(((TokenReplacementMeta)this.meta).getOutputFileNameField()), "");
            if (Utils.isEmpty((CharSequence)filenameValue)) throw new HopException("Filename cannot be empty.");
            outputFilename = filenameValue;
        }
        TokenResolver resolver = new TokenResolver();
        for (TokenReplacementField field : ((TokenReplacementMeta)this.meta).getTokenReplacementFields()) {
            if (((TokenReplacementData)this.data).inputRowMeta.indexOfValue(field.getName()) < 0) throw new HopValueException("Field " + field.getName() + CONST_NOT_FOUND_ON_INPUT_STREAM);
            String fieldValue = this.resolve(((TokenReplacementData)this.data).inputRowMeta.getString(r, field.getName(), null));
            if (fieldValue == null && !BooleanUtils.toBoolean((String)Const.getEnvironmentVariable((String)"KETTLE_EMPTY_STRING_DIFFERS_FROM_NULL", (String)"N"))) {
                fieldValue = Const.nullToEmpty((String)fieldValue);
            }
            resolver.addToken(field.getTokenName(), fieldValue);
        }
        String inputFilename = "";
        if (((TokenReplacementMeta)this.meta).getInputType().equalsIgnoreCase("text")) {
            reader = new TokenReplacingReader(resolver, new StringReader(((TokenReplacementMeta)this.meta).getInputText()), this.resolve(((TokenReplacementMeta)this.meta).getTokenStartString()), this.resolve(((TokenReplacementMeta)this.meta).getTokenEndString()));
        } else if (((TokenReplacementMeta)this.meta).getInputType().equalsIgnoreCase(CONST_FIELD)) {
            if (((TokenReplacementData)this.data).inputRowMeta.indexOfValue(((TokenReplacementMeta)this.meta).getInputFieldName()) < 0) throw new HopValueException("Input field " + ((TokenReplacementMeta)this.meta).getInputFieldName() + CONST_NOT_FOUND_ON_INPUT_STREAM);
            String inputString = ((TokenReplacementData)this.data).inputRowMeta.getString(r, ((TokenReplacementMeta)this.meta).getInputFieldName(), "");
            reader = new TokenReplacingReader(resolver, new StringReader(inputString), this.resolve(((TokenReplacementMeta)this.meta).getTokenStartString()), this.resolve(((TokenReplacementMeta)this.meta).getTokenEndString()));
        } else {
            if (!((TokenReplacementMeta)this.meta).getInputType().equalsIgnoreCase("file")) throw new HopException("Unsupported input type " + ((TokenReplacementMeta)this.meta).getInputType());
            if (((TokenReplacementMeta)this.meta).isInputFileNameInField()) {
                if (((TokenReplacementData)this.data).inputRowMeta.indexOfValue(this.resolve(((TokenReplacementMeta)this.meta).getInputFileNameField())) < 0) throw new HopValueException("Input filename field " + this.resolve(((TokenReplacementMeta)this.meta).getInputFileNameField()) + CONST_NOT_FOUND_ON_INPUT_STREAM);
                inputFilename = ((TokenReplacementData)this.data).inputRowMeta.getString(r, this.resolve(((TokenReplacementMeta)this.meta).getInputFileNameField()), "");
            } else {
                inputFilename = this.resolve(((TokenReplacementMeta)this.meta).getInputFileName());
            }
            if (Utils.isEmpty((CharSequence)inputFilename)) {
                throw new HopValueException("Input filename cannot be empty");
            }
            if (!HopVfs.fileExists((String)inputFilename, (IVariables)this.variables)) {
                throw new HopException("Input file " + inputFilename + " does not exist.");
            }
            reader = new TokenReplacingReader(resolver, new InputStreamReader(HopVfs.getInputStream((String)inputFilename, (IVariables)this.variables)), this.resolve(((TokenReplacementMeta)this.meta).getTokenStartString()), this.resolve(((TokenReplacementMeta)this.meta).getTokenEndString()));
            if (((TokenReplacementMeta)this.meta).isAddInputFileNameToResult()) {
                ResultFile resultFile = new ResultFile(0, HopVfs.getFileObject((String)inputFilename, (IVariables)this.variables), this.getTransformMeta().getName(), this.getTransformName());
                resultFile.setComment(BaseMessages.getString(PKG, (String)"TokenReplacement.AddInputResultFile", (String[])new String[0]));
                this.addResultFile(resultFile);
            }
        }
        StringWriter stringWriter = null;
        OutputStream bufferedWriter = null;
        if (((TokenReplacementMeta)this.meta).getOutputType().equalsIgnoreCase(CONST_FIELD)) {
            stringWriter = new StringWriter(5000);
        } else {
            if (!((TokenReplacementMeta)this.meta).getOutputType().equalsIgnoreCase("file")) throw new HopException("Unsupported output type " + ((TokenReplacementMeta)this.meta).getOutputType());
            if (inputFilename.equals(outputFilename)) {
                throw new HopException("Input and output filenames must not be the same " + inputFilename);
            }
            int fileIndex = ((TokenReplacementData)this.data).openFiles.indexOf(outputFilename);
            if (fileIndex < 0) {
                this.openNewOutputFile(outputFilename);
                fileIndex = ((TokenReplacementData)this.data).openFiles.indexOf(outputFilename);
            }
            bufferedWriter = ((TokenReplacementData)this.data).openBufferedWriters.get(fileIndex);
        }
        Object output = "";
        try {
            char[] cbuf = new char[5000];
            int length = 0;
            while ((length = ((Reader)reader).read(cbuf)) > 0) {
                if (((TokenReplacementMeta)this.meta).getOutputType().equalsIgnoreCase(CONST_FIELD)) {
                    ((Writer)stringWriter).write(cbuf, 0, length);
                } else if (((TokenReplacementMeta)this.meta).getOutputType().equalsIgnoreCase("file")) {
                    CharBuffer cBuffer = CharBuffer.wrap(cbuf, 0, length);
                    ByteBuffer bBuffer = Charset.forName(((TokenReplacementMeta)this.meta).getOutputFileEncoding()).encode(cBuffer);
                    byte[] bytes = new byte[bBuffer.limit()];
                    bBuffer.get(bytes);
                    bufferedWriter.write(bytes);
                }
                cbuf = new char[5000];
            }
            if (((TokenReplacementMeta)this.meta).getOutputType().equalsIgnoreCase(CONST_FIELD)) {
                output = (String)output + ((Object)stringWriter).toString();
            } else if (((TokenReplacementMeta)this.meta).getOutputType().equalsIgnoreCase("file")) {
                bufferedWriter.write(((TokenReplacementMeta)this.meta).getOutputFileFormatString().getBytes());
            }
        }
        catch (IOException ex) {
            throw new HopException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            try {
                ((Reader)reader).close();
                if (stringWriter != null) {
                    ((Writer)stringWriter).close();
                }
                reader = null;
                stringWriter = null;
            }
            catch (IOException ex) {
                throw new HopException(ex.getMessage(), (Throwable)ex);
            }
        }
        if (((TokenReplacementMeta)this.meta).getOutputType().equalsIgnoreCase(CONST_FIELD)) {
            r = RowDataUtil.addValueData((Object[])r, (int)(((TokenReplacementData)this.data).outputRowMeta.size() - 1), (Object)output);
        } else if (((TokenReplacementMeta)this.meta).getOutputType().equalsIgnoreCase("file")) {
            this.incrementLinesWritten();
        }
        this.putRow(((TokenReplacementData)this.data).outputRowMeta, r);
        ++((TokenReplacementData)this.data).rowNumber;
        if (!this.checkFeedback(this.getLinesOutput())) return result;
        this.logBasic("linenr " + this.getLinesOutput());
        return result;
    }

    public boolean init() {
        return super.init();
    }

    public void dispose() {
        try {
            this.closeAllOutputFiles();
        }
        catch (HopException hopException) {
            // empty catch block
        }
        super.dispose();
    }

    public void openNewOutputFile(String filename) throws HopException {
        if (((TokenReplacementData)this.data).openFiles.contains(filename)) {
            this.logDetailed("File " + filename + " is already open.");
            return;
        }
        if (((TokenReplacementMeta)this.meta).isCreateParentFolder()) {
            try {
                this.createParentFolder(filename);
            }
            catch (Exception ex) {
                throw new HopException(ex.getMessage(), (Throwable)ex);
            }
        }
        boolean fileExists = HopVfs.fileExists((String)filename, (IVariables)this.variables);
        OutputStream writer = HopVfs.getOutputStream((String)filename, (boolean)((TokenReplacementMeta)this.meta).isAppendOutputFileName(), (IVariables)this.variables);
        BufferedOutputStream bufferedWriter = new BufferedOutputStream(writer, 5000);
        try {
            if (fileExists && ((TokenReplacementMeta)this.meta).isAppendOutputFileName()) {
                ((OutputStream)bufferedWriter).write(((TokenReplacementMeta)this.meta).getOutputFileFormatString().getBytes());
            }
        }
        catch (IOException ex) {
            throw new HopException(ex.getMessage(), (Throwable)ex);
        }
        ((TokenReplacementData)this.data).openFiles.add(filename);
        ((TokenReplacementData)this.data).openWriters.add(writer);
        ((TokenReplacementData)this.data).openBufferedWriters.add(bufferedWriter);
    }

    public void closeAllOutputFiles() throws HopException {
        try {
            Iterator<OutputStream> itWriter = ((TokenReplacementData)this.data).openWriters.iterator();
            Iterator<OutputStream> itBufferedWriter = ((TokenReplacementData)this.data).openBufferedWriters.iterator();
            Iterator<String> itFilename = ((TokenReplacementData)this.data).openFiles.iterator();
            if (((TokenReplacementMeta)this.meta).isAddOutputFileNameToResult()) {
                while (itFilename.hasNext()) {
                    ResultFile resultFile = new ResultFile(0, HopVfs.getFileObject((String)itFilename.next(), (IVariables)this.variables), this.getTransformMeta().getName(), this.getTransformName());
                    resultFile.setComment(BaseMessages.getString(PKG, (String)"TokenReplacement.AddOutputResultFile", (String[])new String[0]));
                    this.addResultFile(resultFile);
                }
            }
            while (itBufferedWriter.hasNext()) {
                OutputStream bufferedWriter = itBufferedWriter.next();
                if (bufferedWriter == null) continue;
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            while (itWriter.hasNext()) {
                OutputStream writer = itWriter.next();
                if (writer == null) continue;
                writer.close();
            }
            ((TokenReplacementData)this.data).openBufferedWriters.clear();
            ((TokenReplacementData)this.data).openWriters.clear();
            ((TokenReplacementData)this.data).openFiles.clear();
        }
        catch (IOException ex) {
            throw new HopException(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createParentFolder(String filename) throws Exception {
        block13: {
            FileObject parentfolder = null;
            try {
                parentfolder = HopVfs.getFileObject((String)filename, (IVariables)this.variables).getParent();
                if (parentfolder.exists()) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"TokenReplacement.Log.ParentFolderExist", (Object[])new Object[]{parentfolder.getName()}));
                    }
                    break block13;
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"TokenReplacement.Log.ParentFolderNotExist", (Object[])new Object[]{parentfolder.getName()}));
                }
                if (((TokenReplacementMeta)this.meta).isCreateParentFolder()) {
                    parentfolder.createFolder();
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"TokenReplacement.Log.ParentFolderCreated", (Object[])new Object[]{parentfolder.getName()}));
                    }
                    break block13;
                }
                throw new HopException(BaseMessages.getString(PKG, (String)"TokenReplacement.Log.ParentFolderNotExistCreateIt", (Object[])new Object[]{parentfolder.getName(), filename}));
            }
            finally {
                if (parentfolder != null) {
                    try {
                        parentfolder.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

