/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;

public final class TimeUtil {
    private static final @UnknownKeyFor @NonNull @Initialized Pattern DURATION_PATTERN = Pattern.compile("(\\d+)(?:\\.(\\d+))?s");
    private static final @UnknownKeyFor @NonNull @Initialized Pattern TIME_PATTERN = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2}):(\\d{2})(?:\\.(\\d+))?Z");

    private TimeUtil() {
    }

    public static @UnknownKeyFor @NonNull @Initialized String toCloudTime(@UnknownKeyFor @NonNull @Initialized ReadableInstant instant) {
        DateTime time = new DateTime((Object)instant);
        int millis = time.getMillisOfSecond();
        if (millis == 0) {
            return String.format("%04d-%02d-%02dT%02d:%02d:%02dZ", time.getYear(), time.getMonthOfYear(), time.getDayOfMonth(), time.getHourOfDay(), time.getMinuteOfHour(), time.getSecondOfMinute());
        }
        return String.format("%04d-%02d-%02dT%02d:%02d:%02d.%03dZ", time.getYear(), time.getMonthOfYear(), time.getDayOfMonth(), time.getHourOfDay(), time.getMinuteOfHour(), time.getSecondOfMinute(), millis);
    }

    public static @Nullable @UnknownKeyFor @Initialized Instant fromCloudTime(@UnknownKeyFor @NonNull @Initialized String time) {
        Matcher matcher = TIME_PATTERN.matcher(time);
        if (!matcher.matches()) {
            return null;
        }
        int year = Integer.parseInt(matcher.group(1));
        int month = Integer.parseInt(matcher.group(2));
        int day = Integer.parseInt(matcher.group(3));
        int hour = Integer.parseInt(matcher.group(4));
        int minute = Integer.parseInt(matcher.group(5));
        int second = Integer.parseInt(matcher.group(6));
        int millis = TimeUtil.computeMillis(matcher.group(7));
        return new DateTime(year, month, day, hour, minute, second, millis, (Chronology)ISOChronology.getInstanceUTC()).toInstant();
    }

    private static @UnknownKeyFor @NonNull @Initialized int computeMillis(@UnknownKeyFor @NonNull @Initialized String frac) {
        if (frac == null) {
            return 0;
        }
        return Integer.parseInt(frac.length() > 3 ? frac.substring(0, 3) : Strings.padEnd((String)frac, (int)3, (char)'0'));
    }

    public static @UnknownKeyFor @NonNull @Initialized String toCloudDuration(@UnknownKeyFor @NonNull @Initialized ReadableDuration duration) {
        long millis = duration.getMillis();
        long seconds = millis / 1000L;
        if ((millis %= 1000L) == 0L) {
            return String.format("%ds", seconds);
        }
        return String.format("%d.%03ds", seconds, millis);
    }

    public static @Nullable @UnknownKeyFor @Initialized Duration fromCloudDuration(@UnknownKeyFor @NonNull @Initialized String duration) {
        Matcher matcher = DURATION_PATTERN.matcher(duration);
        if (!matcher.matches()) {
            return null;
        }
        long millis = Long.parseLong(matcher.group(1)) * 1000L;
        String frac = matcher.group(2);
        if (frac != null) {
            long fracs = Long.parseLong(frac);
            if (frac.length() == 3) {
                millis += fracs;
            } else if (frac.length() == 6) {
                millis += fracs / 1000L;
            } else if (frac.length() == 9) {
                millis += fracs / 1000000L;
            } else {
                return null;
            }
        }
        return Duration.millis((long)millis);
    }
}

