/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow;

import java.util.Comparator;
import java.util.Date;
import org.apache.hop.core.Result;

public class ActionResult
implements Cloneable,
Comparator<ActionResult>,
Comparable<ActionResult> {
    private Result result;
    private String actionName;
    private String comment;
    private String reason;
    private Date logDate = new Date();
    private String actionFilename;
    private String logChannelId;
    private boolean checkpoint;

    public ActionResult() {
    }

    public ActionResult(Result result, String logChannelId, String comment, String reason, String actionName, String actionFilename) {
        this();
        if (result != null) {
            this.result = result.lightClone();
            this.result.setLogText(null);
        } else {
            this.result = null;
        }
        this.logChannelId = logChannelId;
        this.comment = comment;
        this.reason = reason;
        this.actionName = actionName;
        this.actionFilename = actionFilename;
    }

    public Object clone() {
        try {
            ActionResult actionResult = (ActionResult)super.clone();
            if (this.getResult() != null) {
                actionResult.setResult(this.getResult().clone());
            }
            return actionResult;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public Result getResult() {
        return this.result;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Date getLogDate() {
        return this.logDate;
    }

    public void setLogDate(Date logDate) {
        this.logDate = logDate;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getActionFilename() {
        return this.actionFilename;
    }

    public void setActionFilename(String actionFilename) {
        this.actionFilename = actionFilename;
    }

    @Override
    public int compare(ActionResult one, ActionResult two) {
        if (one == null && two != null) {
            return -1;
        }
        if (one != null && two == null) {
            return 1;
        }
        if (one == null && two == null) {
            return 0;
        }
        if (one.getActionName() == null && two.getActionName() != null) {
            return -1;
        }
        if (one.getActionName() != null && two.getActionName() == null) {
            return 1;
        }
        if (one.getActionName() == null && two.getActionName() == null) {
            return 0;
        }
        return one.getActionName().compareTo(two.getActionName());
    }

    @Override
    public int compareTo(ActionResult two) {
        return this.compare(this, two);
    }

    public String getLogChannelId() {
        return this.logChannelId;
    }

    public boolean isCheckpoint() {
        return this.checkpoint;
    }

    public void setCheckpoint(boolean checkpoint) {
        this.checkpoint = checkpoint;
    }
}

