/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.file;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.hop.core.Const;
import org.apache.hop.core.gui.ITextFileInputField;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaFactory;

public class TextFileInputField
implements Cloneable,
ITextFileInputField {
    @Injection(name="INPUT_NAME", group="INPUT_FIELDS")
    private String name;
    @Injection(name="INPUT_POSITION", group="INPUT_FIELDS")
    private int position;
    @Injection(name="INPUT_LENGTH", group="INPUT_FIELDS")
    private int length;
    private int type;
    @Injection(name="INPUT_IGNORE", group="INPUT_FIELDS")
    private boolean ignore;
    @Injection(name="INPUT_FORMAT", group="INPUT_FIELDS")
    private String format;
    private int trimtype;
    @Injection(name="INPUT_PRECISION", group="INPUT_FIELDS")
    private int precision;
    @Injection(name="INPUT_CURRENCY", group="INPUT_FIELDS")
    private String currencySymbol;
    @Injection(name="INPUT_DECIMAL", group="INPUT_FIELDS")
    private String decimalSymbol;
    @Injection(name="INPUT_GROUP", group="INPUT_FIELDS")
    private String groupSymbol;
    @Injection(name="INPUT_REPEAT", group="INPUT_FIELDS")
    private boolean repeat;
    @Injection(name="INPUT_NULL_STRING", group="INPUT_FIELDS")
    private String nullString;
    @Injection(name="INPUT_IF_NULL", group="INPUT_FIELDS")
    private String ifNullValue;
    private String[] samples;
    private static final String[] dateFormats = new String[]{"yyyy/MM/dd HH:mm:ss.SSS", "yyyy/MM/dd HH:mm:ss", "dd/MM/yyyy", "dd-MM-yyyy", "yyyy/MM/dd", "yyyy-MM-dd", "yyyyMMdd", "ddMMyyyy", "d-M-yyyy", "d/M/yyyy", "d-M-yy", "d/M/yy"};
    private static final String[] numberFormats = new String[]{"", "#", Const.DEFAULT_NUMBER_FORMAT, "0.00", "0000000000000", "###,###,###.#######", "###############.###############", "#####.###############%"};

    public TextFileInputField(String fieldname, int position, int length) {
        this.name = fieldname;
        this.position = position;
        this.length = length;
        this.type = 2;
        this.ignore = false;
        this.format = "";
        this.trimtype = 0;
        this.groupSymbol = "";
        this.decimalSymbol = "";
        this.currencySymbol = "";
        this.precision = -1;
        this.repeat = false;
        this.nullString = "";
        this.ifNullValue = "";
    }

    public TextFileInputField() {
        this(null, -1, -1);
    }

    public int compare(Object obj) {
        TextFileInputField field = (TextFileInputField)obj;
        return this.position - field.getPosition();
    }

    public int compareTo(ITextFileInputField field) {
        return this.position - field.getPosition();
    }

    public boolean equal(Object obj) {
        TextFileInputField field = (TextFileInputField)obj;
        return this.position == field.getPosition();
    }

    public Object clone() {
        try {
            Object retval = super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String fieldname) {
        this.name = fieldname;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        return ValueMetaFactory.getValueMetaName((int)this.type);
    }

    public void setType(int type) {
        this.type = type;
    }

    @Injection(name="FIELD_TYPE", group="INPUT_FIELDS")
    public void setType(String value) {
        this.type = ValueMetaFactory.getIdForValueMeta((String)value);
    }

    public boolean isIgnored() {
        return this.ignore;
    }

    public void setIgnored(boolean ignore) {
        this.ignore = ignore;
    }

    public void flipIgnored() {
        this.ignore = !this.ignore;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSamples(String[] samples) {
        this.samples = samples;
    }

    public String[] getSamples() {
        return this.samples;
    }

    public int getTrimType() {
        return this.trimtype;
    }

    public String getTrimTypeCode() {
        return ValueMetaBase.getTrimTypeCode((int)this.trimtype);
    }

    public String getTrimTypeDesc() {
        return ValueMetaBase.getTrimTypeDesc((int)this.trimtype);
    }

    public void setTrimType(int trimtype) {
        this.trimtype = trimtype;
    }

    @Injection(name="FIELD_TRIM_TYPE", group="INPUT_FIELDS")
    public void setTrimType(String value) {
        this.trimtype = ValueMetaBase.getTrimTypeByCode((String)value);
    }

    public String getGroupSymbol() {
        return this.groupSymbol;
    }

    public void setGroupSymbol(String groupSymbol) {
        this.groupSymbol = groupSymbol;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimalSymbol) {
        this.decimalSymbol = decimalSymbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public boolean isRepeated() {
        return this.repeat;
    }

    public void setRepeated(boolean repeat) {
        this.repeat = repeat;
    }

    public void flipRepeated() {
        this.repeat = !this.repeat;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    public String getIfNullValue() {
        return this.ifNullValue;
    }

    public void setIfNullValue(String ifNullValue) {
        this.ifNullValue = ifNullValue;
    }

    public String toString() {
        return this.name + "@" + this.position + ":" + this.length;
    }

    public void guess() {
        this.guessTrimType();
        this.guessType();
        this.guessIgnore();
    }

    public void guessTrimType() {
        boolean spacesBefore = false;
        boolean spacesAfter = false;
        for (int i = 0; i < this.samples.length; ++i) {
            spacesBefore |= Const.nrSpacesBefore((String)this.samples[i]) > 0;
            spacesAfter |= Const.nrSpacesAfter((String)this.samples[i]) > 0;
            this.samples[i] = Const.trim((String)this.samples[i]);
        }
        this.trimtype = 0;
        if (spacesBefore) {
            this.trimtype |= 1;
        }
        if (spacesAfter) {
            this.trimtype |= 2;
        }
    }

    public void guessType() {
        NumberFormat nf = NumberFormat.getInstance();
        DecimalFormat df = (DecimalFormat)nf;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        SimpleDateFormat daf = new SimpleDateFormat();
        daf.setLenient(false);
        this.type = 2;
        if (this.samples == null) {
            return;
        }
        int datefmtCnt = dateFormats.length;
        boolean[] datefmt = new boolean[dateFormats.length];
        for (int i = 0; i < dateFormats.length; ++i) {
            datefmt[i] = true;
        }
        int datenul = 0;
        for (int i = 0; i < this.samples.length; ++i) {
            if (this.samples[i].length() > 0 && this.samples[i].equalsIgnoreCase(this.nullString)) {
                ++datenul;
                continue;
            }
            for (int x = 0; x < dateFormats.length; ++x) {
                if (this.samples[i] == null || Const.onlySpaces((String)this.samples[i]) || this.samples[i].length() == 0) {
                    datefmt[x] = false;
                    --datefmtCnt;
                }
                if (!datefmt[x]) continue;
                try {
                    daf.applyPattern(dateFormats[x]);
                    Date date = daf.parse(this.samples[i]);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    int year = cal.get(1);
                    if (year >= 1800 && year <= 2200) continue;
                    datefmt[x] = false;
                    --datefmtCnt;
                    continue;
                }
                catch (Exception e) {
                    datefmt[x] = false;
                    --datefmtCnt;
                }
            }
        }
        if (datefmtCnt > 0 && datenul != this.samples.length) {
            int first = -1;
            for (int i = 0; i < dateFormats.length && first < 0; ++i) {
                if (!datefmt[i]) continue;
                first = i;
            }
            this.type = 3;
            this.format = dateFormats[first];
            return;
        }
        boolean isnumber = true;
        this.decimalSymbol = "" + dfs.getDecimalSeparator();
        this.groupSymbol = "" + dfs.getGroupingSeparator();
        boolean[] numfmt = new boolean[numberFormats.length];
        int[] maxprecision = new int[numberFormats.length];
        for (int i = 0; i < numfmt.length; ++i) {
            numfmt[i] = true;
            maxprecision[i] = -1;
        }
        int numfmtCnt = numberFormats.length;
        int numnul = 0;
        for (int i = 0; i < this.samples.length && isnumber; ++i) {
            int x;
            boolean containsDot = false;
            boolean containsComma = false;
            String field = this.samples[i];
            if (field.length() > 0 && field.equalsIgnoreCase(this.nullString)) {
                ++numnul;
                continue;
            }
            for (x = 0; x < field.length() && isnumber; ++x) {
                char ch = field.charAt(x);
                if (!(Character.isDigit(ch) || ch == '.' || ch == ',' || ch == '-' && x <= 0 || ch == 'E' || ch == 'e')) {
                    isnumber = false;
                    numfmtCnt = 0;
                    continue;
                }
                if (ch == '.') {
                    containsDot = true;
                }
                if (ch != ',') continue;
                containsComma = true;
            }
            if (!isnumber) continue;
            if (containsDot && !containsComma) {
                dfs.setDecimalSeparator('.');
                this.decimalSymbol = ".";
                dfs.setGroupingSeparator(',');
                this.groupSymbol = ",";
            } else if (!containsDot && containsComma) {
                dfs.setDecimalSeparator(',');
                this.decimalSymbol = ",";
                dfs.setGroupingSeparator('.');
                this.groupSymbol = ".";
            } else if (containsDot && containsComma) {
                int idxCom;
                int idxDot = field.indexOf(46);
                if (idxDot > (idxCom = field.indexOf(44))) {
                    dfs.setDecimalSeparator('.');
                    this.decimalSymbol = ".";
                    dfs.setGroupingSeparator(',');
                    this.groupSymbol = ",";
                } else {
                    dfs.setDecimalSeparator(',');
                    this.decimalSymbol = ",";
                    dfs.setGroupingSeparator('.');
                    this.groupSymbol = ".";
                }
            }
            for (x = 0; x < numberFormats.length; ++x) {
                if (!numfmt[x]) continue;
                boolean islong = true;
                try {
                    int prec = -1;
                    if (!containsDot && !containsComma) {
                        try {
                            Long.parseLong(field);
                            prec = 0;
                        }
                        catch (Exception e) {
                            islong = false;
                        }
                    }
                    if (!islong) {
                        df.setDecimalFormatSymbols(dfs);
                        df.applyPattern(numberFormats[x]);
                        double d = df.parse(field).doubleValue();
                        prec = TextFileInputField.guessPrecision(d);
                    }
                    if (prec <= maxprecision[x]) continue;
                    maxprecision[x] = prec;
                    continue;
                }
                catch (Exception e) {
                    numfmt[x] = false;
                    --numfmtCnt;
                }
            }
        }
        if (numfmtCnt > 0 && numnul != this.samples.length) {
            int first = -1;
            for (int i = 0; i < numberFormats.length && first < 0; ++i) {
                if (!numfmt[i]) continue;
                first = i;
            }
            this.type = 1;
            this.format = numberFormats[first];
            this.precision = maxprecision[first];
            return;
        }
        this.type = 2;
        this.format = "";
        this.precision = -1;
        this.decimalSymbol = "";
        this.groupSymbol = "";
        this.currencySymbol = "";
    }

    public static final int guessPrecision(double d) {
        int maxprec = 4;
        double maxdiff = 5.0E-5;
        double diff = Math.abs(Math.floor(d) - d);
        if (diff < maxdiff) {
            return 0;
        }
        for (int i = 1; i < maxprec; ++i) {
            double factor = Math.pow(10.0, i);
            diff = Math.abs(Math.floor(d * factor) - d * factor);
            if (diff < maxdiff) {
                return i;
            }
            factor *= 10.0;
        }
        return -1;
    }

    public void guessIgnore() {
        int i;
        boolean stop = false;
        for (i = 0; i < this.samples.length && !stop; ++i) {
            if (Const.onlySpaces((String)this.samples[i])) continue;
            stop = true;
        }
        if (!stop) {
            this.ignore = true;
            return;
        }
        stop = false;
        for (i = 0; i < this.samples.length && !stop; ++i) {
            if (this.samples[i].length() <= 0) continue;
            stop = true;
        }
        if (!stop) {
            this.ignore = true;
            return;
        }
        stop = false;
        for (i = 0; i < this.samples.length && !stop; ++i) {
            if (this.samples[i].equalsIgnoreCase(this.nullString)) continue;
            stop = true;
        }
        if (!stop) {
            this.ignore = true;
            return;
        }
    }

    public ITextFileInputField createNewInstance(String newFieldname, int x, int newlength) {
        return new TextFileInputField(newFieldname, x, newlength);
    }
}

