/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.http;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.http.Http;
import org.apache.hop.pipeline.transforms.http.HttpData;
import org.w3c.dom.Node;

@Transform(id="Http", image="http.svg", name="i18n::HTTP.Name", description="i18n::HTTP.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Lookup", keywords={"i18n::HttpMeta.keyword"}, documentationUrl="/pipeline/transforms/http.html")
public class HttpMeta
extends BaseTransformMeta<Http, HttpData> {
    private static final Class<?> PKG = HttpMeta.class;
    public static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    public static final int DEFAULT_CLOSE_CONNECTIONS_TIME = -1;
    public static final String CONST_HEADER = "header";
    public static final String CONST_RESULT = "result";
    public static final String CONST_SPACES_LONG = "        ";
    public static final String CONST_SPACES = "      ";
    public static final String CONST_PARAMETER = "parameter";
    private String socketTimeout;
    private String connectionTimeout;
    private String closeIdleConnectionsTime;
    private String url;
    private String[] argumentField;
    private String[] argumentParameter;
    private String fieldName;
    private String encoding;
    private boolean urlInField;
    private boolean ignoreSsl;
    private String urlField;
    private String proxyHost;
    private String proxyPort;
    private String httpLogin;
    private String httpPassword;
    private String resultCodeFieldName;
    private String responseTimeFieldName;
    private String responseHeaderFieldName;
    private String[] headerParameter;
    private String[] headerField;

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getCloseIdleConnectionsTime() {
        return this.closeIdleConnectionsTime;
    }

    public void setCloseIdleConnectionsTime(String closeIdleConnectionsTime) {
        this.closeIdleConnectionsTime = closeIdleConnectionsTime;
    }

    public String getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(String socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public String[] getArgumentField() {
        return this.argumentField;
    }

    public void setArgumentField(String[] argument) {
        this.argumentField = argument;
    }

    public String[] getHeaderField() {
        return this.headerField;
    }

    public void setHeaderField(String[] headerField) {
        this.headerField = headerField;
    }

    public String[] getArgumentParameter() {
        return this.argumentParameter;
    }

    public void setArgumentParameter(String[] argumentDirection) {
        this.argumentParameter = argumentDirection;
    }

    public String[] getHeaderParameter() {
        return this.headerParameter;
    }

    public void setHeaderParameter(String[] headerParameter) {
        this.headerParameter = headerParameter;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String procedure) {
        this.url = procedure;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String resultName) {
        this.fieldName = resultName;
    }

    public boolean isUrlInField() {
        return this.urlInField;
    }

    public void setUrlInField(boolean urlInField) {
        this.urlInField = urlInField;
    }

    public String getUrlField() {
        return this.urlField;
    }

    public void setUrlField(String urlField) {
        this.urlField = urlField;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public void allocate(int nrargs, int nrqueryparams) {
        this.argumentField = new String[nrargs];
        this.argumentParameter = new String[nrargs];
        this.headerField = new String[nrqueryparams];
        this.headerParameter = new String[nrqueryparams];
    }

    public Object clone() {
        HttpMeta retval = (HttpMeta)((Object)super.clone());
        int nrargs = this.argumentField.length;
        int nrheaderparams = this.headerField.length;
        retval.allocate(nrargs, nrheaderparams);
        System.arraycopy(this.argumentField, 0, retval.argumentField, 0, nrargs);
        System.arraycopy(this.argumentParameter, 0, retval.argumentParameter, 0, nrargs);
        System.arraycopy(this.headerField, 0, retval.headerField, 0, nrheaderparams);
        System.arraycopy(this.headerParameter, 0, retval.headerParameter, 0, nrheaderparams);
        return retval;
    }

    public void setDefault() {
        int i;
        this.socketTimeout = String.valueOf(10000);
        this.connectionTimeout = String.valueOf(10000);
        this.closeIdleConnectionsTime = String.valueOf(-1);
        int nrargs = 0;
        int nrquery = 0;
        this.allocate(nrargs, nrquery);
        for (i = 0; i < nrargs; ++i) {
            this.argumentField[i] = "arg" + i;
            this.argumentParameter[i] = "arg";
        }
        for (i = 0; i < nrquery; ++i) {
            this.headerField[i] = CONST_HEADER + i;
            this.headerParameter[i] = CONST_HEADER;
        }
        this.fieldName = CONST_RESULT;
        this.resultCodeFieldName = "";
        this.responseTimeFieldName = "";
        this.responseHeaderFieldName = "";
        this.encoding = "UTF-8";
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        String headerFieldName;
        ValueMetaString v;
        if (!Utils.isEmpty((CharSequence)this.fieldName)) {
            v = new ValueMetaString(this.fieldName);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.resultCodeFieldName)) {
            v = new ValueMetaInteger(variables.resolve(this.resultCodeFieldName));
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.responseTimeFieldName)) {
            v = new ValueMetaInteger(variables.resolve(this.responseTimeFieldName));
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)(headerFieldName = variables.resolve(this.responseHeaderFieldName)))) {
            ValueMetaString v2 = new ValueMetaString(headerFieldName);
            v2.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v2);
        }
    }

    public String getXml() {
        int i;
        StringBuilder retval = new StringBuilder(300);
        retval.append("    ").append(XmlHandler.addTagValue((String)"url", (String)this.url));
        retval.append("    " + XmlHandler.addTagValue((String)"urlInField", (boolean)this.urlInField));
        retval.append("    " + XmlHandler.addTagValue((String)"ignoreSsl", (boolean)this.ignoreSsl));
        retval.append("    " + XmlHandler.addTagValue((String)"urlField", (String)this.urlField));
        retval.append("    " + XmlHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    " + XmlHandler.addTagValue((String)"httpLogin", (String)this.httpLogin));
        retval.append("    " + XmlHandler.addTagValue((String)"httpPassword", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.httpPassword)));
        retval.append("    " + XmlHandler.addTagValue((String)"proxyHost", (String)this.proxyHost));
        retval.append("    " + XmlHandler.addTagValue((String)"proxyPort", (String)this.proxyPort));
        retval.append("    " + XmlHandler.addTagValue((String)"socketTimeout", (String)this.socketTimeout));
        retval.append("    " + XmlHandler.addTagValue((String)"connectionTimeout", (String)this.connectionTimeout));
        retval.append("    " + XmlHandler.addTagValue((String)"closeIdleConnectionsTime", (String)this.closeIdleConnectionsTime));
        retval.append("    <lookup>").append(Const.CR);
        for (i = 0; i < this.argumentField.length; ++i) {
            retval.append("      <arg>").append(Const.CR);
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"name", (String)this.argumentField[i]));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)CONST_PARAMETER, (String)this.argumentParameter[i]));
            retval.append("      </arg>").append(Const.CR);
        }
        for (i = 0; i < this.headerField.length; ++i) {
            retval.append("      <header>" + Const.CR);
            retval.append(CONST_SPACES_LONG + XmlHandler.addTagValue((String)"name", (String)this.headerField[i]));
            retval.append(CONST_SPACES_LONG + XmlHandler.addTagValue((String)CONST_PARAMETER, (String)this.headerParameter[i]));
            retval.append("      </header>" + Const.CR);
        }
        retval.append("    </lookup>").append(Const.CR);
        retval.append("    <result>").append(Const.CR);
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"name", (String)this.fieldName));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"code", (String)this.resultCodeFieldName));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"response_time", (String)this.responseTimeFieldName));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"response_header", (String)this.responseHeaderFieldName));
        retval.append("    </result>").append(Const.CR);
        return retval.toString();
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            Node anode;
            int i;
            this.url = XmlHandler.getTagValue((Node)transformNode, (String)"url");
            this.urlInField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"urlInField"));
            this.ignoreSsl = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"ignoreSsl"));
            this.urlField = XmlHandler.getTagValue((Node)transformNode, (String)"urlField");
            this.encoding = XmlHandler.getTagValue((Node)transformNode, (String)"encoding");
            this.httpLogin = XmlHandler.getTagValue((Node)transformNode, (String)"httpLogin");
            this.httpPassword = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)transformNode, (String)"httpPassword"));
            this.proxyHost = XmlHandler.getTagValue((Node)transformNode, (String)"proxyHost");
            this.proxyPort = XmlHandler.getTagValue((Node)transformNode, (String)"proxyPort");
            this.socketTimeout = XmlHandler.getTagValue((Node)transformNode, (String)"socketTimeout");
            this.connectionTimeout = XmlHandler.getTagValue((Node)transformNode, (String)"connectionTimeout");
            this.closeIdleConnectionsTime = XmlHandler.getTagValue((Node)transformNode, (String)"closeIdleConnectionsTime");
            Node lookup = XmlHandler.getSubNode((Node)transformNode, (String)"lookup");
            int nrargs = XmlHandler.countNodes((Node)lookup, (String)"arg");
            int nrheaders = XmlHandler.countNodes((Node)lookup, (String)CONST_HEADER);
            this.allocate(nrargs, nrheaders);
            for (i = 0; i < nrargs; ++i) {
                anode = XmlHandler.getSubNodeByNr((Node)lookup, (String)"arg", (int)i);
                this.argumentField[i] = XmlHandler.getTagValue((Node)anode, (String)"name");
                this.argumentParameter[i] = XmlHandler.getTagValue((Node)anode, (String)CONST_PARAMETER);
            }
            for (i = 0; i < nrheaders; ++i) {
                anode = XmlHandler.getSubNodeByNr((Node)lookup, (String)CONST_HEADER, (int)i);
                this.headerField[i] = XmlHandler.getTagValue((Node)anode, (String)"name");
                this.headerParameter[i] = XmlHandler.getTagValue((Node)anode, (String)CONST_PARAMETER);
            }
            this.fieldName = XmlHandler.getTagValue((Node)transformNode, (String)CONST_RESULT, (String)"name");
            this.resultCodeFieldName = XmlHandler.getTagValue((Node)transformNode, (String)CONST_RESULT, (String)"code");
            this.responseTimeFieldName = XmlHandler.getTagValue((Node)transformNode, (String)CONST_RESULT, (String)"response_time");
            this.responseHeaderFieldName = XmlHandler.getTagValue((Node)transformNode, (String)CONST_RESULT, (String)"response_header");
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"HTTPMeta.Exception.UnableToReadTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"HTTPMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"HTTPMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        cr = this.urlInField ? (Utils.isEmpty((CharSequence)this.urlField) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"HTTPMeta.CheckResult.UrlfieldMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"HTTPMeta.CheckResult.UrlfieldOk", (String[])new String[0]), (ICheckResultSource)transformMeta)) : (Utils.isEmpty((CharSequence)this.url) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"HTTPMeta.CheckResult.UrlMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"HTTPMeta.CheckResult.UrlOk", (String[])new String[0]), (ICheckResultSource)transformMeta));
        remarks.add((ICheckResult)cr);
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setHttpLogin(String httpLogin) {
        this.httpLogin = httpLogin;
    }

    public String getHttpLogin() {
        return this.httpLogin;
    }

    public void setHttpPassword(String httpPassword) {
        this.httpPassword = httpPassword;
    }

    public String getHttpPassword() {
        return this.httpPassword;
    }

    public String getResultCodeFieldName() {
        return this.resultCodeFieldName;
    }

    public void setResultCodeFieldName(String resultCodeFieldName) {
        this.resultCodeFieldName = resultCodeFieldName;
    }

    public String getResponseTimeFieldName() {
        return this.responseTimeFieldName;
    }

    public void setResponseTimeFieldName(String responseTimeFieldName) {
        this.responseTimeFieldName = responseTimeFieldName;
    }

    public String getResponseHeaderFieldName() {
        return this.responseHeaderFieldName;
    }

    public void setResponseHeaderFieldName(String responseHeaderFieldName) {
        this.responseHeaderFieldName = responseHeaderFieldName;
    }

    public boolean isIgnoreSsl() {
        return this.ignoreSsl;
    }

    public void setIgnoreSsl(boolean ignoreSsl) {
        this.ignoreSsl = ignoreSsl;
    }
}

