/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms.providers;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.providers.AutoValue_JavaFilterTransformProvider_Configuration;
import org.apache.beam.sdk.schemas.transforms.providers.ErrorHandling;
import org.apache.beam.sdk.schemas.transforms.providers.JavaRowUdf;
import org.apache.beam.sdk.schemas.transforms.providers.StringCompiler;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class JavaFilterTransformProvider
extends TypedSchemaTransformProvider<Configuration> {
    protected static final @UnknownKeyFor @NonNull @Initialized String INPUT_ROWS_TAG = "input";
    protected static final @UnknownKeyFor @NonNull @Initialized String OUTPUT_ROWS_TAG = "output";

    @Override
    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized Configuration> configurationClass() {
        return Configuration.class;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized Configuration configuration) {
        return new JavaFilterTransform(configuration);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:yaml:filter-java:v1";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList(INPUT_ROWS_TAG);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList(OUTPUT_ROWS_TAG);
    }

    protected static class JavaFilterTransform
    extends SchemaTransform {
        private final @UnknownKeyFor @NonNull @Initialized Configuration configuration;
        private static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> filteredValues = new TupleTag<Row>(){};
        private static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> errorValues = new TupleTag<Row>(){};

        JavaFilterTransform(@UnknownKeyFor @NonNull @Initialized Configuration configuration) {
            this.configuration = configuration;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            JavaRowUdf keepFn;
            Schema inputSchema = input.get(JavaFilterTransformProvider.INPUT_ROWS_TAG).getSchema();
            try {
                keepFn = new JavaRowUdf(this.configuration.getKeep(), inputSchema);
            }
            catch (ReflectiveOperationException | MalformedURLException | StringCompiler.CompileException exn) {
                throw new RuntimeException(exn);
            }
            if (!keepFn.getOutputType().withNullable(false).equals(Schema.FieldType.BOOLEAN)) {
                throw new RuntimeException(String.format("KeepFn %s must return a boolean, but returns %s instead.", this.configuration.getKeep(), keepFn.getOutputType()));
            }
            boolean handleErrors = ErrorHandling.hasOutput(this.configuration.getErrorHandling());
            Schema errorSchema = ErrorHandling.errorSchema(inputSchema);
            PCollectionTuple pcolls = (PCollectionTuple)((Object)input.get(JavaFilterTransformProvider.INPUT_ROWS_TAG).apply("Filter", ParDo.of(JavaFilterTransform.createDoFn(keepFn, errorSchema, handleErrors)).withOutputTags(filteredValues, TupleTagList.of(errorValues))));
            pcolls.get(filteredValues).setRowSchema(inputSchema);
            pcolls.get(errorValues).setRowSchema(errorSchema);
            PCollectionRowTuple result = PCollectionRowTuple.of(JavaFilterTransformProvider.OUTPUT_ROWS_TAG, pcolls.get(filteredValues));
            if (handleErrors) {
                result = result.and(this.configuration.getErrorHandling().getOutput(), pcolls.get(errorValues));
            }
            return result;
        }

        private static @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Row> createDoFn(final @UnknownKeyFor @NonNull @Initialized JavaRowUdf keepFn, final @UnknownKeyFor @NonNull @Initialized Schema errorSchema, final @UnknownKeyFor @NonNull @Initialized boolean handleErrors) {
            return new DoFn<Row, Row>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row inputRow, @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver out) {
                    boolean keep = false;
                    try {
                        keep = (Boolean)keepFn.getFunction().apply(inputRow);
                    }
                    catch (Exception exn) {
                        if (handleErrors) {
                            out.get(errorValues).output(ErrorHandling.errorRecord(errorSchema, inputRow, (Throwable)exn));
                        }
                        throw new RuntimeException(exn);
                    }
                    if (keep) {
                        out.get(filteredValues).output(inputRow);
                    }
                }
            };
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class Configuration {
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getLanguage();

        public abstract @UnknownKeyFor @NonNull @Initialized JavaRowUdf.Configuration getKeep();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ErrorHandling getErrorHandling();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_JavaFilterTransformProvider_Configuration.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setLanguage(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setKeep(@UnknownKeyFor @NonNull @Initialized JavaRowUdf.Configuration var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setErrorHandling(@UnknownKeyFor @NonNull @Initialized ErrorHandling var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Configuration build();
        }
    }
}

