/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.loginfo;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.neo4j.logging.util.LoggingCore;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.neo4j.transforms.loginfo.GetLoggingInfoData;
import org.apache.hop.neo4j.transforms.loginfo.GetLoggingInfoMeta;
import org.apache.hop.neo4j.transforms.loginfo.GetLoggingInfoTypes;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;

public class GetLoggingInfo
extends BaseTransform<GetLoggingInfoMeta, GetLoggingInfoData> {
    public static final String CONST_UNABLE_TO_FIND_LOGGING_NEO_4_J_CONNECTION_VARIABLE = "Unable to find logging Neo4j connection (variable ";
    public static final String CONST_STATUS = "status";

    public GetLoggingInfo(TransformMeta transformMeta, GetLoggingInfoMeta meta, GetLoggingInfoData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private Object[] getLoggingInfo(IRowMeta inputRowMeta, Object[] inputRowData) throws Exception {
        int i;
        Object[] row = new Object[((GetLoggingInfoData)this.data).outputRowMeta.size()];
        for (i = 0; i < inputRowMeta.size(); ++i) {
            row[i] = inputRowData[i];
        }
        i = 0;
        int index = inputRowMeta.size();
        while (i < ((GetLoggingInfoMeta)this.meta).getFields().size()) {
            boolean argnr = false;
            String argument = ((GetLoggingInfoMeta)this.meta).getFields().get(i).getFieldArgument();
            argument = StringUtils.isEmpty((String)argument) ? this.getPipeline().getPipelineMeta().getName() : this.resolve(argument);
            switch (GetLoggingInfoTypes.getTypeFromString(((GetLoggingInfoMeta)this.meta).getFields().get(i).getFieldType())) {
                case TYPE_SYSTEM_INFO_PIPELINE_DATE_FROM: {
                    Date previousSuccess = this.getPreviousPipelineSuccess(argument);
                    if (previousSuccess == null) {
                        previousSuccess = Const.MIN_DATE;
                    }
                    row[index] = previousSuccess;
                    break;
                }
                case TYPE_SYSTEM_INFO_PIPELINE_DATE_TO: {
                    row[index] = this.getPipeline().getExecutionStartDate();
                    break;
                }
                case TYPE_SYSTEM_INFO_WORKFLOW_DATE_FROM: {
                    Date previousSuccess = this.getPreviousWorkflowSuccess(argument);
                    if (previousSuccess == null) {
                        previousSuccess = Const.MIN_DATE;
                    }
                    row[index] = previousSuccess;
                    break;
                }
                case TYPE_SYSTEM_INFO_WORKFLOW_DATE_TO: {
                    row[index] = this.getPipeline().getExecutionStartDate();
                    break;
                }
                case TYPE_SYSTEM_INFO_PIPELINE_PREVIOUS_EXECUTION_DATE: {
                    row[index] = this.getPreviousPipelineExecution(argument);
                    break;
                }
                case TYPE_SYSTEM_INFO_PIPELINE_PREVIOUS_SUCCESS_DATE: {
                    row[index] = this.getPreviousPipelineSuccess(argument);
                    break;
                }
                case TYPE_SYSTEM_INFO_WORKFLOW_PREVIOUS_EXECUTION_DATE: {
                    row[index] = this.getPreviousWorkflowExecution(argument);
                    break;
                }
                case TYPE_SYSTEM_INFO_WORKFLOW_PREVIOUS_SUCCESS_DATE: {
                    row[index] = this.getPreviousWorkflowSuccess(argument);
                    break;
                }
            }
            ++i;
            ++index;
        }
        return row;
    }

    public boolean processRow() throws HopException {
        IRowMeta imeta;
        Object[] row;
        if (((GetLoggingInfoData)this.data).readsRows) {
            row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                ((GetLoggingInfoData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((GetLoggingInfoMeta)this.meta).getFields(((GetLoggingInfoData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            }
        } else {
            row = new Object[]{};
            this.incrementLinesRead();
            if (this.first) {
                this.first = false;
                ((GetLoggingInfoData)this.data).outputRowMeta = new RowMeta();
                ((GetLoggingInfoMeta)this.meta).getFields(((GetLoggingInfoData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            }
        }
        if ((imeta = this.getInputRowMeta()) == null) {
            imeta = new RowMeta();
            this.setInputRowMeta(imeta);
        }
        try {
            row = this.getLoggingInfo(imeta, row);
        }
        catch (Exception e) {
            throw new HopException("Error getting Neo4j logging information", (Throwable)e);
        }
        if (this.isRowLevel()) {
            this.logRowlevel("System info returned: " + ((GetLoggingInfoData)this.data).outputRowMeta.getString(row));
        }
        this.putRow(((GetLoggingInfoData)this.data).outputRowMeta, row);
        if (!((GetLoggingInfoData)this.data).readsRows) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            ((GetLoggingInfoData)this.data).readsRows = false;
            List previous = this.getPipelineMeta().findPreviousTransforms(this.getTransformMeta());
            if (previous != null && !previous.isEmpty()) {
                ((GetLoggingInfoData)this.data).readsRows = true;
            }
            return true;
        }
        return false;
    }

    public void dispose() {
        super.dispose();
    }

    private Date getPreviousPipelineExecution(String pipelineName) throws Exception {
        NeoConnection connection = LoggingCore.getConnection(this.getPipeline().getMetadataProvider(), (IVariables)this.getPipeline());
        if (connection == null) {
            throw new HopException("Unable to find logging Neo4j connection (variable NEO4J_LOGGING_CONNECTION)");
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("type", "PIPELINE");
        parameters.put("name", pipelineName);
        parameters.put(CONST_STATUS, "Finished");
        String cypher = "MATCH(e:Execution { type: $type, name : $name }) WHERE e.status = $status RETURN e.name AS Name, e.executionStart AS startDate, e.errors AS errors, e.id AS id ORDER BY startDate DESC LIMIT 1 ";
        return this.getResultStartDate(this.getLogChannel(), connection, cypher, parameters);
    }

    private Date getPreviousPipelineSuccess(String pipelineName) throws Exception {
        NeoConnection connection = LoggingCore.getConnection(this.getPipeline().getMetadataProvider(), (IVariables)this.getPipeline());
        if (connection == null) {
            throw new HopException("Unable to find logging Neo4j connection (variable NEO4J_LOGGING_CONNECTION)");
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("type", "TRANS");
        parameters.put("name", pipelineName);
        parameters.put(CONST_STATUS, "Finished");
        String cypher = "MATCH(e:Execution { type: $type, name : $name }) WHERE e.errors = 0   AND e.status = $status RETURN e.name AS Name, e.executionStart AS startDate, e.errors AS errors, e.id AS id ORDER BY startDate DESC LIMIT 1 ";
        return this.getResultStartDate(this.getLogChannel(), connection, cypher, parameters);
    }

    private Date getPreviousWorkflowExecution(String jobName) throws Exception {
        NeoConnection connection = LoggingCore.getConnection(this.getPipeline().getMetadataProvider(), (IVariables)this.getPipeline());
        if (connection == null) {
            throw new HopException("Unable to find logging Neo4j connection (variable NEO4J_LOGGING_CONNECTION)");
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("type", "JOB");
        parameters.put("workflow", jobName);
        parameters.put(CONST_STATUS, "Finished");
        String cypher = "MATCH(e:Execution { type: $type, name : $job }) WHERE e.status = $status RETURN e.name AS Name, e.executionStart AS startDate, e.errors AS errors, e.id AS id ORDER BY startDate DESC LIMIT 1 ";
        return this.getResultStartDate(this.getLogChannel(), connection, cypher, parameters);
    }

    private Date getPreviousWorkflowSuccess(String jobName) throws Exception {
        NeoConnection connection = LoggingCore.getConnection(this.getPipeline().getMetadataProvider(), (IVariables)this.getPipeline());
        if (connection == null) {
            throw new HopException("Unable to find logging Neo4j connection (variable NEO4J_LOGGING_CONNECTION)");
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("type", "JOB");
        parameters.put("workflow", jobName);
        parameters.put(CONST_STATUS, "Finished");
        String cypher = "MATCH(e:Execution { type: $type, name : $job }) WHERE e.errors = 0   AND e.status = $status RETURN e.name AS Name, e.executionStart AS startDate, e.errors AS errors, e.id AS id ORDER BY startDate DESC LIMIT 1 ";
        return this.getResultStartDate(this.getLogChannel(), connection, cypher, parameters);
    }

    private Date getResultStartDate(ILogChannel log, NeoConnection connection, String cypher, Map<String, Object> parameters) throws Exception {
        return LoggingCore.executeCypher(log, (IVariables)this, connection, cypher, parameters, result -> {
            try {
                return this.getResultDate(result, "startDate");
            }
            catch (ParseException e) {
                throw new RuntimeException("Unable to get start date with cypher : " + cypher, e);
            }
        });
    }

    private Date getResultDate(Result result, String startDate) throws ParseException {
        if (result.hasNext()) {
            Record record = result.next();
            String string = record.get("startDate").asString();
            return new SimpleDateFormat("yyyy/MM/dd'T'HH:mm:ss").parse(string);
        }
        return null;
    }
}

