/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.wrappedio;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsContext;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.functional.FunctionRaisingIOE;
import org.apache.hadoop.util.functional.FunctionalIO;
import org.apache.hadoop.util.functional.Tuples;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class WrappedStatistics {
    private WrappedStatistics() {
    }

    public static boolean isIOStatisticsSource(Object object) {
        return object instanceof IOStatisticsSource;
    }

    public static boolean isIOStatistics(Object object) {
        return object instanceof IOStatistics;
    }

    public static boolean isIOStatisticsSnapshot(Serializable object) {
        return object instanceof IOStatisticsSnapshot;
    }

    public static boolean iostatisticsSnapshot_aggregate(Serializable snapshot, @Nullable Object statistics) {
        WrappedStatistics.requireIOStatisticsSnapshot(snapshot);
        if (statistics == null) {
            return false;
        }
        Preconditions.checkArgument(statistics instanceof IOStatistics, "Not an IOStatistics instance: %s", statistics);
        IOStatistics sourceStats = (IOStatistics)statistics;
        return WrappedStatistics.applyToIOStatisticsSnapshot(snapshot, s -> s.aggregate(sourceStats));
    }

    public static Serializable iostatisticsSnapshot_create() {
        return WrappedStatistics.iostatisticsSnapshot_create(null);
    }

    public static Serializable iostatisticsSnapshot_create(@Nullable Object source) {
        return new IOStatisticsSnapshot((IOStatistics)source);
    }

    public static Serializable iostatisticsSnapshot_load(FileSystem fs, Path path) {
        return FunctionalIO.uncheckIOExceptions(() -> IOStatisticsSnapshot.serializer().load(fs, path));
    }

    public static Serializable iostatisticsSnapshot_retrieve(@Nullable Object source) {
        IOStatistics stats = IOStatisticsSupport.retrieveIOStatistics(source);
        if (stats == null) {
            return null;
        }
        return WrappedStatistics.iostatisticsSnapshot_create(stats);
    }

    public static void iostatisticsSnapshot_save(@Nullable Serializable snapshot, FileSystem fs, Path path, boolean overwrite) {
        WrappedStatistics.applyToIOStatisticsSnapshot(snapshot, s -> {
            IOStatisticsSnapshot.serializer().save(fs, path, (IOStatisticsSnapshot)s, overwrite);
            return null;
        });
    }

    public static String iostatisticsSnapshot_toJsonString(@Nullable Serializable snapshot) {
        return WrappedStatistics.applyToIOStatisticsSnapshot(snapshot, IOStatisticsSnapshot.serializer()::toJson);
    }

    public static Serializable iostatisticsSnapshot_fromJsonString(String json) {
        return FunctionalIO.uncheckIOExceptions(() -> IOStatisticsSnapshot.serializer().fromJson(json));
    }

    public static Map<String, Long> iostatistics_counters(Serializable source) {
        return WrappedStatistics.applyToIOStatisticsSnapshot(source, IOStatisticsSnapshot::counters);
    }

    public static Map<String, Long> iostatistics_gauges(Serializable source) {
        return WrappedStatistics.applyToIOStatisticsSnapshot(source, IOStatisticsSnapshot::gauges);
    }

    public static Map<String, Long> iostatistics_minimums(Serializable source) {
        return WrappedStatistics.applyToIOStatisticsSnapshot(source, IOStatisticsSnapshot::minimums);
    }

    public static Map<String, Long> iostatistics_maximums(Serializable source) {
        return WrappedStatistics.applyToIOStatisticsSnapshot(source, IOStatisticsSnapshot::maximums);
    }

    public static Map<String, Map.Entry<Long, Long>> iostatistics_means(Serializable source) {
        return WrappedStatistics.applyToIOStatisticsSnapshot(source, stats -> {
            HashMap map = new HashMap();
            stats.meanStatistics().forEach((k, v) -> map.put(k, Tuples.pair(v.getSamples(), v.getSum())));
            return map;
        });
    }

    public static Object iostatisticsContext_getCurrent() {
        return IOStatisticsContext.getCurrentIOStatisticsContext();
    }

    public static void iostatisticsContext_setThreadIOStatisticsContext(@Nullable Object statisticsContext) {
        IOStatisticsContext.setThreadIOStatisticsContext((IOStatisticsContext)statisticsContext);
    }

    public static boolean iostatisticsContext_enabled() {
        return IOStatisticsContext.enabled();
    }

    public static void iostatisticsContext_reset() {
        IOStatisticsContext.getCurrentIOStatisticsContext().reset();
    }

    public static Serializable iostatisticsContext_snapshot() {
        return IOStatisticsContext.getCurrentIOStatisticsContext().snapshot();
    }

    public static boolean iostatisticsContext_aggregate(Object source) {
        IOStatistics stats = IOStatisticsSupport.retrieveIOStatistics(source);
        if (stats != null) {
            IOStatisticsContext.getCurrentIOStatisticsContext().getAggregator().aggregate(stats);
            return true;
        }
        return false;
    }

    public static String iostatistics_toPrettyString(@Nullable Object statistics) {
        return statistics == null ? "" : IOStatisticsLogging.ioStatisticsToPrettyString((IOStatistics)statistics);
    }

    public static <T> T applyToIOStatisticsSnapshot(Serializable source, FunctionRaisingIOE<IOStatisticsSnapshot, T> fun) {
        return fun.unchecked(WrappedStatistics.requireIOStatisticsSnapshot(source));
    }

    private static IOStatisticsSnapshot requireIOStatisticsSnapshot(Serializable snapshot) {
        Preconditions.checkArgument(snapshot instanceof IOStatisticsSnapshot, "Not an IOStatisticsSnapshot %s", snapshot);
        return (IOStatisticsSnapshot)snapshot;
    }
}

