/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableCharFloatMapFactory;
import org.eclipse.collections.api.map.primitive.CharFloatMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharFloatMap;
import org.eclipse.collections.impl.factory.primitive.CharFloatMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharFloatEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharFloatHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharFloatSingletonMap;

public class ImmutableCharFloatMapFactoryImpl
implements ImmutableCharFloatMapFactory {
    public static final ImmutableCharFloatMapFactory INSTANCE = new ImmutableCharFloatMapFactoryImpl();

    public ImmutableCharFloatMap empty() {
        return ImmutableCharFloatEmptyMap.INSTANCE;
    }

    public ImmutableCharFloatMap of() {
        return this.empty();
    }

    public ImmutableCharFloatMap with() {
        return this.empty();
    }

    public ImmutableCharFloatMap of(char key, float value) {
        return this.with(key, value);
    }

    public ImmutableCharFloatMap with(char key, float value) {
        return new ImmutableCharFloatSingletonMap(key, value);
    }

    public ImmutableCharFloatMap ofAll(CharFloatMap map) {
        return this.withAll(map);
    }

    public ImmutableCharFloatMap withAll(CharFloatMap map) {
        if (map instanceof ImmutableCharFloatMap) {
            return (ImmutableCharFloatMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            char key = map.keysView().charIterator().next();
            return new ImmutableCharFloatSingletonMap(key, map.get(key));
        }
        return new ImmutableCharFloatHashMap(map);
    }

    public <T> ImmutableCharFloatMap from(Iterable<T> iterable, CharFunction<? super T> keyFunction, FloatFunction<? super T> valueFunction) {
        return CharFloatMaps.mutable.from(iterable, keyFunction, valueFunction).toImmutable();
    }
}

