/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.util;

import java.util.Iterator;
import org.psjava.util.DataFilter;
import org.psjava.util.ReadOnlyIterator;

public class FilteredIterator {
    public static <T> Iterator<T> create(final Iterator<? extends T> a, final DataFilter<T> filter) {
        return new ReadOnlyIterator<T>(){
            T next = null;
            Iterator<? extends T> cursor = a;

            @Override
            public boolean hasNext() {
                this.tryToStepNext();
                return this.next != null;
            }

            @Override
            public T next() {
                this.tryToStepNext();
                Object r = this.next;
                this.next = null;
                return r;
            }

            private void tryToStepNext() {
                while (this.next == null && this.cursor.hasNext()) {
                    Object value = this.cursor.next();
                    if (!filter.isAccepted(value)) continue;
                    this.next = value;
                }
            }
        };
    }

    private FilteredIterator() {
    }
}

