/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mapping;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.serializer.xml.XmlMetadataUtil;
import org.apache.hop.pipeline.transforms.mapping.MappingVariableMapping;

public class MappingParameters
implements Cloneable {
    @HopMetadataProperty(key="variablemapping")
    private List<MappingVariableMapping> variableMappings = new ArrayList<MappingVariableMapping>();
    @HopMetadataProperty(key="inherit_all_vars")
    private boolean inheritingAllVariables = true;

    public MappingParameters() {
    }

    public MappingParameters(MappingParameters p) {
        this();
        this.inheritingAllVariables = p.inheritingAllVariables;
        for (MappingVariableMapping mapping : p.variableMappings) {
            this.variableMappings.add(new MappingVariableMapping(mapping));
        }
    }

    public String[] getVariables() {
        String[] vars = new String[this.variableMappings.size()];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = this.variableMappings.get(i).getName();
        }
        return vars;
    }

    public String[] getInputs() {
        String[] input = new String[this.variableMappings.size()];
        for (int i = 0; i < input.length; ++i) {
            input[i] = this.variableMappings.get(i).getValue();
        }
        return input;
    }

    public MappingParameters clone() {
        return new MappingParameters(this);
    }

    public String getXml() throws HopException {
        return XmlMetadataUtil.serializeObjectToXml((Object)this);
    }

    public List<MappingVariableMapping> getVariableMappings() {
        return this.variableMappings;
    }

    public void setVariableMappings(List<MappingVariableMapping> variableMappings) {
        this.variableMappings = variableMappings;
    }

    public boolean isInheritingAllVariables() {
        return this.inheritingAllVariables;
    }

    public void setInheritingAllVariables(boolean inheritingAllVariables) {
        this.inheritingAllVariables = inheritingAllVariables;
    }
}

