/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.abort;

import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.abort.AbortMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.util.SwtSvgImageUtil;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AbortDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = AbortDialog.class;
    private TextVar wRowThreshold;
    private TextVar wMessage;
    private Button wAlwaysLogRows;
    private final AbortMeta input;
    private ModifyListener lsMod;
    private SelectionAdapter lsSelMod;
    private Button wAbortButton;
    private Button wAbortWithErrorButton;
    private Button wSafeStopButton;
    private Group wOptionsGroup;
    private Label hSpacer;
    private final int middle;
    private final int margin;

    public AbortDialog(Shell parent, IVariables variables, AbortMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.middle = this.props.getMiddlePct();
        this.margin = PropsUi.getMargin();
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setMinimumSize(400, 520);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        this.lsMod = e -> this.input.setChanged();
        this.lsSelMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AbortDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"AbortDialog.Shell.Title", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        AbortDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)PropsUi.getMargin(), null);
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        PropsUi.setLook((Widget)wicon);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"AbortDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment((Control)wicon, 0, 0x1000000);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(this.lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment((Control)this.wlTransformName, this.margin);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment((Control)wicon, -this.margin);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label spacer = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)wicon, 0);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        this.hSpacer = new Label((Composite)this.shell, 258);
        FormData fdhSpacer = new FormData();
        fdhSpacer.height = 2;
        fdhSpacer.left = new FormAttachment(0, 0);
        fdhSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdhSpacer.right = new FormAttachment(100, 0);
        this.hSpacer.setLayoutData((Object)fdhSpacer);
        this.buildOptions((Control)spacer);
        this.buildLogging((Composite)this.wOptionsGroup);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void buildOptions(Control widgetAbove) {
        this.wOptionsGroup = new Group((Composite)this.shell, 16);
        PropsUi.setLook((Widget)this.wOptionsGroup);
        this.wOptionsGroup.setText(BaseMessages.getString(PKG, (String)"AbortDialog.Options.Group.Label", (String[])new String[0]));
        FormLayout flOptionsGroup = new FormLayout();
        flOptionsGroup.marginHeight = 15;
        flOptionsGroup.marginWidth = 15;
        this.wOptionsGroup.setLayout((Layout)flOptionsGroup);
        FormData fdOptionsGroup = new FormData();
        fdOptionsGroup.left = new FormAttachment(0, 0);
        fdOptionsGroup.top = new FormAttachment(widgetAbove, 15);
        fdOptionsGroup.right = new FormAttachment(100, 0);
        this.wOptionsGroup.setLayoutData((Object)fdOptionsGroup);
        this.wAbortButton = new Button((Composite)this.wOptionsGroup, 16);
        this.wAbortButton.addSelectionListener((SelectionListener)this.lsSelMod);
        this.wAbortButton.setText(BaseMessages.getString(PKG, (String)"AbortDialog.Options.Abort.Label", (String[])new String[0]));
        FormData fdAbort = new FormData();
        fdAbort.left = new FormAttachment(this.middle, this.margin);
        fdAbort.top = new FormAttachment(0, 0);
        this.wAbortButton.setLayoutData((Object)fdAbort);
        PropsUi.setLook((Widget)this.wAbortButton);
        this.wAbortWithErrorButton = new Button((Composite)this.wOptionsGroup, 16);
        this.wAbortWithErrorButton.addSelectionListener((SelectionListener)this.lsSelMod);
        this.wAbortWithErrorButton.setText(BaseMessages.getString(PKG, (String)"AbortDialog.Options.AbortWithError.Label", (String[])new String[0]));
        FormData fdAbortWithError = new FormData();
        fdAbortWithError.left = new FormAttachment(this.middle, this.margin);
        fdAbortWithError.top = new FormAttachment((Control)this.wAbortButton, 10);
        this.wAbortWithErrorButton.setLayoutData((Object)fdAbortWithError);
        PropsUi.setLook((Widget)this.wAbortWithErrorButton);
        this.wSafeStopButton = new Button((Composite)this.wOptionsGroup, 16);
        this.wSafeStopButton.addSelectionListener((SelectionListener)this.lsSelMod);
        this.wSafeStopButton.setText(BaseMessages.getString(PKG, (String)"AbortDialog.Options.SafeStop.Label", (String[])new String[0]));
        FormData fdSafeStop = new FormData();
        fdSafeStop.left = new FormAttachment(this.middle, this.margin);
        fdSafeStop.top = new FormAttachment((Control)this.wAbortWithErrorButton, 10);
        this.wSafeStopButton.setLayoutData((Object)fdSafeStop);
        PropsUi.setLook((Widget)this.wSafeStopButton);
        Label wlRowThreshold = new Label((Composite)this.wOptionsGroup, 131072);
        wlRowThreshold.setText(BaseMessages.getString(PKG, (String)"AbortDialog.Options.RowThreshold.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRowThreshold);
        FormData fdlRowThreshold = new FormData();
        fdlRowThreshold.left = new FormAttachment(0, 0);
        fdlRowThreshold.top = new FormAttachment((Control)this.wSafeStopButton, 10);
        fdlRowThreshold.right = new FormAttachment(this.middle, -this.margin);
        wlRowThreshold.setLayoutData((Object)fdlRowThreshold);
        this.wRowThreshold = new TextVar(this.variables, (Composite)this.wOptionsGroup, 18436);
        this.wRowThreshold.setText("");
        PropsUi.setLook((Widget)this.wRowThreshold);
        this.wRowThreshold.addModifyListener(this.lsMod);
        this.wRowThreshold.setToolTipText(BaseMessages.getString(PKG, (String)"AbortDialog.Options.RowThreshold.Tooltip", (String[])new String[0]));
        FormData fdRowThreshold = new FormData();
        fdRowThreshold.left = new FormAttachment((Control)wlRowThreshold, this.margin);
        fdRowThreshold.top = new FormAttachment((Control)wlRowThreshold, 0, 0x1000000);
        fdRowThreshold.right = new FormAttachment(100, 0);
        this.wRowThreshold.setLayoutData((Object)fdRowThreshold);
    }

    private void buildLogging(Composite widgetAbove) {
        Group wLoggingGroup = new Group((Composite)this.shell, 16);
        PropsUi.setLook((Widget)wLoggingGroup);
        wLoggingGroup.setText(BaseMessages.getString(PKG, (String)"AbortDialog.Logging.Group", (String[])new String[0]));
        FormLayout flLoggingGroup = new FormLayout();
        flLoggingGroup.marginHeight = 15;
        flLoggingGroup.marginWidth = 15;
        wLoggingGroup.setLayout((Layout)flLoggingGroup);
        FormData fdLoggingGroup = new FormData();
        fdLoggingGroup.left = new FormAttachment(0, 0);
        fdLoggingGroup.top = new FormAttachment((Control)widgetAbove, 15);
        fdLoggingGroup.right = new FormAttachment(100, 0);
        fdLoggingGroup.bottom = new FormAttachment((Control)this.hSpacer, -15);
        wLoggingGroup.setLayoutData((Object)fdLoggingGroup);
        Label wlMessage = new Label((Composite)wLoggingGroup, 131072);
        wlMessage.setText(BaseMessages.getString(PKG, (String)"AbortDialog.Logging.AbortMessage.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMessage);
        FormData fdlMessage = new FormData();
        fdlMessage.left = new FormAttachment(0, 0);
        fdlMessage.top = new FormAttachment(0, 0);
        fdlMessage.right = new FormAttachment(this.middle, -this.margin);
        wlMessage.setLayoutData((Object)fdlMessage);
        this.wMessage = new TextVar(this.variables, (Composite)wLoggingGroup, 18436);
        this.wMessage.setText("");
        PropsUi.setLook((Widget)this.wMessage);
        this.wMessage.addModifyListener(this.lsMod);
        this.wMessage.setToolTipText(BaseMessages.getString(PKG, (String)"AbortDialog.Logging.AbortMessage.Tooltip", (String[])new String[0]));
        FormData fdMessage = new FormData();
        fdMessage.left = new FormAttachment((Control)wlMessage, this.margin);
        fdMessage.top = new FormAttachment((Control)wlMessage, 0, 0x1000000);
        fdMessage.right = new FormAttachment(100, 0);
        this.wMessage.setLayoutData((Object)fdMessage);
        this.wAlwaysLogRows = new Button((Composite)wLoggingGroup, 32);
        this.wAlwaysLogRows.setText(BaseMessages.getString(PKG, (String)"AbortDialog.Logging.AlwaysLogRows.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wAlwaysLogRows);
        this.wAlwaysLogRows.setToolTipText(BaseMessages.getString(PKG, (String)"AbortDialog.Logging.AlwaysLogRows.Tooltip", (String[])new String[0]));
        FormData fdAlwaysLogRows = new FormData();
        fdAlwaysLogRows.left = new FormAttachment(this.middle, this.margin);
        fdAlwaysLogRows.top = new FormAttachment((Control)this.wMessage, 10);
        this.wAlwaysLogRows.setLayoutData((Object)fdAlwaysLogRows);
        this.wAlwaysLogRows.addSelectionListener((SelectionListener)this.lsSelMod);
    }

    private Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"abort.svg", (int)48, (int)48);
    }

    public void getData() {
        if (this.input.getRowThreshold() != null) {
            this.wRowThreshold.setText(this.input.getRowThreshold());
        }
        if (this.input.getMessage() != null) {
            this.wMessage.setText(this.input.getMessage());
        }
        this.wAlwaysLogRows.setSelection(this.input.isAlwaysLogRows());
        this.wAbortButton.setSelection(this.input.isAbort());
        this.wAbortWithErrorButton.setSelection(this.input.isAbortWithError());
        this.wSafeStopButton.setSelection(this.input.isSafeStop());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void getInfo(AbortMeta in) {
        this.input.setRowThreshold(this.wRowThreshold.getText());
        this.input.setMessage(this.wMessage.getText());
        this.input.setAlwaysLogRows(this.wAlwaysLogRows.getSelection());
        AbortMeta.AbortOption abortOption = AbortMeta.AbortOption.ABORT;
        if (this.wAbortWithErrorButton.getSelection()) {
            abortOption = AbortMeta.AbortOption.ABORT_WITH_ERROR;
        } else if (this.wSafeStopButton.getSelection()) {
            abortOption = AbortMeta.AbortOption.SAFE_STOP;
        }
        this.input.setAbortOption(abortOption);
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }
}

