/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.base.ValueType;
import org.drools.core.base.evaluators.EvaluatorDefinition;
import org.drools.core.base.evaluators.Operator;
import org.drools.core.base.evaluators.PointInTimeEvaluator;
import org.drools.core.base.evaluators.TimeIntervalParser;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.spi.Evaluator;
import org.drools.core.time.Interval;

public class AfterEvaluatorDefinition
implements EvaluatorDefinition {
    protected static final String afterOp = "after";
    public static Operator AFTER;
    public static Operator NOT_AFTER;
    private static String[] SUPPORTED_IDS;
    private Map<String, AfterEvaluator> cache = Collections.emptyMap();

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        String key;
        AfterEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, AfterEvaluator>();
        }
        if ((eval = this.cache.get(key = (Object)((Object)left) + ":" + (Object)((Object)right) + ":" + isNegated + ":" + parameterText)) == null) {
            long[] params = TimeIntervalParser.parse(parameterText);
            eval = new AfterEvaluator(type, isNegated, params, parameterText, left == EvaluatorDefinition.Target.FACT, right == EvaluatorDefinition.Target.FACT);
            this.cache.put(key, eval);
        }
        return eval;
    }

    @Override
    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.BOTH;
    }

    @Override
    public boolean supportsType(ValueType type) {
        return true;
    }

    static {
        if (Operator.determineOperator(afterOp, false) == null) {
            AFTER = Operator.addOperatorToRegistry(afterOp, false);
            NOT_AFTER = Operator.addOperatorToRegistry(afterOp, true);
            SUPPORTED_IDS = new String[]{afterOp};
        }
    }

    public static class AfterEvaluator
    extends PointInTimeEvaluator {
        private static final long serialVersionUID = 510L;

        public AfterEvaluator() {
        }

        public AfterEvaluator(ValueType type, boolean isNegated, long[] parameters, String paramText, boolean unwrapLeft, boolean unwrapRight) {
            super(type, isNegated ? NOT_AFTER : AFTER, parameters, paramText, unwrapLeft, unwrapRight);
        }

        @Override
        public Interval getInterval() {
            long init = this.initRange;
            long end = this.finalRange;
            if (this.getOperator().isNegated()) {
                if (init == Long.MIN_VALUE && end != Long.MAX_VALUE) {
                    init = this.finalRange + 1L;
                    end = Long.MAX_VALUE;
                } else if (init != Long.MIN_VALUE && end == Long.MAX_VALUE) {
                    init = Long.MIN_VALUE;
                    end = this.initRange - 1L;
                } else if (init == Long.MIN_VALUE) {
                    init = 0L;
                    end = -1L;
                } else {
                    init = Long.MIN_VALUE;
                    end = Long.MAX_VALUE;
                }
            }
            return new Interval(init, end);
        }

        @Override
        protected boolean evaluate(long rightTS, long leftTS) {
            long dist = rightTS - leftTS;
            return this.getOperator().isNegated() ^ (dist >= this.initRange && dist <= this.finalRange);
        }

        @Override
        protected long getLeftTimestamp(InternalFactHandle handle) {
            return ((EventFactHandle)handle).getEndTimestamp();
        }

        @Override
        protected long getRightTimestamp(InternalFactHandle handle) {
            return ((EventFactHandle)handle).getStartTimestamp();
        }
    }
}

