/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;

@PublicEvolving
public enum TernaryBoolean {
    TRUE,
    FALSE,
    UNDEFINED;


    public boolean getOrDefault(boolean defaultValue) {
        return this == UNDEFINED ? defaultValue : this == TRUE;
    }

    public TernaryBoolean resolveUndefined(boolean valueForUndefined) {
        return this != UNDEFINED ? this : TernaryBoolean.fromBoolean(valueForUndefined);
    }

    @Nullable
    public Boolean getAsBoolean() {
        return this == UNDEFINED ? null : (this == TRUE ? Boolean.TRUE : Boolean.FALSE);
    }

    public static TernaryBoolean fromBoolean(boolean bool) {
        return bool ? TRUE : FALSE;
    }

    public static TernaryBoolean fromBoxedBoolean(@Nullable Boolean bool) {
        return bool == null ? UNDEFINED : TernaryBoolean.fromBoolean(bool);
    }
}

