/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.databaselookup.readallcache;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.PriorityQueue;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.pipeline.transforms.databaselookup.DatabaseLookupData;
import org.apache.hop.pipeline.transforms.databaselookup.DatabaseLookupMeta;
import org.apache.hop.pipeline.transforms.databaselookup.readallcache.EqIndex;
import org.apache.hop.pipeline.transforms.databaselookup.readallcache.GtIndex;
import org.apache.hop.pipeline.transforms.databaselookup.readallcache.Index;
import org.apache.hop.pipeline.transforms.databaselookup.readallcache.IsNullIndex;
import org.apache.hop.pipeline.transforms.databaselookup.readallcache.LtIndex;
import org.apache.hop.pipeline.transforms.databaselookup.readallcache.SearchingContext;

public class ReadAllCache
implements DatabaseLookupData.ICache {
    private final DatabaseLookupData transformData;
    private final Object[][] keys;
    private final IRowMeta keysMeta;
    private final Object[][] data;
    private final Index[] indexes;
    private final int[][] otherConditions;

    ReadAllCache(DatabaseLookupData transformData, Object[][] keys, IRowMeta keysMeta, Object[][] data) {
        this.transformData = transformData;
        this.keys = keys;
        this.keysMeta = keysMeta;
        this.data = data;
        Object[] pair = ReadAllCache.createIndexes(transformData, keysMeta, keys);
        this.indexes = (Index[])pair[0];
        this.otherConditions = (int[][])pair[1];
    }

    private static Object[] createIndexes(DatabaseLookupData transformData, IRowMeta keysMeta, Object[][] keys) {
        int rowsAmount = keys.length;
        int[] conditions = transformData.conditions;
        PriorityQueue<Index> indexes = new PriorityQueue<Index>(conditions.length, Index.restrictionComparator());
        ArrayList<int[]> otherConditions = new ArrayList<int[]>();
        int len = conditions.length;
        for (int i = 0; i < len; ++i) {
            int condition = conditions[i];
            Index index = null;
            switch (condition) {
                case 0: {
                    index = new EqIndex(i, keysMeta.getValueMeta(i), rowsAmount);
                    break;
                }
                case 1: {
                    index = EqIndex.nonEqualityIndex(i, keysMeta.getValueMeta(i), rowsAmount);
                    break;
                }
                case 2: {
                    index = new LtIndex(i, keysMeta.getValueMeta(i), rowsAmount);
                    break;
                }
                case 3: {
                    index = GtIndex.lessOrEqualCache(i, keysMeta.getValueMeta(i), rowsAmount);
                    break;
                }
                case 4: {
                    index = new GtIndex(i, keysMeta.getValueMeta(i), rowsAmount);
                    break;
                }
                case 5: {
                    index = LtIndex.greaterOrEqualCache(i, keysMeta.getValueMeta(i), rowsAmount);
                    break;
                }
                case 8: {
                    index = new IsNullIndex(i, keysMeta.getValueMeta(i), rowsAmount, true);
                    break;
                }
                case 9: {
                    index = new IsNullIndex(i, keysMeta.getValueMeta(i), rowsAmount, false);
                }
            }
            if (index == null) {
                otherConditions.add(new int[]{i, condition});
                continue;
            }
            index.performIndexingOf(keys);
            indexes.add(index);
        }
        return new Object[]{indexes.toArray(new Index[indexes.size()]), otherConditions.toArray((T[])new int[otherConditions.size()][])};
    }

    @Override
    public Object[] getRowFromCache(IRowMeta lookupMeta, Object[] lookupRow) throws HopException {
        if (this.transformData.hasDBCondition) {
            return null;
        }
        SearchingContext context = new SearchingContext();
        context.init(this.keys.length);
        for (Index index : this.indexes) {
            int column = index.getColumn();
            Object lookupValue = column < lookupRow.length ? lookupRow[column] : null;
            index.applyRestrictionsTo(context, lookupMeta.getValueMeta(column), lookupValue);
            if (!context.isEmpty()) continue;
            return null;
        }
        BitSet candidates = context.getCandidates();
        int candidate = candidates.nextSetBit(0);
        while (candidate != -1) {
            Object[] dataKeys = this.keys[candidate];
            boolean matches = true;
            int lookupShift = 0;
            int len = this.otherConditions.length;
            for (int i = 0; i < len && matches; ++i) {
                int[] columnConditionPair = this.otherConditions[i];
                int column = columnConditionPair[0];
                Object keyData = dataKeys[column];
                IValueMeta keyMeta = this.keysMeta.getValueMeta(column);
                int lookupIndex = column + lookupShift;
                Object cmpData = lookupRow[lookupIndex];
                IValueMeta cmpMeta = lookupMeta.getValueMeta(lookupIndex);
                int condition = columnConditionPair[1];
                if (condition == 7) {
                    Object cmpData2;
                    IValueMeta cmpMeta2;
                    boolean bl = matches = keyMeta.compare(keyData, cmpMeta, cmpData) >= 0;
                    if (!matches) continue;
                    ++lookupShift;
                    matches = keyMeta.compare(keyData, cmpMeta2 = lookupMeta.getValueMeta(++lookupIndex), cmpData2 = lookupRow[lookupIndex]) <= 0;
                    continue;
                }
                matches = false;
                this.transformData.hasDBCondition = true;
            }
            if (matches) {
                return this.data[candidate];
            }
            candidate = candidates.nextSetBit(candidate + 1);
        }
        return null;
    }

    @Override
    public void storeRowInCache(DatabaseLookupMeta meta, IRowMeta lookupMeta, Object[] lookupRow, Object[] add) {
        throw new UnsupportedOperationException("This cache is read-only");
    }

    public static class Builder {
        private final DatabaseLookupData transformData;
        private final Object[][] keys;
        private final Object[][] data;
        private IRowMeta keysMeta;
        private int current;

        public Builder(DatabaseLookupData transformData, int amount) {
            this.transformData = transformData;
            this.keys = new Object[amount][];
            this.data = new Object[amount][];
        }

        public void setKeysMeta(IRowMeta keysMeta) {
            this.keysMeta = keysMeta;
        }

        public void add(Object[] keys, Object[] data) {
            this.keys[this.current] = keys;
            this.data[this.current] = data;
            ++this.current;
        }

        public ReadAllCache build() {
            return new ReadAllCache(this.transformData, this.keys, this.keysMeta, this.data);
        }
    }
}

