/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.i18n;

import java.util.Locale;
import org.apache.hop.core.Const;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.i18n.GlobalMessages;

public class LanguageChoice {
    private static final String STRING_DEFAULT_LOCALE = "LocaleDefault";
    private static LanguageChoice choice;
    private Locale defaultLocale;

    private LanguageChoice() {
        String defaultLocaleString = HopConfig.readOptionString(STRING_DEFAULT_LOCALE, null);
        if (defaultLocaleString == null) {
            int localeIdx;
            this.defaultLocale = Locale.getDefault();
            if (!StringUtil.isEmpty(this.defaultLocale.getVariant()) || !StringUtil.isEmpty(this.defaultLocale.getScript())) {
                this.defaultLocale = new Locale(this.defaultLocale.getLanguage(), this.defaultLocale.getCountry());
            }
            if ((localeIdx = Const.indexOfString(this.defaultLocale.toString(), GlobalMessages.localeCodes)) < 0 || GlobalMessages.localeBetaStatus[localeIdx].equals("Y")) {
                this.defaultLocale = Locale.forLanguageTag("en-US");
            }
            HopConfig.getInstance().saveOption(STRING_DEFAULT_LOCALE, this.defaultLocale.toString());
        } else {
            this.defaultLocale = EnvUtil.createLocale(defaultLocaleString);
        }
    }

    public static final LanguageChoice getInstance() {
        if (choice == null) {
            choice = new LanguageChoice();
        }
        return choice;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
        HopConfig.getInstance().saveOption(STRING_DEFAULT_LOCALE, defaultLocale.toString());
    }
}

