/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.row.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaPlugin;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;

@ValueMetaPlugin(id="10", name="Internet Address", description="Internet Address", image="images/inet.svg")
public class ValueMetaInternetAddress
extends ValueMetaDate {
    private static final String CONST_SPECIFIED = " specified.";
    private static final String CONST_UNKNOWN_TYPE = " : Unknown storage type ";

    @Override
    public int compare(Object data1, Object data2) throws HopValueException {
        InetAddress inet1 = this.getInternetAddress(data1);
        InetAddress inet2 = this.getInternetAddress(data2);
        int cmp = 0;
        if (inet1 == null) {
            cmp = inet2 == null ? 0 : -1;
        } else if (inet2 == null) {
            cmp = 1;
        } else {
            BigDecimal bd1 = this.getBigNumber(inet1);
            BigDecimal bd2 = this.getBigNumber(inet2);
            cmp = bd1.compareTo(bd2);
        }
        if (this.isSortedDescending()) {
            return -cmp;
        }
        return cmp;
    }

    public ValueMetaInternetAddress() {
        this((String)null);
    }

    public ValueMetaInternetAddress(String name) {
        super(name, 10);
    }

    public InetAddress getInternetAddress(Object object) throws HopValueException {
        if (object == null) {
            return null;
        }
        switch (this.type) {
            case 10: {
                switch (this.storageType) {
                    case 0: {
                        return (InetAddress)object;
                    }
                    case 1: {
                        return (InetAddress)this.convertBinaryStringToNativeType((byte[])object);
                    }
                    case 2: {
                        return (InetAddress)this.index[(Integer)object];
                    }
                }
                throw new HopValueException(String.valueOf(this) + CONST_UNKNOWN_TYPE + this.storageType + CONST_SPECIFIED);
            }
            case 2: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertStringToInternetAddress((String)object);
                    }
                    case 1: {
                        return this.convertStringToInternetAddress((String)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertStringToInternetAddress((String)this.index[(Integer)object]);
                    }
                }
                throw new HopValueException(String.valueOf(this) + CONST_UNKNOWN_TYPE + this.storageType + CONST_SPECIFIED);
            }
            case 1: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertNumberToInternetAddress((Double)object);
                    }
                    case 1: {
                        return this.convertNumberToInternetAddress((Double)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertNumberToInternetAddress((Double)this.index[(Integer)object]);
                    }
                }
                throw new HopValueException(String.valueOf(this) + CONST_UNKNOWN_TYPE + this.storageType + CONST_SPECIFIED);
            }
            case 5: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertIntegerToInternetAddress((Long)object);
                    }
                    case 1: {
                        return this.convertIntegerToInternetAddress((Long)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertIntegerToInternetAddress((Long)this.index[(Integer)object]);
                    }
                }
                throw new HopValueException(String.valueOf(this) + CONST_UNKNOWN_TYPE + this.storageType + CONST_SPECIFIED);
            }
            case 6: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertBigNumberToInternetAddress((BigDecimal)object);
                    }
                    case 1: {
                        return this.convertBigNumberToInternetAddress((BigDecimal)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertBigNumberToInternetAddress((BigDecimal)this.index[(Integer)object]);
                    }
                }
                throw new HopValueException(String.valueOf(this) + CONST_UNKNOWN_TYPE + this.storageType + CONST_SPECIFIED);
            }
            case 4: {
                throw new HopValueException(String.valueOf(this) + " : I don't know how to convert a boolean to a Internet address.");
            }
            case 8: {
                throw new HopValueException(String.valueOf(this) + " : I don't know how to convert a binary value to Internet address.");
            }
            case 7: {
                throw new HopValueException(String.valueOf(this) + " : I don't know how to convert a serializable value to Internet address.");
            }
        }
        throw new HopValueException(String.valueOf(this) + " : Unknown type " + this.type + CONST_SPECIFIED);
    }

    @Override
    public Date getDate(Object object) throws HopValueException {
        throw new HopValueException(this.toStringMeta() + ": it's not possible to convert from Internet Address to a date");
    }

    @Override
    public Long getInteger(Object object) throws HopValueException {
        InetAddress address = this.getInternetAddress(object);
        if (address == null) {
            return null;
        }
        long total = 0L;
        byte[] addr = address.getAddress();
        if (addr.length > 8) {
            throw new HopValueException("Unable to convert Internet Address v6 to an Integer: " + this.getString(object) + " (The precision is too high to be contained in a long integer value)");
        }
        for (int i = 0; i < addr.length; ++i) {
            total += (long)(addr[i] & 0xFF) * (long)Math.pow(256.0, addr.length - 1 - i);
        }
        return total;
    }

    @Override
    public Double getNumber(Object object) throws HopValueException {
        Long l = this.getInteger(object);
        if (l == null) {
            return null;
        }
        return l.doubleValue();
    }

    @Override
    public BigDecimal getBigNumber(Object object) throws HopValueException {
        byte[] addr;
        InetAddress address = this.getInternetAddress(object);
        if (null == address) {
            return null;
        }
        BigInteger bi = BigInteger.ZERO;
        for (byte aByte : addr = address.getAddress()) {
            bi = bi.shiftLeft(8).add(BigInteger.valueOf(aByte & 0xFF));
        }
        return new BigDecimal(bi);
    }

    @Override
    public Boolean getBoolean(Object object) throws HopValueException {
        throw new HopValueException(this.toStringMeta() + ": it's not possible to convert from an Internet Address to a Boolean");
    }

    @Override
    public String getString(Object object) throws HopValueException {
        return this.convertInternetAddressToString(this.getInternetAddress(object));
    }

    @Override
    public byte[] getBinaryString(Object object) throws HopValueException {
        if (this.isStorageBinaryString() && this.identicalFormat) {
            return (byte[])object;
        }
        if (object == null) {
            return null;
        }
        switch (this.storageType) {
            case 0: {
                return this.convertStringToBinaryString(this.getString(object));
            }
            case 1: {
                return this.convertStringToBinaryString(this.getString(this.convertStringToInternetAddress(this.convertBinaryStringToString((byte[])object))));
            }
            case 2: {
                return this.convertStringToBinaryString(this.convertInternetAddressToString((InetAddress)this.index[(Integer)object]));
            }
        }
        throw new HopValueException(String.valueOf(this) + CONST_UNKNOWN_TYPE + this.storageType + CONST_SPECIFIED);
    }

    protected InetAddress convertBigNumberToInternetAddress(BigDecimal bd) throws HopValueException {
        if (bd == null) {
            return null;
        }
        return this.convertIntegerToInternetAddress(bd.longValue());
    }

    protected InetAddress convertNumberToInternetAddress(Double d) throws HopValueException {
        if (d == null) {
            return null;
        }
        long nanos = d.longValue();
        return this.convertIntegerToInternetAddress(nanos);
    }

    protected InetAddress convertIntegerToInternetAddress(Long l) throws HopValueException {
        if (l == null) {
            return null;
        }
        byte[] addr = (double)l.longValue() >= Math.pow(256.0, 4.0) ? new byte[16] : new byte[4];
        for (int i = 0; i < addr.length; ++i) {
            long mask = 255L << i * 8;
            addr[addr.length - 1 - i] = (byte)((l & mask) >> 8 * i);
        }
        try {
            return InetAddress.getByAddress(addr);
        }
        catch (Exception e) {
            throw new HopValueException("Unable to convert an Integer to an internet address", e);
        }
    }

    protected synchronized InetAddress convertStringToInternetAddress(String string) throws HopValueException {
        if (Utils.isEmpty(string = Const.trimToType(string, this.getTrimType()))) {
            return null;
        }
        try {
            return InetAddress.getByName(string);
        }
        catch (Exception e) {
            throw new HopValueException(String.valueOf(this) + " : couldn't convert string [" + string + "] to an internet address", e);
        }
    }

    protected synchronized String convertInternetAddressToString(InetAddress inetAddress) {
        if (inetAddress == null) {
            return null;
        }
        return inetAddress.getHostAddress();
    }

    @Override
    public Object convertDataFromString(String pol, IValueMeta convertMeta, String nullIf, String ifNull, int trimType) throws HopValueException {
        String nullValue = nullIf;
        if (nullValue == null) {
            switch (convertMeta.getType()) {
                case 4: {
                    nullValue = "";
                    break;
                }
                case 2: {
                    nullValue = "";
                    break;
                }
                case 6: {
                    nullValue = "";
                    break;
                }
                case 1: {
                    nullValue = "";
                    break;
                }
                case 5: {
                    nullValue = "";
                    break;
                }
                case 3: {
                    nullValue = "";
                    break;
                }
                case 8: {
                    nullValue = "";
                    break;
                }
                default: {
                    nullValue = "";
                }
            }
        }
        if (!Utils.isEmpty(ifNull) && (Utils.isEmpty(pol) || pol.equalsIgnoreCase(Const.rightPad(new StringBuilder(nullValue), pol.length())))) {
            pol = ifNull;
        }
        if (Utils.isEmpty(pol)) {
            return null;
        }
        if (!Utils.isEmpty(nullValue) ? nullValue.length() <= pol.length() && pol.equalsIgnoreCase(Const.rightPad(new StringBuilder(nullValue), pol.length())) : Const.onlySpaces(pol)) {
            return null;
        }
        switch (trimType) {
            case 1: {
                StringBuilder strpol = new StringBuilder(pol);
                while (strpol.length() > 0 && strpol.charAt(0) == ' ') {
                    strpol.deleteCharAt(0);
                }
                pol = strpol.toString();
                break;
            }
            case 2: {
                StringBuilder strpol = new StringBuilder(pol);
                while (strpol.length() > 0 && strpol.charAt(strpol.length() - 1) == ' ') {
                    strpol.deleteCharAt(strpol.length() - 1);
                }
                pol = strpol.toString();
                break;
            }
            case 3: {
                StringBuilder strpol = new StringBuilder(pol);
                while (strpol.length() > 0 && strpol.charAt(0) == ' ') {
                    strpol.deleteCharAt(0);
                }
                while (strpol.length() > 0 && strpol.charAt(strpol.length() - 1) == ' ') {
                    strpol.deleteCharAt(strpol.length() - 1);
                }
                pol = strpol.toString();
                break;
            }
        }
        return this.convertData(convertMeta, pol);
    }

    @Override
    public Object convertData(IValueMeta meta2, Object data2) throws HopValueException {
        switch (meta2.getType()) {
            case 2: {
                return this.convertStringToInternetAddress(meta2.getString(data2));
            }
            case 5: {
                return this.convertIntegerToInternetAddress(meta2.getInteger(data2));
            }
            case 1: {
                return this.convertNumberToInternetAddress(meta2.getNumber(data2));
            }
            case 6: {
                return this.convertBigNumberToInternetAddress(meta2.getBigNumber(data2));
            }
            case 10: {
                return ((ValueMetaInternetAddress)meta2).getInternetAddress(data2);
            }
        }
        throw new HopValueException(meta2.toStringMeta() + " : can't be converted to an Internet Address");
    }

    @Override
    public Object cloneValueData(Object object) throws HopValueException {
        InetAddress inetAddress = this.getInternetAddress(object);
        if (inetAddress == null) {
            return null;
        }
        try {
            return InetAddress.getByAddress(inetAddress.getAddress());
        }
        catch (Exception e) {
            throw new HopValueException("Unable to clone Internet Address", e);
        }
    }

    @Override
    public IValueMeta getMetadataPreview(IVariables variables, DatabaseMeta databaseMeta, ResultSet rs) throws HopDatabaseException {
        try {
            if ("INET".equalsIgnoreCase(rs.getString("TYPE_NAME"))) {
                IValueMeta vmi = super.getMetadataPreview(variables, databaseMeta, rs);
                ValueMetaInternetAddress valueMeta = new ValueMetaInternetAddress(this.name);
                valueMeta.setLength(vmi.getLength());
                valueMeta.setOriginalColumnType(vmi.getOriginalColumnType());
                valueMeta.setOriginalColumnTypeName(vmi.getOriginalColumnTypeName());
                valueMeta.setOriginalNullable(vmi.getOriginalNullable());
                valueMeta.setOriginalPrecision(vmi.getOriginalPrecision());
                valueMeta.setOriginalScale(vmi.getOriginalScale());
                valueMeta.setOriginalSigned(vmi.getOriginalSigned());
                return valueMeta;
            }
        }
        catch (SQLException e) {
            throw new HopDatabaseException(e);
        }
        return null;
    }

    @Override
    public IValueMeta getValueFromSqlType(IVariables variables, DatabaseMeta databaseMeta, String name, ResultSetMetaData rm, int index, boolean ignoreLength, boolean lazyConversion) throws HopDatabaseException {
        try {
            String columnTypeName;
            int type = rm.getColumnType(index);
            if (type == 1111 && "INET".equalsIgnoreCase(columnTypeName = rm.getColumnTypeName(index))) {
                ValueMetaInternetAddress valueMeta = new ValueMetaInternetAddress(name);
                this.getOriginalColumnMetadata(valueMeta, rm, index, ignoreLength);
                return valueMeta;
            }
            return null;
        }
        catch (Exception e) {
            throw new HopDatabaseException("Error evaluating Internet address value metadata", e);
        }
    }

    @Override
    public Object getValueFromResultSet(IDatabase iDatabase, ResultSet resultSet, int index) throws HopDatabaseException {
        try {
            return this.convertStringToInternetAddress(resultSet.getString(index + 1));
        }
        catch (Exception e) {
            throw new HopDatabaseException(this.toStringMeta() + " : Unable to get Internet Address from resultset at index " + index, e);
        }
    }

    @Override
    public void setPreparedStatementValue(DatabaseMeta databaseMeta, PreparedStatement preparedStatement, int index, Object data) throws HopDatabaseException {
        try {
            preparedStatement.setObject(index, (Object)this.getString(data), 1111);
        }
        catch (Exception e) {
            throw new HopDatabaseException(this.toStringMeta() + " : Unable to set Internet address value on prepared statement on index " + index, e);
        }
    }

    @Override
    public String getDatabaseColumnTypeDefinition(IDatabase iDatabase, String tk, String pk, boolean useAutoIncrement, boolean addFieldName, boolean addCr) {
        Object retval = null;
        if (iDatabase.isPostgresVariant()) {
            retval = addFieldName ? this.getName() + " " : "";
            retval = (String)retval + "INET";
            if (addCr) {
                retval = (String)retval + Const.CR;
            }
        }
        return retval;
    }

    @Override
    public Object getNativeDataType(Object object) throws HopValueException {
        return this.getInternetAddress(object);
    }

    @Override
    public Class<?> getNativeDataTypeClass() throws HopValueException {
        return InetAddress.class;
    }
}

