/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.row;

import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaBigNumber;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNumber;
import org.apache.hop.core.row.value.ValueMetaString;

public class RowMetaBuilder {
    private RowMeta rowMeta = new RowMeta();

    public RowMetaBuilder addString(String name) {
        return this.addString(name, -1);
    }

    public RowMetaBuilder addString(String name, int length) {
        this.rowMeta.addValueMeta(new ValueMetaString(name, length, -1));
        return this;
    }

    public RowMetaBuilder addInteger(String name) {
        return this.addInteger(name, -1);
    }

    public RowMetaBuilder addInteger(String name, int length) {
        this.rowMeta.addValueMeta(new ValueMetaInteger(name, length, -1));
        return this;
    }

    public RowMetaBuilder addNumber(String name) {
        return this.addNumber(name, -1, -1);
    }

    public RowMetaBuilder addNumber(String name, int length, int precision) {
        this.rowMeta.addValueMeta(new ValueMetaNumber(name, length, -1));
        return this;
    }

    public RowMetaBuilder addBigNumber(String name, int length, int precision) {
        this.rowMeta.addValueMeta(new ValueMetaBigNumber(name, length, -1));
        return this;
    }

    public RowMetaBuilder addDate(String name) {
        this.rowMeta.addValueMeta(new ValueMetaDate(name));
        return this;
    }

    public RowMetaBuilder addBoolean(String name) {
        this.rowMeta.addValueMeta(new ValueMetaBoolean(name));
        return this;
    }

    public RowMetaBuilder remove(int index) {
        this.rowMeta.removeValueMeta(index);
        return this;
    }

    public IRowMeta build() {
        return this.rowMeta;
    }
}

