/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.row;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import lombok.Generated;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopEofException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.ValueMetaDeserializer;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataObject;
import org.apache.hop.metadata.api.IEnumHasCode;
import org.apache.hop.metadata.api.IEnumHasCodeAndDescription;
import org.apache.hop.metadata.api.IHopMetadataObjectFactory;
import org.json.simple.JSONObject;
import org.w3c.dom.Node;

@JsonDeserialize(using=ValueMetaDeserializer.class)
@HopMetadataObject(objectFactory=ValueMetaHopMetadataObjectFactory.class)
public interface IValueMeta
extends Cloneable {
    public static final Class<?> PKG = Const.class;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_NUMBER = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_DATE = 3;
    public static final int TYPE_BOOLEAN = 4;
    public static final int TYPE_INTEGER = 5;
    public static final int TYPE_BIGNUMBER = 6;
    public static final int TYPE_SERIALIZABLE = 7;
    public static final int TYPE_BINARY = 8;
    public static final int TYPE_TIMESTAMP = 9;
    public static final int TYPE_INET = 10;
    public static final int TYPE_JSON = 11;
    public static final int TYPE_AVRO = 20;
    public static final String[] typeCodes = new String[]{"-", "Number", "String", "Date", "Boolean", "Integer", "BigNumber", "Serializable", "Binary", "Timestamp", "Internet Address", "Json"};
    public static final int STORAGE_TYPE_NORMAL = 0;
    public static final int STORAGE_TYPE_BINARY_STRING = 1;
    public static final int STORAGE_TYPE_INDEXED = 2;
    public static final String[] storageTypeCodes = new String[]{"normal", "binary-string", "indexed"};
    public static final int SORT_TYPE_NOT_SORTED = 0;
    public static final int SORT_TYPE_ASCENDING = 1;
    public static final int SORT_TYPE_DESCENDING = 2;
    public static final String[] sortTypeCodes = new String[]{"none", "ascending", "descending"};
    public static final int TRIM_TYPE_NONE = 0;
    public static final int TRIM_TYPE_LEFT = 1;
    public static final int TRIM_TYPE_RIGHT = 2;
    public static final int TRIM_TYPE_BOTH = 3;
    public static final int DEFAULT_INTEGER_LENGTH = 10;

    public static String getTypeDescription(int type) {
        try {
            return typeCodes[type];
        }
        catch (Exception e) {
            return "unknown/illegal";
        }
    }

    public String getName();

    public void setName(String var1);

    public int getLength();

    public void setLength(int var1);

    public int getPrecision();

    public void setPrecision(int var1);

    public void setLength(int var1, int var2);

    @JsonIgnore
    public String getOrigin();

    public void setOrigin(String var1);

    @JsonIgnore
    public String getComments();

    public void setComments(String var1);

    public int getType();

    public int getStorageType();

    public void setStorageType(int var1);

    public int getTrimType();

    public void setTrimType(int var1);

    public String getRoundingType();

    public void setRoundingType(String var1);

    public Object[] getIndex();

    public void setIndex(Object[] var1);

    public boolean isStorageNormal();

    public boolean isStorageIndexed();

    public boolean isStorageBinaryString();

    public String getConversionMask();

    public void setConversionMask(String var1);

    public String getFormatMask();

    public String getDecimalSymbol();

    public void setDecimalSymbol(String var1);

    public String getGroupingSymbol();

    public void setGroupingSymbol(String var1);

    public String getCurrencySymbol();

    public void setCurrencySymbol(String var1);

    public SimpleDateFormat getDateFormat();

    public DecimalFormat getDecimalFormat();

    public DecimalFormat getDecimalFormat(boolean var1);

    public String getStringEncoding();

    public void setStringEncoding(String var1);

    public boolean isSingleByteEncoding();

    public boolean isNull(Object var1) throws HopValueException;

    public boolean isCaseInsensitive();

    public void setCaseInsensitive(boolean var1);

    public boolean isCollatorDisabled();

    public void setCollatorDisabled(boolean var1);

    public Locale getCollatorLocale();

    public void setCollatorLocale(Locale var1);

    public int getCollatorStrength();

    public void setCollatorStrength(int var1) throws IllegalArgumentException;

    public boolean isSortedDescending();

    public void setSortedDescending(boolean var1);

    public boolean isOutputPaddingEnabled();

    public void setOutputPaddingEnabled(boolean var1);

    public boolean isLargeTextField();

    public void setLargeTextField(boolean var1);

    public boolean isDateFormatLenient();

    public void setDateFormatLenient(boolean var1);

    public Locale getDateFormatLocale();

    public void setDateFormatLocale(Locale var1);

    public TimeZone getDateFormatTimeZone();

    public void setDateFormatTimeZone(TimeZone var1);

    public int getOriginalColumnType();

    public void setOriginalColumnType(int var1);

    public String getOriginalColumnTypeName();

    public void setOriginalColumnTypeName(String var1);

    public int getOriginalPrecision();

    public void setOriginalPrecision(int var1);

    public int getOriginalScale();

    public int getOriginalNullable();

    public boolean getOriginalSigned();

    public void setOriginalScale(int var1);

    public boolean isOriginalAutoIncrement();

    public void setOriginalAutoIncrement(boolean var1);

    public int isOriginalNullable();

    public void setOriginalNullable(int var1);

    public boolean isOriginalSigned();

    public void setOriginalSigned(boolean var1);

    public Object cloneValueData(Object var1) throws HopValueException;

    public String getCompatibleString(Object var1) throws HopValueException;

    public String getString(Object var1) throws HopValueException;

    public byte[] getBinaryString(Object var1) throws HopValueException;

    public Double getNumber(Object var1) throws HopValueException;

    public BigDecimal getBigNumber(Object var1) throws HopValueException;

    public Long getInteger(Object var1) throws HopValueException;

    public Date getDate(Object var1) throws HopValueException;

    public Boolean getBoolean(Object var1) throws HopValueException;

    public JsonNode getJson(Object var1) throws HopValueException;

    public byte[] getBinary(Object var1) throws HopValueException;

    public IValueMeta clone();

    public boolean isString();

    public boolean isDate();

    public boolean isBigNumber();

    public boolean isNumber();

    public boolean isBoolean();

    public boolean isSerializableType();

    public boolean isBinary();

    public boolean isInteger();

    public boolean isNumeric();

    public String getTypeDesc();

    public String toStringMeta();

    public void writeMeta(DataOutputStream var1) throws HopFileException;

    public void writeData(DataOutputStream var1, Object var2) throws HopFileException;

    public Object readData(DataInputStream var1) throws HopFileException, HopEofException, SocketTimeoutException;

    public void readMetaData(DataInputStream var1) throws HopFileException, HopEofException;

    public int compare(Object var1, Object var2) throws HopValueException;

    public int compare(Object var1, IValueMeta var2, Object var3) throws HopValueException;

    public Object convertData(IValueMeta var1, Object var2) throws HopValueException;

    public Object convertDataCompatible(IValueMeta var1, Object var2) throws HopValueException;

    public Object convertDataUsingConversionMetaData(Object var1) throws HopValueException;

    public Object convertDataFromString(String var1, IValueMeta var2, String var3, String var4, int var5) throws HopValueException;

    public Object convertToNormalStorageType(Object var1) throws HopValueException;

    public Object convertBinaryStringToNativeType(byte[] var1) throws HopValueException;

    public Object convertNormalStorageTypeToBinaryString(Object var1) throws HopValueException;

    public Object convertToBinaryStringStorageType(Object var1) throws HopValueException;

    public int hashCode(Object var1) throws HopValueException;

    public IValueMeta getStorageMetadata();

    public void setStorageMetadata(IValueMeta var1);

    public IValueMeta getConversionMetadata();

    public void setConversionMetadata(IValueMeta var1);

    public String getMetaXml() throws IOException;

    public String getDataXml(Object var1) throws IOException;

    public Object getValue(Node var1) throws HopException;

    public long getNumberOfBinaryStringConversions();

    public void setNumberOfBinaryStringConversions(long var1);

    public boolean requiresRealClone();

    public boolean isLenientStringToNumber();

    public void setLenientStringToNumber(boolean var1);

    public IValueMeta getValueFromSqlType(IVariables var1, DatabaseMeta var2, String var3, ResultSetMetaData var4, int var5, boolean var6, boolean var7) throws HopDatabaseException;

    public IValueMeta getMetadataPreview(IVariables var1, DatabaseMeta var2, ResultSet var3) throws HopDatabaseException;

    public Object getValueFromResultSet(IDatabase var1, ResultSet var2, int var3) throws HopDatabaseException;

    public void setPreparedStatementValue(DatabaseMeta var1, PreparedStatement var2, int var3, Object var4) throws HopDatabaseException;

    public Object getNativeDataType(Object var1) throws HopValueException;

    public Class<?> getNativeDataTypeClass() throws HopValueException;

    public String getDatabaseColumnTypeDefinition(IDatabase var1, String var2, String var3, boolean var4, boolean var5, boolean var6);

    public boolean isIgnoreWhitespace();

    public void setIgnoreWhitespace(boolean var1);

    public void storeMetaInJson(JSONObject var1) throws HopException;

    public void loadMetaFromJson(JSONObject var1);

    public static class ValueMetaHopMetadataObjectFactory
    implements IHopMetadataObjectFactory {
        @Override
        public Object createObject(String id, Object parentObject) throws HopException {
            int type = ValueMetaFactory.getIdForValueMeta(id);
            return ValueMetaFactory.getValueMetaName(type);
        }

        @Override
        public String getObjectId(Object object) throws HopException {
            return ((IValueMeta)object).getTypeDesc();
        }
    }

    public static enum TrimType implements IEnumHasCodeAndDescription
    {
        NONE("none", BaseMessages.getString(PKG, "ValueMeta.TrimType.None", new String[0]), 0),
        LEFT("left", BaseMessages.getString(PKG, "ValueMeta.TrimType.Left", new String[0]), 1),
        RIGHT("right", BaseMessages.getString(PKG, "ValueMeta.TrimType.Right", new String[0]), 2),
        BOTH("both", BaseMessages.getString(PKG, "ValueMeta.TrimType.Both", new String[0]), 3);

        private final String code;
        private final String description;
        private final int type;
        public static final String[] roundingTypeCode;

        private TrimType(String code, String description, int type) {
            this.code = code;
            this.description = description;
            this.type = type;
        }

        public static String[] getDescriptions() {
            return IEnumHasCodeAndDescription.getDescriptions(TrimType.class);
        }

        public static TrimType lookupDescription(String description) {
            return IEnumHasCodeAndDescription.lookupDescription(TrimType.class, description, NONE);
        }

        public static TrimType lookupCode(String code) {
            return IEnumHasCode.lookupCode(TrimType.class, code, NONE);
        }

        public static TrimType lookupType(int type) {
            for (TrimType value : TrimType.values()) {
                if (value.type != type) continue;
                return value;
            }
            return NONE;
        }

        @Override
        @Generated
        public String getCode() {
            return this.code;
        }

        @Override
        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public int getType() {
            return this.type;
        }

        @Generated
        public static String[] getRoundingTypeCode() {
            return roundingTypeCode;
        }

        static {
            roundingTypeCode = new String[]{"unnecessary", "ceiling", "down", "floor", "half_down", "half_even", "half_up", "up"};
        }
    }
}

