/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.logging;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.logging.ILogMessage;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingRegistry;
import org.apache.hop.core.util.StringUtil;

public class LogMessage
implements ILogMessage {
    private String logChannelId;
    private String message;
    private String subject;
    private Object[] arguments;
    private LogLevel level;
    private String copy;
    private boolean simplified;

    public LogMessage(String subject, LogLevel level) {
        this.subject = subject;
        this.level = level;
        this.message = null;
        this.logChannelId = null;
    }

    public LogMessage(String message, String logChannelId, LogLevel level) {
        this(message, logChannelId, null, level, false);
    }

    public LogMessage(String message, String logChannelId, LogLevel level, boolean simplified) {
        this(message, logChannelId, null, level, simplified);
    }

    public LogMessage(String message, String logChannelId, Object[] arguments, LogLevel level) {
        this(message, logChannelId, arguments, level, false);
    }

    public LogMessage(String message, String logChannelId, Object[] arguments, LogLevel level, boolean simplified) {
        this.message = message;
        this.logChannelId = logChannelId;
        this.arguments = arguments;
        this.level = level;
        this.simplified = simplified;
        this.lookupSubject();
    }

    private void lookupSubject() {
        boolean detailedLogTurnOn;
        ILoggingObject loggingObject = LoggingRegistry.getInstance().getLoggingObject(this.logChannelId);
        boolean bl = detailedLogTurnOn = "Y".equals(HopConfig.readStringVariable("HOP_LOG_MARK_MAPPINGS", "N"));
        if (loggingObject != null) {
            this.subject = !detailedLogTurnOn ? loggingObject.getObjectName() : this.getDetailedSubject(loggingObject);
            this.copy = loggingObject.getObjectCopy();
        }
    }

    private String getDetailedSubject(ILoggingObject loggingObject) {
        List<String> subjects = this.getSubjectTree(loggingObject);
        return subjects.size() > 1 ? this.formatDetailedSubject(subjects) : subjects.get(0);
    }

    private List<String> getSubjectTree(ILoggingObject loggingObject) {
        ArrayList<String> subjects = new ArrayList<String>();
        while (loggingObject != null) {
            subjects.add(loggingObject.getObjectName());
            loggingObject = loggingObject.getParent();
        }
        return subjects;
    }

    private String formatDetailedSubject(List<String> subjects) {
        StringBuilder string = new StringBuilder();
        int currentTransform = 0;
        int rootTransform = subjects.size() - 1;
        for (int i = rootTransform - 1; i > currentTransform; --i) {
            string.append("[").append(subjects.get(i)).append("]").append(".");
        }
        string.append(subjects.get(currentTransform));
        return string.toString();
    }

    public String toString() {
        if (this.simplified) {
            return this.getMessage();
        }
        if (StringUtils.isBlank((String)this.message)) {
            return this.subject;
        }
        if (StringUtils.isBlank((String)this.subject)) {
            return this.getMessage();
        }
        return String.format("%s - %s", this.subject, this.getMessage());
    }

    @Override
    public LogLevel getLevel() {
        return this.level;
    }

    @Override
    public String getMessage() {
        String formatted = this.message;
        if (this.arguments != null) {
            ArrayList<String> tokens = new ArrayList<String>();
            StringUtil.getUsedVariables(formatted, "{", "}", tokens, true);
            for (String token : tokens) {
                try {
                    MessageFormat.format("{" + token + "}", this.arguments);
                }
                catch (IllegalArgumentException iar) {
                    formatted = formatted.replaceAll("\\{" + token + "\\}", "\\'{'" + token + "\\'}'");
                }
            }
            formatted = MessageFormat.format(formatted, this.arguments);
        }
        return formatted;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getLogChannelId() {
        return this.logChannelId;
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    public boolean isError() {
        return this.level.isError();
    }

    @Override
    public String getCopy() {
        return this.copy;
    }

    @Override
    public boolean isSimplified() {
        return this.simplified;
    }

    public void setSimplified(boolean simplified) {
        this.simplified = simplified;
    }
}

