/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.gui.plugin.toolbar;

import java.lang.reflect.Method;
import java.util.Objects;
import lombok.Generated;
import org.apache.hop.core.gui.plugin.BaseGuiElements;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElementType;

public class GuiToolbarItem
extends BaseGuiElements
implements Comparable<GuiToolbarItem> {
    private String root;
    private String id;
    private String label;
    private String toolTip;
    private GuiToolbarElementType type;
    private String image;
    private String imageMethod;
    private boolean password;
    private String getComboValuesMethod;
    private boolean ignored;
    private boolean addingSeparator;
    private ClassLoader classLoader;
    private boolean singleTon;
    private String listenerClass;
    private String listenerMethod;
    private int extraWidth;
    private boolean alignRight;
    private boolean readOnly;

    public GuiToolbarItem() {
    }

    public GuiToolbarItem(GuiToolbarElement toolbarElement, String listenerClass, Method method, ClassLoader classLoader) {
        this();
        this.root = toolbarElement.root();
        this.id = toolbarElement.id();
        this.type = toolbarElement.type();
        this.getComboValuesMethod = toolbarElement.comboValuesMethod();
        this.image = toolbarElement.image();
        this.imageMethod = toolbarElement.imageMethod();
        this.password = toolbarElement.password();
        this.ignored = toolbarElement.ignored();
        this.addingSeparator = toolbarElement.separator();
        this.singleTon = true;
        this.listenerClass = listenerClass;
        this.listenerMethod = method.getName();
        this.label = this.getTranslation(toolbarElement.label(), method.getDeclaringClass().getPackage().getName(), method.getDeclaringClass());
        this.toolTip = this.getTranslation(toolbarElement.toolTip(), method.getDeclaringClass().getPackage().getName(), method.getDeclaringClass());
        this.classLoader = classLoader;
        this.extraWidth = toolbarElement.extraWidth();
        this.alignRight = toolbarElement.alignRight();
        this.readOnly = toolbarElement.readOnly();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuiToolbarItem that = (GuiToolbarItem)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "GuiToolbarItem{id='" + this.id + "'}";
    }

    @Override
    public int compareTo(GuiToolbarItem o) {
        return this.id.compareTo(o.id);
    }

    @Generated
    public String getRoot() {
        return this.root;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public String getToolTip() {
        return this.toolTip;
    }

    @Generated
    public GuiToolbarElementType getType() {
        return this.type;
    }

    @Generated
    public String getImage() {
        return this.image;
    }

    @Generated
    public String getImageMethod() {
        return this.imageMethod;
    }

    @Generated
    public boolean isPassword() {
        return this.password;
    }

    @Generated
    public String getGetComboValuesMethod() {
        return this.getComboValuesMethod;
    }

    @Generated
    public boolean isIgnored() {
        return this.ignored;
    }

    @Generated
    public boolean isAddingSeparator() {
        return this.addingSeparator;
    }

    @Generated
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Generated
    public boolean isSingleTon() {
        return this.singleTon;
    }

    @Generated
    public String getListenerClass() {
        return this.listenerClass;
    }

    @Generated
    public String getListenerMethod() {
        return this.listenerMethod;
    }

    @Generated
    public int getExtraWidth() {
        return this.extraWidth;
    }

    @Generated
    public boolean isAlignRight() {
        return this.alignRight;
    }

    @Generated
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Generated
    public void setRoot(String root) {
        this.root = root;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    @Generated
    public void setType(GuiToolbarElementType type) {
        this.type = type;
    }

    @Generated
    public void setImage(String image) {
        this.image = image;
    }

    @Generated
    public void setImageMethod(String imageMethod) {
        this.imageMethod = imageMethod;
    }

    @Generated
    public void setPassword(boolean password) {
        this.password = password;
    }

    @Generated
    public void setGetComboValuesMethod(String getComboValuesMethod) {
        this.getComboValuesMethod = getComboValuesMethod;
    }

    @Generated
    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    @Generated
    public void setAddingSeparator(boolean addingSeparator) {
        this.addingSeparator = addingSeparator;
    }

    @Generated
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Generated
    public void setSingleTon(boolean singleTon) {
        this.singleTon = singleTon;
    }

    @Generated
    public void setListenerClass(String listenerClass) {
        this.listenerClass = listenerClass;
    }

    @Generated
    public void setListenerMethod(String listenerMethod) {
        this.listenerMethod = listenerMethod;
    }

    @Generated
    public void setExtraWidth(int extraWidth) {
        this.extraWidth = extraWidth;
    }

    @Generated
    public void setAlignRight(boolean alignRight) {
        this.alignRight = alignRight;
    }

    @Generated
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

