/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.ImageVisitor;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.TextWriterImageVisitor;

@InterfaceAudience.Private
public class NameDistributionVisitor
extends TextWriterImageVisitor {
    HashMap<String, Integer> counts = new HashMap();

    public NameDistributionVisitor(String filename, boolean printToScreen) throws IOException {
        super(filename, printToScreen);
    }

    @Override
    void finish() throws IOException {
        int BYTEARRAY_OVERHEAD = 24;
        this.write("Total unique file names " + this.counts.size());
        long[][] stats = new long[][]{{100000L, 0L, 0L, 0L}, {10000L, 0L, 0L, 0L}, {1000L, 0L, 0L, 0L}, {100L, 0L, 0L, 0L}, {10L, 0L, 0L, 0L}, {5L, 0L, 0L, 0L}, {4L, 0L, 0L, 0L}, {3L, 0L, 0L, 0L}, {2L, 0L, 0L, 0L}};
        int highbound = Integer.MIN_VALUE;
        block0: for (Map.Entry<String, Integer> entry : this.counts.entrySet()) {
            highbound = Math.max(highbound, entry.getValue());
            for (int i = 0; i < stats.length; ++i) {
                if ((long)entry.getValue().intValue() < stats[i][0]) continue;
                long[] lArray = stats[i];
                lArray[1] = lArray[1] + (long)((24 + entry.getKey().length()) * (entry.getValue() - 1));
                long[] lArray2 = stats[i];
                lArray2[2] = lArray2[2] + (long)entry.getValue().intValue();
                long[] lArray3 = stats[i];
                lArray3[3] = lArray3[3] + 1L;
                continue block0;
            }
        }
        long lowbound = 0L;
        long totalsavings = 0L;
        for (long[] stat : stats) {
            lowbound = stat[0];
            totalsavings += stat[1];
            String range = lowbound == (long)highbound ? " " + lowbound : " between " + lowbound + "-" + highbound;
            this.write("\n" + stat[3] + " names are used by " + stat[2] + " files" + range + " times. Heap savings ~" + stat[1] + " bytes.");
            highbound = (int)stat[0] - 1;
        }
        this.write("\n\nTotal saved heap ~" + totalsavings + "bytes.\n");
        super.finish();
    }

    @Override
    void visit(ImageVisitor.ImageElement element, String value) throws IOException {
        if (element == ImageVisitor.ImageElement.INODE_PATH) {
            String filename = value.substring(value.lastIndexOf("/") + 1);
            if (this.counts.containsKey(filename)) {
                this.counts.put(filename, this.counts.get(filename) + 1);
            } else {
                this.counts.put(filename, 1);
            }
        }
    }

    @Override
    void leaveEnclosingElement() throws IOException {
    }

    @Override
    void start() throws IOException {
    }

    @Override
    void visitEnclosingElement(ImageVisitor.ImageElement element) throws IOException {
    }

    @Override
    void visitEnclosingElement(ImageVisitor.ImageElement element, ImageVisitor.ImageElement key, String value) throws IOException {
    }
}

