/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats;

import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.data_formats.internal.AbstractBinaryFormatReader;
import com.clickhouse.client.api.data_formats.internal.BinaryStreamReader;
import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.client.api.query.QuerySettings;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class RowBinaryWithNamesAndTypesFormatReader
extends AbstractBinaryFormatReader
implements Iterator<Map<String, Object>> {
    public RowBinaryWithNamesAndTypesFormatReader(InputStream inputStream, QuerySettings querySettings, BinaryStreamReader.ByteBufferAllocator byteBufferAllocator) {
        super(inputStream, querySettings, null, byteBufferAllocator);
        this.readSchema();
    }

    private void readSchema() {
        try {
            int i;
            int nCol;
            TableSchema headerSchema = new TableSchema();
            ArrayList<String> columns = new ArrayList<String>();
            try {
                nCol = BinaryStreamReader.readVarInt(this.input);
            }
            catch (EOFException e) {
                this.endReached();
                return;
            }
            for (i = 0; i < nCol; ++i) {
                columns.add(BinaryStreamReader.readString(this.input));
            }
            for (i = 0; i < nCol; ++i) {
                headerSchema.addColumn((String)columns.get(i), BinaryStreamReader.readString(this.input));
            }
            this.setSchema(headerSchema);
        }
        catch (IOException e) {
            throw new ClientException("Failed to read header", e);
        }
    }
}

