/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400Text;

public class ValidationListTranslatedData {
    private byte[] bytes_ = null;
    private int ccsid_ = 0;

    public ValidationListTranslatedData() {
    }

    public ValidationListTranslatedData(byte[] buffer, int offset) {
        this();
        int dataLength = new AS400Bin4().toInt(buffer, offset + this.getReadOffsetTByteLength());
        this.setCcsid(new AS400Bin4().toInt(buffer, offset + this.getReadOffsetCcsid()));
        this.setBytes((byte[])new AS400ByteArray(dataLength).toObject(buffer, offset + this.getReadOffsetTBytes()));
    }

    public ValidationListTranslatedData(int ccsid, byte[] bytes) {
        this();
        this.setCcsid(ccsid);
        this.setBytes(bytes);
    }

    public ValidationListTranslatedData(String s, int ccsid, AS400 as400) {
        this();
        this.setBytes(s, ccsid, as400);
    }

    public int getByteLength() {
        int total = this.getWriteOffsetTBytes();
        if (this.getBytes() != null) {
            total += this.getBytes().length;
        }
        return total;
    }

    public byte[] getBytes() {
        return this.bytes_;
    }

    public int getCcsid() {
        return this.ccsid_;
    }

    protected int getReadOffsetCcsid() {
        return 4;
    }

    protected int getReadOffsetTByteLength() {
        return 0;
    }

    protected int getReadOffsetTBytes() {
        return 8;
    }

    public String getString(AS400 as400) {
        int ccsid = this.getCcsid();
        if (this.bytes_ == null || ccsid == -1) {
            return null;
        }
        if (ccsid == 13488) {
            return new String(this.bytes_);
        }
        if (ccsid == 0) {
            ccsid = as400.getCcsid();
        }
        return (String)new AS400Text(this.bytes_.length, ccsid, as400).toObject(this.bytes_);
    }

    protected int getWriteNullDataLength() {
        return 0;
    }

    protected int getWriteOffsetCcsid() {
        return this.getReadOffsetCcsid();
    }

    protected int getWriteOffsetTByteLength() {
        return this.getReadOffsetTByteLength();
    }

    protected int getWriteOffsetTBytes() {
        return this.getReadOffsetTBytes();
    }

    protected boolean isValidCcsid(int ccsid) {
        boolean isValid = false;
        switch (ccsid) {
            case 37: 
            case 256: 
            case 273: 
            case 277: 
            case 278: 
            case 280: 
            case 284: 
            case 285: 
            case 290: 
            case 297: 
            case 300: 
            case 420: 
            case 423: 
            case 424: 
            case 500: 
            case 833: 
            case 834: 
            case 835: 
            case 836: 
            case 837: 
            case 838: 
            case 870: 
            case 871: 
            case 875: 
            case 880: 
            case 905: 
            case 918: 
            case 924: 
            case 930: 
            case 933: 
            case 935: 
            case 937: 
            case 939: 
            case 1025: 
            case 1026: 
            case 1027: 
            case 1097: 
            case 1112: 
            case 1122: 
            case 1123: 
            case 1130: 
            case 1132: 
            case 1140: 
            case 1141: 
            case 1142: 
            case 1143: 
            case 1144: 
            case 1145: 
            case 1146: 
            case 1147: 
            case 1148: 
            case 1149: 
            case 1364: 
            case 1388: 
            case 4396: 
            case 4930: 
            case 4933: 
            case 5026: 
            case 5035: 
            case 8612: 
            case 8616: 
            case 9030: 
            case 12708: 
            case 13121: 
            case 13124: 
            case 13488: 
            case 28709: 
            case 62211: 
            case 62224: 
            case 62235: {
                isValid = true;
            }
        }
        return isValid;
    }

    public void setBytes(byte[] bytes) {
        this.bytes_ = bytes;
    }

    public void setBytes(String s, int ccsid, AS400 as400) {
        int len;
        if (ccsid == 0) {
            ccsid = as400.getCcsid();
        }
        this.setCcsid(ccsid);
        if (ccsid == 13488) {
            this.setBytes(s.getBytes());
            return;
        }
        byte[] buffer = new AS400Text(len, ccsid, as400).toBytes(s);
        for (len = s.length() * 2; len > 0 && buffer[len - 1] == 64; --len) {
        }
        byte[] trimmed = new byte[len];
        System.arraycopy(buffer, 0, trimmed, 0, len);
        this.setBytes(trimmed);
    }

    public void setCcsid(int ccsid) {
        this.ccsid_ = ccsid <= 0 || this.isValidCcsid(ccsid) ? ccsid : 37;
    }

    public byte[] toBytes() {
        byte[] buffer = new byte[this.getByteLength()];
        this.toBytes(buffer, 0);
        return buffer;
    }

    public int toBytes(byte[] buffer, int offset) {
        byte[] bytes = this.getBytes();
        int byteLength = bytes == null ? this.getWriteNullDataLength() : bytes.length;
        new AS400Bin4().toBytes(byteLength, buffer, offset + this.getWriteOffsetTByteLength());
        new AS400Bin4().toBytes(this.getCcsid(), buffer, offset + this.getWriteOffsetCcsid());
        if (byteLength > 0) {
            System.arraycopy(bytes, 0, buffer, offset + this.getWriteOffsetTBytes(), byteLength);
        }
        return this.getByteLength();
    }
}

