/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AbstractProxyImpl;
import com.ibm.as400.access.JDBlobProxy;
import com.ibm.as400.access.JDClobProxy;
import com.ibm.as400.access.JDConnectionProxy;
import com.ibm.as400.access.JDInputStreamProxy;
import com.ibm.as400.access.JDNClobProxy;
import com.ibm.as400.access.JDReaderProxy;
import com.ibm.as400.access.JDResultSetMetaDataProxy;
import com.ibm.as400.access.JDRowIdProxy;
import com.ibm.as400.access.JDSQLXMLProxy;
import com.ibm.as400.access.JDStatementProxy;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.ProxyClientConnection;
import com.ibm.as400.access.ProxyReturnValue;
import com.ibm.as400.access.SerializableInputStream;
import com.ibm.as400.access.SerializableReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

class JDResultSetProxy
extends AbstractProxyImpl
implements ResultSet {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private JDConnectionProxy jdConnection_;
    private JDStatementProxy cachedStatement_;
    private static final String NOT_SERIALIZABLE = "Parameter is not serializable.";

    public JDResultSetProxy(JDConnectionProxy jdConnection) {
        this.jdConnection_ = jdConnection;
    }

    public JDResultSetProxy(JDConnectionProxy jdConnection, JDStatementProxy statement) {
        this.jdConnection_ = jdConnection;
        this.cachedStatement_ = statement;
    }

    private void callMethod(String methodName) throws SQLException {
        try {
            this.connection_.callMethod(this.pxId_, methodName);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    private void callMethod(String methodName, Class[] argClasses, Object[] argValues) throws SQLException {
        try {
            this.connection_.callMethod(this.pxId_, methodName, argClasses, argValues);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    private boolean callMethodRtnBool(String methodName) throws SQLException {
        try {
            return this.connection_.callMethodReturnsBoolean(this.pxId_, methodName);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    private JDInputStreamProxy callMethodRtnInpStrm(String methodName, int argValue) throws SQLException {
        try {
            JDInputStreamProxy newStream = new JDInputStreamProxy();
            return (JDInputStreamProxy)this.connection_.callFactoryMethod(this.pxId_, methodName, new Class[]{Integer.TYPE}, new Object[]{argValue}, newStream);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    private int callMethodRtnInt(String methodName) throws SQLException {
        try {
            return this.connection_.callMethodReturnsInt(this.pxId_, methodName);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    private Object callMethodRtnObj(String methodName) throws SQLException {
        try {
            return this.connection_.callMethodReturnsObject(this.pxId_, methodName);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    private Object callMethodRtnObj(String methodName, Class[] argClasses, Object[] argValues) throws SQLException {
        try {
            return this.connection_.callMethod(this.pxId_, methodName, argClasses, argValues).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    private ProxyReturnValue callMethodRtnRaw(String methodName, Class[] argClasses, Object[] argValues) throws SQLException {
        try {
            return this.connection_.callMethod(this.pxId_, methodName, argClasses, argValues);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.callMethod("clearWarnings");
    }

    @Override
    public void close() throws SQLException {
        this.callMethod("close");
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return this.callMethodRtnRaw("findColumn", new Class[]{String.class}, new Object[]{columnName}).getReturnValueInt();
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.callMethodRtnInt("getConcurrency");
    }

    @Override
    public String getCursorName() throws SQLException {
        return (String)this.callMethodRtnObj("getCursorName");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.callMethodRtnInt("getFetchDirection");
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.callMethodRtnInt("getFetchSize");
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.cachedStatement_ == null) {
            try {
                JDStatementProxy newStatement = new JDStatementProxy(this.jdConnection_);
                this.cachedStatement_ = (JDStatementProxy)this.connection_.callFactoryMethod(this.pxId_, "getStatement", newStatement);
            }
            catch (InvocationTargetException e) {
                throw JDConnectionProxy.rethrow1(e);
            }
        }
        return this.cachedStatement_;
    }

    @Override
    public int getType() throws SQLException {
        return this.callMethodRtnInt("getType");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return (SQLWarning)this.callMethodRtnObj("getWarnings");
    }

    @Override
    public void setFetchDirection(int fetchDirection) throws SQLException {
        this.callMethod("setFetchDirection", new Class[]{Integer.TYPE}, new Object[]{fetchDirection});
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.callMethod("setFetchSize", new Class[]{Integer.TYPE}, new Object[]{fetchSize});
    }

    public String toString() {
        try {
            return (String)this.connection_.callMethodReturnsObject(this.pxId_, "toString");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public boolean absolute(int rowNumber) throws SQLException {
        return this.callMethodRtnRaw("absolute", new Class[]{Integer.TYPE}, new Object[]{rowNumber}).getReturnValueBoolean();
    }

    @Override
    public void afterLast() throws SQLException {
        this.callMethod("afterLast");
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.callMethod("beforeFirst");
    }

    @Override
    public boolean first() throws SQLException {
        return this.callMethodRtnBool("first");
    }

    @Override
    public int getRow() throws SQLException {
        return this.callMethodRtnInt("getRow");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.callMethodRtnBool("isAfterLast");
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.callMethodRtnBool("isBeforeFirst");
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.callMethodRtnBool("isFirst");
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.callMethodRtnBool("isLast");
    }

    @Override
    public boolean last() throws SQLException {
        return this.callMethodRtnBool("last");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.callMethod("moveToCurrentRow");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.callMethod("moveToInsertRow");
    }

    @Override
    public boolean next() throws SQLException {
        return this.callMethodRtnBool("next");
    }

    @Override
    public boolean previous() throws SQLException {
        return this.callMethodRtnBool("previous");
    }

    @Override
    public void refreshRow() throws SQLException {
        this.callMethod("refreshRow");
    }

    @Override
    public boolean relative(int rowNumber) throws SQLException {
        return this.callMethodRtnRaw("relative", new Class[]{Integer.TYPE}, new Object[]{rowNumber}).getReturnValueBoolean();
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return (Array)this.callMethodRtnObj("getArray", new Class[]{Integer.TYPE}, new Object[]{columnIndex});
    }

    @Override
    public Array getArray(String columnName) throws SQLException {
        return this.getArray(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.callMethodRtnInpStrm("getAsciiStream", columnIndex);
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return (BigDecimal)this.callMethodRtnObj("getBigDecimal", new Class[]{Integer.TYPE}, new Object[]{columnIndex});
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return (BigDecimal)this.callMethodRtnObj("getBigDecimal", new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{columnIndex, scale});
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.callMethodRtnInpStrm("getBinaryStream", columnIndex);
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        try {
            JDBlobProxy newBlob = new JDBlobProxy();
            return (JDBlobProxy)this.connection_.callFactoryMethod(this.pxId_, "getBlob", new Class[]{Integer.TYPE}, new Object[]{columnIndex}, newBlob);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        return this.getBlob(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.callMethodRtnRaw("getBoolean", new Class[]{Integer.TYPE}, new Object[]{columnIndex}).getReturnValueBoolean();
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.callMethodRtnRaw("getByte", new Class[]{Integer.TYPE}, new Object[]{columnIndex}).getReturnValueByte();
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return (byte[])this.callMethodRtnObj("getBytes", new Class[]{Integer.TYPE}, new Object[]{columnIndex});
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        try {
            JDReaderProxy newReader = new JDReaderProxy();
            return (JDReaderProxy)this.connection_.callFactoryMethod(this.pxId_, "getCharacterStream", new Class[]{Integer.TYPE}, new Object[]{columnIndex}, newReader);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        try {
            JDClobProxy newClob = new JDClobProxy();
            return (JDClobProxy)this.connection_.callFactoryMethod(this.pxId_, "getClob", new Class[]{Integer.TYPE}, new Object[]{columnIndex}, newClob);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return (Date)this.callMethodRtnObj("getDate", new Class[]{Integer.TYPE}, new Object[]{columnIndex});
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return (Date)this.callMethodRtnObj("getDate", new Class[]{String.class}, new Object[]{columnName});
    }

    @Override
    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        return (Date)this.callMethodRtnObj("getDate", new Class[]{Integer.TYPE, Calendar.class}, new Object[]{columnIndex, calendar});
    }

    @Override
    public Date getDate(String columnName, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(columnName), calendar);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.callMethodRtnRaw("getDouble", new Class[]{Integer.TYPE}, new Object[]{columnIndex}).getReturnValueDouble();
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.callMethodRtnRaw("getFloat", new Class[]{Integer.TYPE}, new Object[]{columnIndex}).getReturnValueFloat();
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.callMethodRtnRaw("getInt", new Class[]{Integer.TYPE}, new Object[]{columnIndex}).getReturnValueInt();
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.callMethodRtnRaw("getLong", new Class[]{Integer.TYPE}, new Object[]{columnIndex}).getReturnValueLong();
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            JDResultSetMetaDataProxy newMetaData = new JDResultSetMetaDataProxy(this.jdConnection_);
            return (JDResultSetMetaDataProxy)this.connection_.callFactoryMethod(this.pxId_, "getMetaData", newMetaData);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        String typeName = this.getMetaData().getColumnTypeName(columnIndex);
        AbstractProxyImpl proxyObject = null;
        try {
            if (typeName.equalsIgnoreCase("BLOB")) {
                proxyObject = new JDBlobProxy();
            } else if (typeName.equalsIgnoreCase("CLOB")) {
                proxyObject = new JDClobProxy();
            } else {
                return this.callMethodRtnObj("getObject", new Class[]{Integer.TYPE}, new Object[]{columnIndex});
            }
            return this.connection_.callFactoryMethod(this.pxId_, "getObject", new Class[]{Integer.TYPE}, new Object[]{columnIndex}, proxyObject);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public Object getObject(int columnIndex, Map typeMap) throws SQLException {
        String typeName = this.getMetaData().getColumnTypeName(columnIndex);
        AbstractProxyImpl proxyObject = null;
        try {
            if (typeName.equalsIgnoreCase("BLOB")) {
                proxyObject = new JDBlobProxy();
            } else if (typeName.equalsIgnoreCase("CLOB")) {
                proxyObject = new JDClobProxy();
            } else {
                return this.callMethodRtnObj("getObject", new Class[]{Integer.TYPE, Map.class}, new Object[]{columnIndex, typeMap});
            }
            return this.connection_.callFactoryMethod(this.pxId_, "getObject", new Class[]{Integer.TYPE, Map.class}, new Object[]{columnIndex, typeMap}, proxyObject);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    public Object getObject(String columnName, Map typeMap) throws SQLException {
        return this.getObject(this.findColumn(columnName), typeMap);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return (Ref)this.callMethodRtnObj("getRef", new Class[]{Integer.TYPE}, new Object[]{columnIndex});
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        return this.getRef(this.findColumn(columnName));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.callMethodRtnRaw("getShort", new Class[]{Integer.TYPE}, new Object[]{columnIndex}).getReturnValueShort();
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return (String)this.callMethodRtnObj("getString", new Class[]{Integer.TYPE}, new Object[]{columnIndex});
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return (Time)this.callMethodRtnObj("getTime", new Class[]{Integer.TYPE}, new Object[]{columnIndex});
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        return (Time)this.callMethodRtnObj("getTime", new Class[]{Integer.TYPE, Calendar.class}, new Object[]{columnIndex, calendar});
    }

    @Override
    public Time getTime(String columnName, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(columnName), calendar);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)this.callMethodRtnObj("getTimestamp", new Class[]{Integer.TYPE}, new Object[]{columnIndex});
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        return (Timestamp)this.callMethodRtnObj("getTimestamp", new Class[]{Integer.TYPE, Calendar.class}, new Object[]{columnIndex, calendar});
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), calendar);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.callMethodRtnInpStrm("getUnicodeStream", columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return (URL)this.callMethodRtnObj("getURL", new Class[]{Integer.TYPE}, new Object[]{columnIndex});
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return (URL)this.callMethodRtnObj("getURL", new Class[]{String.class}, new Object[]{columnName});
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.callMethodRtnBool("wasNull");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.callMethod("cancelRowUpdates");
    }

    @Override
    public void deleteRow() throws SQLException {
        this.callMethod("deleteRow");
    }

    @Override
    public void insertRow() throws SQLException {
        this.callMethod("insertRow");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.callMethodRtnBool("rowDeleted");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.callMethodRtnBool("rowInserted");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.callMethodRtnBool("rowUpdated");
    }

    @Override
    public void updateArray(int columnIndex, Array columnValue) throws SQLException {
        if (columnValue != null && !(columnValue instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("updateArray", new Class[]{Integer.TYPE, Array.class}, new Object[]{columnIndex, columnValue});
    }

    @Override
    public void updateArray(String columnName, Array columnValue) throws SQLException {
        if (columnValue != null && !(columnValue instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("updateArray", new Class[]{String.class, Array.class}, new Object[]{columnName, columnValue});
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream columnValue, int length) throws SQLException {
        InputStream iStream;
        if (columnValue == null || columnValue instanceof Serializable) {
            iStream = columnValue;
        } else {
            try {
                iStream = new SerializableInputStream(columnValue);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        this.callMethod("updateAsciiStream", new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE}, new Object[]{columnIndex, iStream, length});
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream columnValue, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), columnValue, length);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal columnValue) throws SQLException {
        this.callMethod("updateBigDecimal", new Class[]{Integer.TYPE, BigDecimal.class}, new Object[]{columnIndex, columnValue});
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal columnValue) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream columnValue, int length) throws SQLException {
        InputStream iStream;
        if (columnValue == null || columnValue instanceof Serializable) {
            iStream = columnValue;
        } else {
            try {
                iStream = new SerializableInputStream(columnValue);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        this.callMethod("updateBinaryStream", new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE}, new Object[]{columnIndex, iStream, length});
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream columnValue, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), columnValue, length);
    }

    @Override
    public void updateBlob(int columnIndex, Blob columnValue) throws SQLException {
        this.callMethod("updateBlob", new Class[]{Integer.TYPE, Blob.class}, new Object[]{columnIndex, columnValue});
    }

    @Override
    public void updateBlob(String columnName, Blob columnValue) throws SQLException {
        this.callMethod("updateBlob", new Class[]{String.class, Blob.class}, new Object[]{columnName, columnValue});
    }

    @Override
    public void updateBoolean(int columnIndex, boolean columnValue) throws SQLException {
        this.callMethod("updateBoolean", new Class[]{Integer.TYPE, Boolean.TYPE}, new Object[]{columnIndex, columnValue});
    }

    @Override
    public void updateBoolean(String columnName, boolean columnValue) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateByte(int columnIndex, byte columnValue) throws SQLException {
        this.callMethod("updateByte", new Class[]{Integer.TYPE, Byte.TYPE}, new Object[]{columnIndex, columnValue});
    }

    @Override
    public void updateByte(String columnName, byte columnValue) throws SQLException {
        this.updateByte(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] columnValue) throws SQLException {
        this.callMethod("updateBytes", new Class[]{Integer.TYPE, byte[].class}, new Object[]{columnIndex, columnValue});
    }

    @Override
    public void updateBytes(String columnName, byte[] columnValue) throws SQLException {
        this.updateBytes(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader columnValue, int length) throws SQLException {
        try {
            SerializableReader reader = columnValue == null ? null : new SerializableReader(columnValue, Math.max(0, length));
            this.callMethod("updateCharacterStream", new Class[]{Integer.TYPE, Reader.class, Integer.TYPE}, new Object[]{columnIndex, reader, length});
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void updateCharacterStream(String columnName, Reader columnValue, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), columnValue, length);
    }

    @Override
    public void updateClob(int columnIndex, Clob columnValue) throws SQLException {
        this.callMethod("updateClob", new Class[]{Integer.TYPE, Clob.class}, new Object[]{columnIndex, columnValue});
    }

    @Override
    public void updateClob(String columnName, Clob columnValue) throws SQLException {
        this.callMethod("updateClob", new Class[]{String.class, Clob.class}, new Object[]{columnName, columnValue});
    }

    @Override
    public void updateDate(int columnIndex, Date columnValue) throws SQLException {
        this.callMethod("updateDate", new Class[]{Integer.TYPE, Date.class}, new Object[]{columnIndex, columnValue});
    }

    @Override
    public void updateDate(String columnName, Date columnValue) throws SQLException {
        this.updateDate(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateDouble(int columnIndex, double columnValue) throws SQLException {
        this.callMethod("updateDouble", new Class[]{Integer.TYPE, Double.TYPE}, new Object[]{columnIndex, columnValue});
    }

    @Override
    public void updateDouble(String columnName, double columnValue) throws SQLException {
        this.updateDouble(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateFloat(int columnIndex, float columnValue) throws SQLException {
        this.callMethod("updateFloat", new Class[]{Integer.TYPE, Float.TYPE}, new Object[]{columnIndex, Float.valueOf(columnValue)});
    }

    @Override
    public void updateFloat(String columnName, float columnValue) throws SQLException {
        this.updateFloat(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateInt(int columnIndex, int columnValue) throws SQLException {
        this.callMethod("updateInt", new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{columnIndex, columnValue});
    }

    @Override
    public void updateInt(String columnName, int columnValue) throws SQLException {
        this.updateInt(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateLong(int columnIndex, long columnValue) throws SQLException {
        this.callMethod("updateLong", new Class[]{Integer.TYPE, Long.TYPE}, new Object[]{columnIndex, columnValue});
    }

    @Override
    public void updateLong(String columnName, long columnValue) throws SQLException {
        this.updateLong(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.callMethod("updateNull", new Class[]{Integer.TYPE}, new Object[]{columnIndex});
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public void updateObject(int columnIndex, Object columnValue) throws SQLException {
        if (columnValue != null && !(columnValue instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("updateObject", new Class[]{Integer.TYPE, Object.class}, new Object[]{columnIndex, columnValue});
    }

    @Override
    public void updateObject(String columnName, Object columnValue) throws SQLException {
        this.updateObject(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateObject(int columnIndex, Object columnValue, int scale) throws SQLException {
        if (columnValue != null && !(columnValue instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("updateObject", new Class[]{Integer.TYPE, Object.class, Integer.TYPE}, new Object[]{columnIndex, columnValue, scale});
    }

    @Override
    public void updateObject(String columnName, Object columnValue, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), columnValue, scale);
    }

    @Override
    public void updateRef(int columnIndex, Ref columnValue) throws SQLException {
        if (columnValue != null && !(columnValue instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("updateRef", new Class[]{Integer.TYPE, Ref.class}, new Object[]{columnIndex, columnValue});
    }

    @Override
    public void updateRef(String columnName, Ref columnValue) throws SQLException {
        if (columnValue != null && !(columnValue instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("updateRef", new Class[]{String.class, Ref.class}, new Object[]{columnName, columnValue});
    }

    @Override
    public void updateRow() throws SQLException {
        this.callMethod("updateRow");
    }

    @Override
    public void updateShort(int columnIndex, short columnValue) throws SQLException {
        this.callMethod("updateShort", new Class[]{Integer.TYPE, Short.TYPE}, new Object[]{columnIndex, columnValue});
    }

    @Override
    public void updateShort(String columnName, short columnValue) throws SQLException {
        this.updateShort(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateString(int columnIndex, String columnValue) throws SQLException {
        this.callMethod("updateString", new Class[]{Integer.TYPE, String.class}, new Object[]{columnIndex, columnValue});
    }

    @Override
    public void updateString(String columnName, String columnValue) throws SQLException {
        this.updateString(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateTime(int columnIndex, Time columnValue) throws SQLException {
        this.callMethod("updateTime", new Class[]{Integer.TYPE, Time.class}, new Object[]{columnIndex, columnValue});
    }

    @Override
    public void updateTime(String columnName, Time columnValue) throws SQLException {
        this.updateTime(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp columnValue) throws SQLException {
        this.callMethod("updateTimestamp", new Class[]{Integer.TYPE, Timestamp.class}, new Object[]{columnIndex, columnValue});
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp columnValue) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), columnValue);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.callMethodRtnInt("getHoldability");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        try {
            JDReaderProxy newReader = new JDReaderProxy();
            return (JDReaderProxy)this.connection_.callFactoryMethod(this.pxId_, "getNCharacterStream", new Class[]{Integer.TYPE}, new Object[]{columnIndex}, newReader);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public Reader getNCharacterStream(String columnName) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnName));
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        try {
            JDNClobProxy newClob = new JDNClobProxy();
            return (JDNClobProxy)this.connection_.callFactoryMethod(this.pxId_, "getNClob", new Class[]{Integer.TYPE}, new Object[]{columnIndex}, newClob);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public NClob getNClob(String columnName) throws SQLException {
        return this.getNClob(this.findColumn(columnName));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return (String)this.callMethodRtnObj("getNString", new Class[]{Integer.TYPE}, new Object[]{columnIndex});
    }

    @Override
    public String getNString(String columnName) throws SQLException {
        return this.getNString(this.findColumn(columnName));
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        try {
            JDRowIdProxy newClob = new JDRowIdProxy();
            return (JDRowIdProxy)this.connection_.callFactoryMethod(this.pxId_, "getRowId", new Class[]{Integer.TYPE}, new Object[]{columnIndex}, newClob);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public RowId getRowId(String columnName) throws SQLException {
        return this.getRowId(this.findColumn(columnName));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        try {
            JDSQLXMLProxy newXML = new JDSQLXMLProxy();
            return (JDSQLXMLProxy)this.connection_.callFactoryMethod(this.pxId_, "getSQLXML", new Class[]{Integer.TYPE}, new Object[]{columnIndex}, newXML);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public SQLXML getSQLXML(String columnName) throws SQLException {
        return this.getSQLXML(this.findColumn(columnName));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        try {
            SerializableReader reader = x == null ? null : new SerializableReader(x, Math.max(0, (int)length));
            this.callMethod("updateNCharacterStream", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, new Object[]{columnIndex, reader, length});
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader x, long length) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.callMethod("updateNClob", new Class[]{Integer.TYPE, NClob.class}, new Object[]{columnIndex, nClob});
    }

    @Override
    public void updateNClob(String columnName, NClob nClob) throws SQLException {
        this.updateNClob(this.findColumn(columnName), nClob);
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.callMethod("updateNString", new Class[]{Integer.TYPE, String.class}, new Object[]{columnIndex, nString});
    }

    @Override
    public void updateNString(String columnName, String nString) throws SQLException {
        this.updateNString(this.findColumn(columnName), nString);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.callMethod("updateRowId", new Class[]{Integer.TYPE, RowId.class}, new Object[]{columnIndex, x});
    }

    @Override
    public void updateRowId(String columnName, RowId x) throws SQLException {
        this.updateRowId(this.findColumn(columnName), x);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.callMethod("updateSQLXML", new Class[]{Integer.TYPE, SQLXML.class}, new Object[]{columnIndex, xmlObject});
    }

    @Override
    public void updateSQLXML(String columnName, SQLXML xmlObject) throws SQLException {
        this.updateSQLXML(this.findColumn(columnName), xmlObject);
    }

    @Override
    protected String[] getValidWrappedList() {
        return new String[]{"java.sql.ResultSet"};
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        InputStream iStream;
        if (x == null || x instanceof Serializable) {
            iStream = x;
        } else {
            try {
                iStream = new SerializableInputStream(x);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        this.callMethod("updateAsciiStream", new Class[]{Integer.TYPE, InputStream.class, Long.TYPE}, new Object[]{columnIndex, iStream, length});
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        InputStream iStream;
        if (x == null || x instanceof Serializable) {
            iStream = x;
        } else {
            try {
                iStream = new SerializableInputStream(x);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        this.callMethod("updateBinaryStream", new Class[]{Integer.TYPE, InputStream.class, Long.TYPE}, new Object[]{columnIndex, iStream, length});
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        InputStream iStream;
        if (inputStream == null || inputStream instanceof Serializable) {
            iStream = inputStream;
        } else {
            try {
                iStream = new SerializableInputStream(inputStream);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        this.callMethod("updateBlob", new Class[]{Integer.TYPE, InputStream.class, Long.TYPE}, new Object[]{columnIndex, iStream, length});
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), inputStream, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        try {
            SerializableReader reader = x == null ? null : new SerializableReader(x, Math.max(0, (int)length));
            this.callMethod("updateCharacterStream", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, new Object[]{columnIndex, reader, length});
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        try {
            SerializableReader sReader = reader == null ? null : new SerializableReader(reader, Math.max(0, (int)length));
            this.callMethod("updateClob", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, new Object[]{columnIndex, sReader, length});
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        try {
            SerializableReader sReader = reader == null ? null : new SerializableReader(reader, Math.max(0, (int)length));
            this.callMethod("updateNClob", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, new Object[]{columnIndex, sReader, length});
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.callMethodRtnBool("isClosed");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        InputStream iStream;
        if (x == null || x instanceof Serializable) {
            iStream = x;
        } else {
            try {
                iStream = new SerializableInputStream(x);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        this.callMethod("updateAsciiStream", new Class[]{Integer.TYPE, InputStream.class}, new Object[]{columnIndex, iStream});
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        InputStream iStream;
        if (x == null || x instanceof Serializable) {
            iStream = x;
        } else {
            try {
                iStream = new SerializableInputStream(x);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        this.callMethod("updateBinaryStream", new Class[]{Integer.TYPE, InputStream.class}, new Object[]{columnIndex, iStream});
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        InputStream iStream;
        if (inputStream == null || inputStream instanceof Serializable) {
            iStream = inputStream;
        } else {
            try {
                iStream = new SerializableInputStream(inputStream);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        this.callMethod("updateBlob", new Class[]{Integer.TYPE, InputStream.class}, new Object[]{columnIndex, iStream});
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), inputStream);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        try {
            SerializableReader sReader = x == null ? null : new SerializableReader(x);
            this.callMethod("updateCharacterStream", new Class[]{Integer.TYPE, Reader.class}, new Object[]{columnIndex, sReader});
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        try {
            SerializableReader sReader = reader == null ? null : new SerializableReader(reader);
            this.callMethod("updateClob", new Class[]{Integer.TYPE, Reader.class}, new Object[]{columnIndex, sReader});
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        try {
            SerializableReader sReader = x == null ? null : new SerializableReader(x);
            this.callMethod("updateNCharacterStream", new Class[]{Integer.TYPE, Reader.class}, new Object[]{columnIndex, sReader});
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        try {
            SerializableReader sReader = reader == null ? null : new SerializableReader(reader);
            this.callMethod("updateNClob", new Class[]{Integer.TYPE, Reader.class}, new Object[]{columnIndex, sReader});
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), reader);
    }

    public void updateDB2Default(int columnIndex) throws SQLException {
        this.callMethod("updateDB2Default", new Class[]{Integer.TYPE}, new Object[]{columnIndex});
    }

    public void updateDBDefault(int columnIndex) throws SQLException {
        this.updateDB2Default(columnIndex);
    }

    public void updateDB2Default(String columnName) throws SQLException {
        this.updateDB2Default(this.findColumn(columnName));
    }

    public void updateDBDefault(String columnName) throws SQLException {
        this.updateDB2Default(this.findColumn(columnName));
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return null;
    }
}

