/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.IFSDataStreamReq;
import com.ibm.as400.access.Trace;

class IFSLockBytesReq
extends IFSDataStreamReq {
    private static final int HEADER_LENGTH = 20;
    private static final int TEMPLATE_LENGTH = 8;
    private static final int FILE_HANDLE_OFFSET = 22;
    private static final int LOCK_FLAGS_OFFSET = 26;
    private static final int LOCK_LIST_LL_OFFSET = 28;
    private static final int LOCK_LIST_CP_OFFSET = 32;
    private static final int LOCK_TYPE_OFFSET = 34;
    private static final int LOCK_BASE_OFFSET_OFFSET = 36;
    private static final int RELATIVE_OFFSET_OFFSET = 40;
    private static final int LENGTH_OFFSET = 44;
    private static final int LARGE_RELATIVE_OFFSET_OFFSET = 44;
    private static final int LARGE_LENGTH_OFFSET = 52;

    IFSLockBytesReq(int fileHandle, boolean isMandatory, boolean isShared, long offset, long length, int datastreamLevel) {
        super(28 + IFSLockBytesReq.getVariableSectionLength(datastreamLevel));
        this.setLength(this.data_.length);
        this.setTemplateLen(8);
        this.setReqRepID(7);
        this.set32bit(fileHandle, 22);
        this.set16bit(isMandatory ? 0 : 1, 26);
        this.set16bit(6, 32);
        this.set16bit(isShared ? 0 : 1, 34);
        if (datastreamLevel < 16) {
            if (offset > Integer.MAX_VALUE) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Specified offset value (" + offset + ") exceeds maximum file length supported by system.");
                }
                offset = Integer.MAX_VALUE;
            }
            if (length > Integer.MAX_VALUE) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Specified length value (" + length + ") exceeds maximum file length supported by system.");
                }
                length = Integer.MAX_VALUE;
            }
            this.set32bit(20, 28);
            this.set32bit(0, 36);
            this.set32bit((int)offset, 40);
            this.set32bit((int)length, 44);
        } else {
            this.set32bit(32, 28);
            this.set64bit(0L, 36);
            this.set64bit(offset, 44);
            this.set64bit(length, 52);
        }
    }

    private static final int getVariableSectionLength(int datastreamLevel) {
        return datastreamLevel < 16 ? 20 : 32;
    }
}

