/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLDataFactory;
import com.ibm.as400.access.SQLInteger;
import com.ibm.as400.access.ToolboxWrapper;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class AS400JDBCArrayResultSet
extends ToolboxWrapper
implements ResultSet {
    private int holdability_;
    private int concurrency_;
    private int fetchDirection_;
    private int fetchSize_;
    private int type_;
    private Object[][] data_;
    private int numberOfColumns_;
    private int numberOfRows_;
    private HashMap columnNameToIndexCache_;
    private SQLData contentTemplate_;
    private boolean isSQLData_;
    private int vrm_;
    private boolean openOnClient_;
    private int currentRowInRowset_;
    private int wasNull_;
    private Calendar calendar_;
    private Class byteArrayClass_;
    private static final int WAS_NULL_UNSET = 0;
    private static final int WAS_NULL = 1;
    private static final int WAS_NOT_NULL = 2;

    AS400JDBCArrayResultSet(Object[] contents, SQLData contentTemplate, boolean isSQLData, int dataType, int vrm) {
        int i;
        Object[][] data = new Object[2][];
        if (isSQLData) {
            data[0] = new SQLInteger[contents.length];
            for (i = 0; i < contents.length; ++i) {
                try {
                    SQLInteger si = (SQLInteger)SQLDataFactory.newData("INTEGER", Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 37, null, this.vrm_, null);
                    data[0][i] = si;
                    ((SQLInteger)data[0][i]).set(i + 1);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            data[0] = new Integer[contents.length];
            for (i = 0; i < contents.length; ++i) {
                try {
                    data[0][i] = i + 1;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        data[1] = contents;
        this.contentTemplate_ = contentTemplate;
        this.isSQLData_ = isSQLData;
        this.vrm_ = vrm;
        String[] columnNames = new String[]{"INDEX", "VALUE"};
        this.init(1007, 1004, 1000, 1, data, columnNames);
    }

    void init(int concurrency, int type, int fetchDirection, int fetchSize, Object[][] data, String[] columnNames) {
        this.holdability_ = 1;
        this.concurrency_ = concurrency;
        this.fetchDirection_ = fetchDirection;
        this.fetchSize_ = fetchSize;
        this.type_ = type;
        this.data_ = data;
        this.numberOfColumns_ = data.length;
        if (this.numberOfColumns_ > 0) {
            this.numberOfRows_ = data[0].length;
        }
        this.columnNameToIndexCache_ = new HashMap();
        for (int i = 0; i < columnNames.length; ++i) {
            this.columnNameToIndexCache_.put(columnNames[i], i + 1);
        }
        this.openOnClient_ = true;
        this.currentRowInRowset_ = -1;
    }

    @Override
    public void close() throws SQLException {
        this.openOnClient_ = false;
    }

    private Calendar getCalendar(TimeZone timeZone) {
        this.calendar_ = this.calendar_ != null ? this.calendar_ : new GregorianCalendar();
        this.calendar_.setTimeZone(timeZone);
        return this.calendar_;
    }

    private final void checkThatResultSetTypeIsScrollable() throws SQLException {
        if (this.type_ == 1003) {
            JDError.throwSQLException("24000");
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        boolean result;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        boolean bl = result = this.currentRowInRowset_ == -1;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "isBeforeFirst");
        }
        return result;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        boolean result;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        boolean bl = result = this.currentRowInRowset_ == this.numberOfRows_;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "isAfterLast");
        }
        return result;
    }

    @Override
    public boolean isFirst() throws SQLException {
        boolean result;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        boolean bl = result = this.currentRowInRowset_ == 0;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "isFirst");
        }
        return result;
    }

    @Override
    public boolean isLast() throws SQLException {
        boolean result;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        boolean bl = result = this.currentRowInRowset_ == this.numberOfRows_ - 1;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "isLast");
        }
        return result;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "beforeFirst");
        }
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.wasNull_ = 0;
        this.currentRowInRowset_ = -1;
    }

    @Override
    public void afterLast() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "afterLast");
        }
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.wasNull_ = 0;
        this.currentRowInRowset_ = this.numberOfRows_;
    }

    @Override
    public boolean first() throws SQLException {
        boolean isValidCursorPosition;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.wasNull_ = 0;
        if (this.numberOfRows_ == 0) {
            isValidCursorPosition = false;
        } else {
            isValidCursorPosition = true;
            this.currentRowInRowset_ = 0;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "first");
        }
        return isValidCursorPosition;
    }

    @Override
    public boolean last() throws SQLException {
        boolean isValidCursorPosition;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.wasNull_ = 0;
        if (this.numberOfRows_ == 0) {
            isValidCursorPosition = false;
        } else {
            isValidCursorPosition = true;
            this.currentRowInRowset_ = this.numberOfRows_ - 1;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "last");
        }
        return isValidCursorPosition;
    }

    @Override
    public boolean previous() throws SQLException {
        boolean isValidCursorPosition;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.wasNull_ = 0;
        --this.currentRowInRowset_;
        if (this.currentRowInRowset_ >= 0) {
            isValidCursorPosition = true;
        } else {
            isValidCursorPosition = false;
            this.currentRowInRowset_ = -1;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "previous");
        }
        return isValidCursorPosition;
    }

    @Override
    public boolean next() throws SQLException {
        boolean isValidCursorPosition;
        this.checkForClosedResultSet();
        this.wasNull_ = 0;
        ++this.currentRowInRowset_;
        if (this.currentRowInRowset_ <= this.numberOfRows_ - 1) {
            isValidCursorPosition = true;
        } else {
            isValidCursorPosition = false;
            this.currentRowInRowset_ = this.numberOfRows_;
        }
        if (!isValidCursorPosition && this.type_ == 1003) {
            this.close();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "next");
        }
        return isValidCursorPosition;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        boolean isValidCursorPosition;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.wasNull_ = 0;
        this.currentRowInRowset_ = row >= 0 ? row - 1 : row + this.numberOfRows_;
        if (this.currentRowInRowset_ >= 0 && this.currentRowInRowset_ <= this.numberOfRows_ - 1) {
            isValidCursorPosition = true;
        } else {
            isValidCursorPosition = false;
            this.currentRowInRowset_ = this.currentRowInRowset_ < 0 ? -1 : this.numberOfRows_;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "absolute");
        }
        return isValidCursorPosition;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        boolean isValidCursorPosition;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.wasNull_ = 0;
        this.currentRowInRowset_ += rows;
        if (this.currentRowInRowset_ >= 0 && this.currentRowInRowset_ <= this.numberOfRows_ - 1) {
            isValidCursorPosition = true;
        } else {
            isValidCursorPosition = false;
            this.currentRowInRowset_ = this.currentRowInRowset_ < 0 ? -1 : this.numberOfRows_;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "relative");
        }
        return isValidCursorPosition;
    }

    @Override
    public int getConcurrency() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getConcurrency");
        }
        this.checkForClosedResultSet();
        return this.concurrency_;
    }

    @Override
    public int getType() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getType");
        }
        this.checkForClosedResultSet();
        return this.type_;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getFetchDirection");
        }
        this.checkForClosedResultSet();
        return this.fetchDirection_;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setFetchDirection");
        }
        this.checkForClosedResultSet();
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchDirection_ = direction;
                break;
            }
            default: {
                JDError.throwSQLException("HY024");
            }
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getFetchSize");
        }
        this.checkForClosedResultSet();
        return this.fetchSize_;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setFetchSize");
        }
        this.checkForClosedResultSet();
        if (rows < 0) {
            JDError.throwSQLException("HY024");
        }
        this.fetchSize_ = rows;
    }

    @Override
    public String getCursorName() throws SQLException {
        String cursorName = null;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getCursorName");
        }
        this.checkForClosedResultSet();
        return cursorName;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData metaData = null;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getMetaData");
        }
        this.checkForClosedResultSet();
        return metaData;
    }

    @Override
    public Statement getStatement() throws SQLException {
        Statement statement = null;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getStatement");
        }
        this.checkForClosedResultSet();
        return statement;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        SQLWarning warnings = null;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getWarnings");
        }
        this.checkForClosedResultSet();
        return warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "clearWarnings");
        }
        this.checkForClosedResultSet();
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        this.checkForClosedResultSet();
        int column = this.findColumnX(columnName);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "findColumn");
        }
        return column;
    }

    private final int findColumnX(String columnName) throws SQLException {
        Integer index = (Integer)this.columnNameToIndexCache_.get(columnName.toUpperCase());
        if (index != null) {
            return index;
        }
        JDError.throwSQLException("HY024");
        return -1;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkForClosedResultSet();
        int row = this.currentRowInRowset_ >= 0 && this.currentRowInRowset_ <= this.numberOfRows_ - 1 ? this.currentRowInRowset_ + 1 : 0;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getRow");
        }
        return row;
    }

    @Override
    public boolean wasNull() throws SQLException {
        boolean result;
        this.checkForClosedResultSet();
        if (this.wasNull_ == 0) {
            JDError.throwSQLException("HY109");
        }
        boolean bl = result = this.wasNull_ == 1;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "wasNull");
        }
        return result;
    }

    @Override
    public boolean getBoolean(int column) throws SQLException {
        this.checkGetterPreconditions(column);
        Object[] columnData = this.data_[column - 1];
        boolean result = false;
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getBoolean();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getBoolean();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBoolean");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBoolean");
        }
        return this.getBoolean(this.findColumnX(columnName));
    }

    @Override
    public byte getByte(int column) throws SQLException {
        this.checkGetterPreconditions(column);
        Object[] columnData = this.data_[column - 1];
        byte result = 0;
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getByte();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getByte();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getByte");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getByte");
        }
        return this.getByte(this.findColumnX(columnName));
    }

    @Override
    public short getShort(int column) throws SQLException {
        this.checkGetterPreconditions(column);
        short result = 0;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getShort();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getShort();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getShort");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getShort");
        }
        return this.getShort(this.findColumnX(columnName));
    }

    @Override
    public int getInt(int column) throws SQLException {
        this.checkGetterPreconditions(column);
        int result = 0;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getInt();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getInt();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getInt");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getInt");
        }
        return this.getInt(this.findColumnX(columnName));
    }

    @Override
    public long getLong(int column) throws SQLException {
        this.checkGetterPreconditions(column);
        long result = 0L;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getLong();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getLong();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getLong");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getLong");
        }
        return this.getLong(this.findColumnX(columnName));
    }

    @Override
    public float getFloat(int column) throws SQLException {
        this.checkGetterPreconditions(column);
        float result = 0.0f;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getFloat();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getFloat();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getFloat");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getFloat");
        }
        return this.getFloat(this.findColumnX(columnName));
    }

    @Override
    public double getDouble(int column) throws SQLException {
        this.checkGetterPreconditions(column);
        double result = 0.0;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getDouble();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getDouble();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getDouble");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getDouble");
        }
        return this.getDouble(this.findColumnX(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int column) throws SQLException {
        this.checkGetterPreconditions(column);
        BigDecimal result = null;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getBigDecimal(-1);
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getBigDecimal(-1);
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBigDecimal");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBigDecimal");
        }
        return this.getBigDecimal(this.findColumnX(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int column, int scale) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBigDecimal " + column + " " + scale);
        }
        return this.getBigDecimal(column).setScale(scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBigDecimal " + columnName + " " + scale);
        }
        return this.getBigDecimal(this.findColumnX(columnName), scale);
    }

    @Override
    public synchronized Date getDate(int column) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getDate");
        }
        return this.getDateX(column, TimeZone.getDefault());
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getDate");
        }
        return this.getDate(this.findColumnX(columnName));
    }

    @Override
    public synchronized Time getTime(int column) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTime");
        }
        return this.getTimeX(column, TimeZone.getDefault());
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTime");
        }
        return this.getTime(this.findColumnX(columnName));
    }

    @Override
    public synchronized Timestamp getTimestamp(int column) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTimestamp");
        }
        return this.getTimestampX(column, TimeZone.getDefault());
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTimestamp");
        }
        return this.getTimestamp(this.findColumnX(columnName));
    }

    @Override
    public synchronized Date getDate(int column, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getDate " + column);
        }
        Date result = this.getDateX(column, calendar.getTimeZone());
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getDate");
        }
        return result;
    }

    @Override
    public Date getDate(String columnName, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getDate " + columnName);
        }
        return this.getDate(this.findColumnX(columnName), calendar);
    }

    private Date getDateX(int column, TimeZone timeZone) throws SQLException {
        this.checkGetterPreconditions(column);
        Date date = null;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                date = ((SQLData)columnData[this.currentRowInRowset_]).getDate(this.getCalendar(timeZone));
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.getCalendar(timeZone), -1);
            date = this.contentTemplate_.getDate(this.getCalendar(timeZone));
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return date;
    }

    @Override
    public synchronized Time getTime(int column, Calendar calendar) throws SQLException {
        Time result = this.getTimeX(column, calendar.getTimeZone());
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTime");
        }
        return result;
    }

    @Override
    public Time getTime(String columnName, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTime");
        }
        return this.getTime(this.findColumnX(columnName), calendar);
    }

    private Time getTimeX(int column, TimeZone timeZone) throws SQLException {
        this.checkGetterPreconditions(column);
        Time time = null;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                time = ((SQLData)columnData[this.currentRowInRowset_]).getTime(this.getCalendar(timeZone));
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.getCalendar(timeZone), -1);
            time = this.contentTemplate_.getTime(this.getCalendar(timeZone));
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return time;
    }

    @Override
    public synchronized Timestamp getTimestamp(int column, Calendar calendar) throws SQLException {
        Timestamp result = this.getTimestampX(column, calendar.getTimeZone());
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTimestamp");
        }
        return result;
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTimestamp");
        }
        return this.getTimestamp(this.findColumnX(columnName), calendar);
    }

    private Timestamp getTimestampX(int column, TimeZone timeZone) throws SQLException {
        this.checkGetterPreconditions(column);
        Timestamp timestamp = null;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                timestamp = ((SQLData)columnData[this.currentRowInRowset_]).getTimestamp(this.getCalendar(timeZone));
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.getCalendar(timeZone), -1);
            timestamp = this.contentTemplate_.getTimestamp(this.getCalendar(timeZone));
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return timestamp;
    }

    @Override
    public byte[] getBytes(int column) throws SQLException {
        this.checkGetterPreconditions(column);
        byte[] result = null;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getBytes();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getBytes();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBytes");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBytes");
        }
        return this.getBytes(this.findColumnX(columnName));
    }

    @Override
    public synchronized String getString(int column) throws SQLException {
        this.checkGetterPreconditions(column);
        String result = null;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getString();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getString();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getString");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public String getString(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getString");
        }
        return this.getString(this.findColumnX(columnName));
    }

    @Override
    public InputStream getBinaryStream(int column) throws SQLException {
        this.checkGetterPreconditions(column);
        InputStream result = null;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getBinaryStream();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getBinaryStream();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBinaryStream");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBinaryStream");
        }
        return this.getBinaryStream(this.findColumnX(columnName));
    }

    @Override
    public InputStream getAsciiStream(int column) throws SQLException {
        this.checkGetterPreconditions(column);
        InputStream result = null;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getAsciiStream();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getAsciiStream();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getAsciiStream");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getAsciiStream");
        }
        return this.getAsciiStream(this.findColumnX(columnName));
    }

    @Override
    public InputStream getUnicodeStream(int column) throws SQLException {
        this.checkGetterPreconditions(column);
        InputStream result = null;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getUnicodeStream();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getUnicodeStream();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getUnicodeStream");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getUnicodeStream");
        }
        return this.getUnicodeStream(this.findColumnX(columnName));
    }

    @Override
    public Reader getCharacterStream(int column) throws SQLException {
        this.checkGetterPreconditions(column);
        Reader result = null;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getCharacterStream();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getCharacterStream();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getCharacterStream");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getCharacterStream");
        }
        return this.getCharacterStream(this.findColumnX(columnName));
    }

    @Override
    public Blob getBlob(int column) throws SQLException {
        this.checkGetterPreconditions(column);
        Blob result = null;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getBlob();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getBlob();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBlob");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBlob");
        }
        return this.getBlob(this.findColumnX(columnName));
    }

    @Override
    public Clob getClob(int column) throws SQLException {
        this.checkGetterPreconditions(column);
        Clob result = null;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getClob();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getClob();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getClob");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getClob");
        }
        return this.getClob(this.findColumnX(columnName));
    }

    @Override
    public Array getArray(int column) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    @Override
    public Array getArray(String columnName) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    @Override
    public Ref getRef(int column) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    @Override
    public URL getURL(int column) throws SQLException {
        this.checkGetterPreconditions(column);
        URL result = null;
        Object[] columnData = this.data_[column - 1];
        String stringResult = null;
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                stringResult = ((SQLData)columnData[this.currentRowInRowset_]).getString();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            stringResult = this.contentTemplate_.getString();
        }
        try {
            result = stringResult == null ? null : new URL(stringResult);
        }
        catch (MalformedURLException e) {
            JDError.throwSQLException("HY105", e);
            result = null;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getURL");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getURL");
        }
        return this.getURL(this.findColumnX(columnName));
    }

    @Override
    public Object getObject(int column) throws SQLException {
        this.checkGetterPreconditions(column);
        Object[] columnData = this.data_[column - 1];
        Object result = null;
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getObject();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getObject();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getObject");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getObject");
        }
        return this.getObject(this.findColumnX(columnName));
    }

    public Object getObject(int column, Map map) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    @Override
    public void updateNull(int column) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNull");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNull");
        }
        this.updateNull(this.findColumnX(columnName));
    }

    @Override
    public void updateByte(int column, byte x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateByte");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateByte");
        }
        this.updateByte(this.findColumnX(columnName), x);
    }

    @Override
    public void updateBoolean(int column, boolean x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBoolean");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBoolean");
        }
        this.updateBoolean(this.findColumnX(columnName), x);
    }

    @Override
    public void updateShort(int column, short x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateShort");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateShort");
        }
        this.updateShort(this.findColumnX(columnName), x);
    }

    @Override
    public void updateInt(int column, int x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateInt");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateInt");
        }
        this.updateInt(this.findColumnX(columnName), x);
    }

    @Override
    public void updateLong(int column, long x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateLong");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateLong");
        }
        this.updateLong(this.findColumnX(columnName), x);
    }

    @Override
    public void updateFloat(int column, float x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateFloat");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateFloat");
        }
        this.updateFloat(this.findColumnX(columnName), x);
    }

    @Override
    public void updateDouble(int column, double x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateDouble");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateDouble");
        }
        this.updateDouble(this.findColumnX(columnName), x);
    }

    @Override
    public void updateBigDecimal(int column, BigDecimal x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBigDecimal");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBigDecimal");
        }
        this.updateBigDecimal(this.findColumnX(columnName), x);
    }

    @Override
    public void updateDate(int column, Date x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateDate");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateDate");
        }
        this.updateDate(this.findColumnX(columnName), x);
    }

    @Override
    public void updateTime(int column, Time x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateTime");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateTime");
        }
        this.updateTime(this.findColumnX(columnName), x);
    }

    @Override
    public void updateTimestamp(int column, Timestamp x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateTimestamp");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateTimestamp");
        }
        this.updateTimestamp(this.findColumnX(columnName), x);
    }

    @Override
    public void updateBytes(int column, byte[] x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBytes");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBytes");
        }
        this.updateBytes(this.findColumnX(columnName), x);
    }

    @Override
    public void updateString(int column, String x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateString");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateString");
        }
        this.updateString(this.findColumnX(columnName), x);
    }

    @Override
    public void updateBinaryStream(int column, InputStream x, int length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBinaryStream");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBinaryStream");
        }
        this.updateBinaryStream(this.findColumnX(columnName), x, length);
    }

    @Override
    public void updateAsciiStream(int column, InputStream x, int length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateAsciiStream");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateAsciiStream");
        }
        this.updateAsciiStream(this.findColumnX(columnName), x, length);
    }

    @Override
    public void updateCharacterStream(int column, Reader x, int length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateCharacterStream");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateCharacterStream");
        }
        this.updateCharacterStream(this.findColumnX(columnName), x, length);
    }

    @Override
    public void updateBlob(int column, Blob x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBlob");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBlob");
        }
        this.updateBlob(this.findColumnX(columnName), x);
    }

    @Override
    public void updateClob(int column, Clob x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateClob");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateClob");
        }
        this.updateClob(this.findColumnX(columnName), x);
    }

    @Override
    public void updateArray(int column, Array x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateArray");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateArray");
        }
        this.updateArray(this.findColumnX(columnName), x);
    }

    @Override
    public void updateRef(int column, Ref x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateRef");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateRef");
        }
        this.updateRef(this.findColumnX(columnName), x);
    }

    @Override
    public void updateObject(int column, Object x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateObject");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateObject");
        }
        this.updateObject(this.findColumnX(columnName), x);
    }

    @Override
    public void updateObject(int column, Object x, int scale) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateObject");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateObject");
        }
        this.updateObject(this.findColumnX(columnName), x, scale);
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001");
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "rowInserted()");
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "rowDeleted()");
        return false;
    }

    @Override
    public void insertRow() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "insertRow");
    }

    @Override
    public void updateRow() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "updateRow()");
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "deleteRow()");
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "refreshRow()");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "cancelRowUpdates()");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "moveToInsertRow()");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "moveToCurrentRow()");
    }

    private final void checkForClosedResultSet() throws SQLException {
        if (!this.openOnClient_) {
            JDError.throwSQLException("24000");
        }
    }

    private final void checkForValidColumnIndex(int column) throws SQLException {
        if (column < 1 || column > this.numberOfColumns_) {
            JDError.throwSQLException("24000");
        }
    }

    private final void checkForValidPosition() throws SQLException {
        if (this.currentRowInRowset_ < 0 || this.currentRowInRowset_ > this.numberOfRows_ - 1) {
            JDError.throwSQLException("24000");
        }
    }

    private final void checkForConcurrency() throws SQLException {
        if (this.concurrency_ != 1008) {
            JDError.throwSQLException("24000");
        }
    }

    private final void checkGetterPreconditions(int column) throws SQLException {
        this.checkForClosedResultSet();
        this.checkForValidColumnIndex(column);
        this.checkForValidPosition();
    }

    private final void checkUpdatePreconditions(int column) throws SQLException {
        this.checkForClosedResultSet();
        this.checkForValidColumnIndex(column);
        this.checkForConcurrency();
    }

    private final void checkUpdatePreconditions() throws SQLException {
        this.checkForClosedResultSet();
        this.checkForConcurrency();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return !this.openOnClient_;
    }

    @Override
    public int getHoldability() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getHoldability");
        }
        this.checkForClosedResultSet();
        return this.holdability_;
    }

    @Override
    public Reader getNCharacterStream(int column) throws SQLException {
        this.checkGetterPreconditions(column);
        Reader result = null;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getNCharacterStream();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getNCharacterStream();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getNCharacterStream");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public Reader getNCharacterStream(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getNCharacterStream");
        }
        return this.getNCharacterStream(this.findColumnX(columnName));
    }

    @Override
    public NClob getNClob(int column) throws SQLException {
        this.checkGetterPreconditions(column);
        NClob result = null;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getNClob();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getNClob();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getNClob");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public NClob getNClob(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getNClob");
        }
        return this.getNClob(this.findColumnX(columnName));
    }

    @Override
    public String getNString(int column) throws SQLException {
        this.checkGetterPreconditions(column);
        String result = null;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getNString();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getNString();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getNString");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public String getNString(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getNString");
        }
        return this.getNString(this.findColumnX(columnName));
    }

    @Override
    public RowId getRowId(int column) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getRowId");
        }
        this.checkGetterPreconditions(column);
        RowId result = null;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getRowId();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getRowId();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getRowId");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public RowId getRowId(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getRowId");
        }
        return this.getRowId(this.findColumnX(columnName));
    }

    @Override
    public SQLXML getSQLXML(int column) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getSQLXML");
        }
        this.checkGetterPreconditions(column);
        SQLXML result = null;
        Object[] columnData = this.data_[column - 1];
        if (this.isSQLData_) {
            if (columnData[this.currentRowInRowset_] != null) {
                result = ((SQLData)columnData[this.currentRowInRowset_]).getSQLXML();
            }
        } else if (columnData[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(columnData[this.currentRowInRowset_], this.calendar_, -1);
            result = this.contentTemplate_.getSQLXML();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getSQLXML");
        }
        this.wasNull_ = columnData[this.currentRowInRowset_] == null ? 1 : 2;
        return result;
    }

    @Override
    public SQLXML getSQLXML(String columnName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getSQLXML");
        }
        return this.getSQLXML(this.findColumnX(columnName));
    }

    @Override
    public void updateAsciiStream(int column, InputStream x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateAsciiStream");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateAsciiStream");
        }
        this.updateAsciiStream(this.findColumnX(columnName), x);
    }

    @Override
    public void updateAsciiStream(int column, InputStream x, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateAsciiStream");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateAsciiStream");
        }
        this.updateAsciiStream(this.findColumnX(columnName), x, length);
    }

    @Override
    public void updateBinaryStream(int column, InputStream x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBinaryStream");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBinaryStream");
        }
        this.updateBinaryStream(this.findColumnX(columnName), x);
    }

    @Override
    public void updateBinaryStream(int column, InputStream x, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBinaryStream");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBinaryStream");
        }
        this.updateBinaryStream(this.findColumnX(columnName), x, length);
    }

    @Override
    public void updateBlob(int column, InputStream x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBlob");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateBlob(String columnName, InputStream x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBlob");
        }
        this.updateBlob(this.findColumnX(columnName), x);
    }

    @Override
    public void updateBlob(int column, InputStream x, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBlob");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateBlob(String columnName, InputStream x, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBlob");
        }
        this.updateBlob(this.findColumnX(columnName), x, length);
    }

    @Override
    public void updateCharacterStream(int column, Reader x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateCharacterStream");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateCharacterStream");
        }
        this.updateCharacterStream(this.findColumnX(columnName), x);
    }

    @Override
    public void updateCharacterStream(int column, Reader x, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateCharacterStream");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader x, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateCharacterStream");
        }
        this.updateCharacterStream(this.findColumnX(columnName), x, length);
    }

    @Override
    public void updateClob(int column, Reader x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateClob");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateClob(String columnName, Reader x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateClob");
        }
        this.updateClob(this.findColumnX(columnName), x);
    }

    @Override
    public void updateClob(int column, Reader x, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateClob");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateClob(String columnName, Reader x, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateClob");
        }
        this.updateClob(this.findColumnX(columnName), x, length);
    }

    @Override
    public void updateNCharacterStream(int column, Reader x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNCharacterStream");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNCharacterStream");
        }
        this.updateNCharacterStream(this.findColumnX(columnName), x);
    }

    @Override
    public void updateNCharacterStream(int column, Reader x, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNCharacterStream");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader x, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNCharacterStream");
        }
        this.updateNCharacterStream(this.findColumnX(columnName), x, length);
    }

    @Override
    public void updateNClob(int column, NClob x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNClob");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateNClob(String columnName, NClob x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNClob");
        }
        this.updateNClob(this.findColumnX(columnName), x);
    }

    @Override
    public void updateNClob(int column, Reader x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNClob");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateNClob(String columnName, Reader x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNClob");
        }
        this.updateNClob(this.findColumnX(columnName), x);
    }

    @Override
    public void updateNClob(int column, Reader x, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNClob");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateNClob(String columnName, Reader x, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNClob");
        }
        this.updateNClob(this.findColumnX(columnName), x, length);
    }

    @Override
    public void updateNString(int column, String x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNString");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateNString(String columnName, String x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNString");
        }
        this.updateNString(this.findColumnX(columnName), x);
    }

    @Override
    public void updateRowId(int column, RowId x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateRowId");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateRowId(String columnName, RowId x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateRowId");
        }
        this.updateRowId(this.findColumnX(columnName), x);
    }

    @Override
    public void updateSQLXML(int column, SQLXML x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateSQLXML");
        }
        this.checkUpdatePreconditions(column);
    }

    @Override
    public void updateSQLXML(String columnName, SQLXML x) throws SQLException {
        this.updateSQLXML(this.findColumnX(columnName), x);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateSQLXML");
        }
    }

    public Object getObject(int columnIndex, Class type) throws SQLException {
        if (type == null) {
            JDError.throwSQLException("HY105");
        }
        if (this.byteArrayClass_ == null) {
            byte[] byteArray = new byte[1];
            this.byteArrayClass_ = byteArray.getClass();
        }
        if (type == String.class) {
            return this.getString(columnIndex);
        }
        if (type == Byte.class) {
            byte b = this.getByte(columnIndex);
            if (b == 0 && this.wasNull()) {
                return null;
            }
            return b;
        }
        if (type == Short.class) {
            short s = this.getShort(columnIndex);
            if (s == 0 && this.wasNull()) {
                return null;
            }
            return s;
        }
        if (type == Integer.class) {
            int i = this.getInt(columnIndex);
            if (i == 0 && this.wasNull()) {
                return null;
            }
            return i;
        }
        if (type == Long.class) {
            long l = this.getLong(columnIndex);
            if (l == 0L && this.wasNull()) {
                return null;
            }
            return l;
        }
        if (type == Float.class) {
            float f = this.getFloat(columnIndex);
            if (f == 0.0f && this.wasNull()) {
                return null;
            }
            return Float.valueOf(f);
        }
        if (type == Double.class) {
            double d = this.getDouble(columnIndex);
            if (d == 0.0 && this.wasNull()) {
                return null;
            }
            return d;
        }
        if (type == BigDecimal.class) {
            return this.getBigDecimal(columnIndex);
        }
        if (type == Boolean.class) {
            boolean b = this.getBoolean(columnIndex);
            if (!b && this.wasNull()) {
                return null;
            }
            return b;
        }
        if (type == Date.class) {
            return this.getDate(columnIndex);
        }
        if (type == Time.class) {
            return this.getTime(columnIndex);
        }
        if (type == Timestamp.class) {
            return this.getTimestamp(columnIndex);
        }
        if (type == this.byteArrayClass_) {
            return this.getBytes(columnIndex);
        }
        if (type == InputStream.class) {
            return this.getBinaryStream(columnIndex);
        }
        if (type == Reader.class) {
            return this.getCharacterStream(columnIndex);
        }
        if (type == Clob.class) {
            return this.getClob(columnIndex);
        }
        if (type == Blob.class) {
            return this.getBlob(columnIndex);
        }
        if (type == Array.class) {
            return this.getArray(columnIndex);
        }
        if (type == Ref.class) {
            return this.getRef(columnIndex);
        }
        if (type == URL.class) {
            return this.getURL(columnIndex);
        }
        if (type == NClob.class) {
            return this.getNClob(columnIndex);
        }
        if (type == RowId.class) {
            return this.getRowId(columnIndex);
        }
        if (type == SQLXML.class) {
            return this.getSQLXML(columnIndex);
        }
        if (type == Object.class) {
            return this.getObject(columnIndex);
        }
        JDError.throwSQLException("HY004");
        return null;
    }

    public Object getObject(String columnLabel, Class type) throws SQLException {
        return this.getObject(this.findColumnX(columnLabel), type);
    }

    @Override
    protected String[] getValidWrappedList() {
        return new String[]{"com.ibm.as400.access.AS400JDBCArrayResultSet", "java.sql.ResultSet"};
    }
}

