/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.metainput;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.json.JsonMetadataParser;
import org.apache.hop.metadata.util.HopMetadataUtil;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.metainput.MetadataInputData;
import org.apache.hop.pipeline.transforms.metainput.MetadataInputMeta;
import org.json.simple.JSONObject;

public class MetadataInput
extends BaseTransform<MetadataInputMeta, MetadataInputData> {
    public MetadataInput(TransformMeta transformMeta, MetadataInputMeta meta, MetadataInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        RowMeta outputRowMeta = new RowMeta();
        ((MetadataInputMeta)this.meta).getFields((IRowMeta)outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        ArrayList<String> typeKeyFilters = new ArrayList<String>();
        for (String typeKeyFilter : ((MetadataInputMeta)this.meta).getTypeKeyFilters()) {
            typeKeyFilters.add(StringUtils.trim((String)this.resolve(typeKeyFilter)));
        }
        List metadataClasses = this.metadataProvider.getMetadataClasses();
        for (Class metadataClass : metadataClasses) {
            IHopMetadataSerializer serializer = this.metadataProvider.getSerializer(metadataClass);
            HopMetadata annotation = HopMetadataUtil.getHopMetadataAnnotation((Class)metadataClass);
            boolean include = typeKeyFilters.isEmpty();
            for (String typeKeyFilter : typeKeyFilters) {
                if (!typeKeyFilter.equals(annotation.key())) continue;
                include = true;
            }
            if (!include) continue;
            JsonMetadataParser parser = new JsonMetadataParser(metadataClass, this.metadataProvider);
            for (String name : serializer.listObjectNames()) {
                IHopMetadata metadata = serializer.load(name);
                Object[] outputRow = RowDataUtil.allocateRowData((int)outputRowMeta.size());
                int index = 0;
                if (StringUtils.isNotEmpty((String)((MetadataInputMeta)this.meta).getProviderFieldName())) {
                    outputRow[index++] = metadata.getMetadataProviderName();
                }
                if (StringUtils.isNotEmpty((String)((MetadataInputMeta)this.meta).getTypeKeyFieldName())) {
                    outputRow[index++] = annotation.key();
                }
                if (StringUtils.isNotEmpty((String)((MetadataInputMeta)this.meta).getTypeDescriptionFieldName())) {
                    outputRow[index++] = annotation.name();
                }
                if (StringUtils.isNotEmpty((String)((MetadataInputMeta)this.meta).getTypeDescriptionFieldName())) {
                    outputRow[index++] = annotation.description();
                }
                if (StringUtils.isNotEmpty((String)((MetadataInputMeta)this.meta).getTypeClassFieldName())) {
                    outputRow[index++] = metadataClass.getName();
                }
                if (StringUtils.isNotEmpty((String)((MetadataInputMeta)this.meta).getNameFieldName())) {
                    outputRow[index++] = metadata.getName();
                }
                if (StringUtils.isNotEmpty((String)((MetadataInputMeta)this.meta).getJsonFieldName())) {
                    JSONObject jsonObject = parser.getJsonObject(metadata);
                    outputRow[index] = jsonObject.toJSONString();
                }
                this.putRow((IRowMeta)outputRowMeta, outputRow);
            }
        }
        this.setOutputDone();
        return false;
    }
}

