/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum LabelType {
    PERSONAL_INFORMATION,
    TEST_ONLY,
    USER_DEFINED_TAG,
    OTHER;


    static class Serializer
    extends UnionSerializer<LabelType> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(LabelType value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case PERSONAL_INFORMATION: {
                    g.writeString("personal_information");
                    break;
                }
                case TEST_ONLY: {
                    g.writeString("test_only");
                    break;
                }
                case USER_DEFINED_TAG: {
                    g.writeString("user_defined_tag");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public LabelType deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            LabelType value = "personal_information".equals(tag) ? PERSONAL_INFORMATION : ("test_only".equals(tag) ? TEST_ONLY : ("user_defined_tag".equals(tag) ? USER_DEFINED_TAG : OTHER));
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

