/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.pipeline.delegates;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineExecutionConfiguration;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.debug.PipelineDebugMeta;
import org.apache.hop.pipeline.debug.TransformDebugMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.apache.hop.ui.pipeline.debug.PipelineDebugDialog;
import org.apache.hop.ui.pipeline.dialog.PipelineExecutionConfigurationDialog;

public class HopGuiPipelineRunDelegate {
    private static final Class<?> PKG = HopGui.class;
    private HopGuiPipelineGraph pipelineGraph;
    private HopGui hopGui;
    private PipelineExecutionConfiguration pipelineExecutionConfiguration;
    private PipelineExecutionConfiguration pipelinePreviewExecutionConfiguration;
    private PipelineExecutionConfiguration pipelineDebugExecutionConfiguration;
    private List<PipelineMeta> pipelineMap;
    private Map<PipelineMeta, PipelineDebugMeta> pipelineDebugMetaMap;
    private Map<PipelineMeta, PipelineDebugMeta> pipelinePreviewMetaMap;

    public HopGuiPipelineRunDelegate(HopGui hopGui, HopGuiPipelineGraph pipelineGraph) {
        this.hopGui = hopGui;
        this.pipelineGraph = pipelineGraph;
        this.pipelineExecutionConfiguration = new PipelineExecutionConfiguration();
        this.pipelinePreviewExecutionConfiguration = new PipelineExecutionConfiguration();
        this.pipelineDebugExecutionConfiguration = new PipelineExecutionConfiguration();
        this.pipelineMap = new ArrayList<PipelineMeta>();
        this.pipelineDebugMetaMap = new HashMap<PipelineMeta, PipelineDebugMeta>();
        this.pipelinePreviewMetaMap = new HashMap<PipelineMeta, PipelineDebugMeta>();
    }

    public PipelineExecutionConfiguration executePipeline(ILogChannel log, PipelineMeta pipelineMeta, boolean preview, boolean debug, LogLevel logLevel) throws HopException {
        PipelineDebugDialog pipelineDebugDialog;
        if (pipelineMeta == null) {
            return null;
        }
        PipelineDebugMeta pipelineDebugMeta = null;
        PipelineExecutionConfiguration executionConfiguration = null;
        executionConfiguration = preview ? this.getPipelinePreviewExecutionConfiguration() : (debug ? this.getPipelineDebugExecutionConfiguration() : this.getPipelineExecutionConfiguration());
        pipelineMeta.setMetadataProvider((IHopMetadataProvider)this.hopGui.getMetadataProvider());
        if (debug) {
            pipelineDebugMeta = this.pipelineDebugMetaMap.get(pipelineMeta);
            if (pipelineDebugMeta == null) {
                pipelineDebugMeta = new PipelineDebugMeta(pipelineMeta);
                this.pipelineDebugMetaMap.put(pipelineMeta, pipelineDebugMeta);
            }
            if ((selectedTransforms = pipelineMeta.getSelectedTransforms()) != null && !selectedTransforms.isEmpty()) {
                pipelineDebugMeta.getTransformDebugMetaMap().clear();
                for (String[] transformMeta : pipelineMeta.getSelectedTransforms()) {
                    transformDebugMeta = new TransformDebugMeta((TransformMeta)transformMeta);
                    transformDebugMeta.setRowCount(PropsUi.getInstance().getDefaultPreviewSize());
                    transformDebugMeta.setPausingOnBreakPoint(true);
                    transformDebugMeta.setReadingFirstRows(false);
                    pipelineDebugMeta.getTransformDebugMetaMap().put(transformMeta, transformDebugMeta);
                }
            }
        } else if (preview) {
            pipelineDebugMeta = this.pipelinePreviewMetaMap.get(pipelineMeta);
            if (pipelineDebugMeta == null) {
                pipelineDebugMeta = new PipelineDebugMeta(pipelineMeta);
                this.pipelinePreviewMetaMap.put(pipelineMeta, pipelineDebugMeta);
            }
            if ((selectedTransforms = pipelineMeta.getSelectedTransforms()) != null && !selectedTransforms.isEmpty()) {
                pipelineDebugMeta.getTransformDebugMetaMap().clear();
                for (String[] transformMeta : pipelineMeta.getSelectedTransforms()) {
                    transformDebugMeta = new TransformDebugMeta((TransformMeta)transformMeta);
                    transformDebugMeta.setRowCount(PropsUi.getInstance().getDefaultPreviewSize());
                    transformDebugMeta.setPausingOnBreakPoint(false);
                    transformDebugMeta.setReadingFirstRows(true);
                    pipelineDebugMeta.getTransformDebugMetaMap().put(transformMeta, transformDebugMeta);
                }
            }
        }
        int debugAnswer = 2;
        if ((debug || preview) && (debugAnswer = (pipelineDebugDialog = new PipelineDebugDialog(this.hopGui.getShell(), this.pipelineGraph.getVariables(), pipelineDebugMeta)).open()) == 0) {
            return null;
        }
        HashMap variableMap = new HashMap();
        variableMap.putAll(executionConfiguration.getVariablesMap());
        executionConfiguration.setVariablesMap(variableMap);
        executionConfiguration.getUsedVariables(this.pipelineGraph.getVariables(), pipelineMeta);
        executionConfiguration.setLogLevel(logLevel);
        if (debug || preview) {
            for (String parameterName : pipelineMeta.listParameters()) {
                String defaultValue = pipelineMeta.getParameterDefault(parameterName);
                if (!StringUtils.isNotEmpty((String)defaultValue)) continue;
                executionConfiguration.getParametersMap().put(parameterName, defaultValue);
            }
        }
        boolean execConfigAnswer = true;
        if (debugAnswer == 2 && pipelineMeta.isShowDialog()) {
            PipelineExecutionConfigurationDialog dialog = new PipelineExecutionConfigurationDialog(this.hopGui.getShell(), executionConfiguration, pipelineMeta);
            execConfigAnswer = dialog.open();
        }
        if (execConfigAnswer) {
            this.pipelineGraph.pipelineLogDelegate.addPipelineLog();
            this.pipelineGraph.pipelineGridDelegate.addPipelineGrid();
            this.pipelineGraph.extraViewTabFolder.setSelection(0);
            pipelineMeta.setClearingLog(executionConfiguration.isClearingLog());
            ExtensionPointHandler.callExtensionPoint((ILogChannel)log, (IVariables)this.pipelineGraph.getVariables(), (String)HopExtensionPoint.HopGuiPipelineMetaExecutionStart.id, (Object)pipelineMeta);
            ExtensionPointHandler.callExtensionPoint((ILogChannel)log, (IVariables)this.pipelineGraph.getVariables(), (String)HopExtensionPoint.HopGuiPipelineExecutionConfiguration.id, (Object)executionConfiguration);
            if (debug || preview) {
                if (pipelineDebugMeta.getNrOfUsedTransforms() == 0) {
                    MessageBox box = new MessageBox(this.hopGui.getShell(), 200);
                    box.setText(BaseMessages.getString(PKG, (String)"HopGui.Dialog.Warning.NoPreviewOrDebugTransforms.Title", (String[])new String[0]));
                    box.setMessage(BaseMessages.getString(PKG, (String)"HopGui.Dialog.Warning.NoPreviewOrDebugTransforms.Message", (String[])new String[0]));
                    int answer = box.open();
                    if (answer != 64) {
                        return null;
                    }
                }
                this.pipelineGraph.debug(executionConfiguration, pipelineDebugMeta);
            } else {
                this.pipelineGraph.start(executionConfiguration);
            }
        }
        return executionConfiguration;
    }

    public HopGuiPipelineGraph getPipelineGraph() {
        return this.pipelineGraph;
    }

    public void setPipelineGraph(HopGuiPipelineGraph pipelineGraph) {
        this.pipelineGraph = pipelineGraph;
    }

    public HopGui getHopGui() {
        return this.hopGui;
    }

    public void setHopGui(HopGui hopGui) {
        this.hopGui = hopGui;
    }

    public PipelineExecutionConfiguration getPipelineExecutionConfiguration() {
        return this.pipelineExecutionConfiguration;
    }

    public void setPipelineExecutionConfiguration(PipelineExecutionConfiguration pipelineExecutionConfiguration) {
        this.pipelineExecutionConfiguration = pipelineExecutionConfiguration;
    }

    public PipelineExecutionConfiguration getPipelinePreviewExecutionConfiguration() {
        return this.pipelinePreviewExecutionConfiguration;
    }

    public void setPipelinePreviewExecutionConfiguration(PipelineExecutionConfiguration pipelinePreviewExecutionConfiguration) {
        this.pipelinePreviewExecutionConfiguration = pipelinePreviewExecutionConfiguration;
    }

    public PipelineExecutionConfiguration getPipelineDebugExecutionConfiguration() {
        return this.pipelineDebugExecutionConfiguration;
    }

    public void setPipelineDebugExecutionConfiguration(PipelineExecutionConfiguration pipelineDebugExecutionConfiguration) {
        this.pipelineDebugExecutionConfiguration = pipelineDebugExecutionConfiguration;
    }

    public List<PipelineMeta> getPipelineMap() {
        return this.pipelineMap;
    }

    public void setPipelineMap(List<PipelineMeta> pipelineMap) {
        this.pipelineMap = pipelineMap;
    }

    public Map<PipelineMeta, PipelineDebugMeta> getPipelineDebugMetaMap() {
        return this.pipelineDebugMetaMap;
    }

    public void setPipelineDebugMetaMap(Map<PipelineMeta, PipelineDebugMeta> pipelineDebugMetaMap) {
        this.pipelineDebugMetaMap = pipelineDebugMetaMap;
    }

    public Map<PipelineMeta, PipelineDebugMeta> getPipelinePreviewMetaMap() {
        return this.pipelinePreviewMetaMap;
    }

    public void setPipelinePreviewMetaMap(Map<PipelineMeta, PipelineDebugMeta> pipelinePreviewMetaMap) {
        this.pipelinePreviewMetaMap = pipelinePreviewMetaMap;
    }
}

