/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.dialog;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.IRunnableWithProgress;
import org.apache.hop.core.ProgressMonitorAdapter;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.ProgressMonitorDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.eclipse.swt.widgets.Shell;

public class GetWorkflowSqlProgressDialog {
    private static final Class<?> PKG = GetWorkflowSqlProgressDialog.class;
    private Shell shell;
    private final IVariables variables;
    private WorkflowMeta workflowMeta;
    private List<SqlStatement> stats;

    public GetWorkflowSqlProgressDialog(Shell shell, IVariables variables, WorkflowMeta workflowMeta) {
        this.shell = shell;
        this.variables = variables;
        this.workflowMeta = workflowMeta;
    }

    public List<SqlStatement> open() {
        IRunnableWithProgress op = monitor -> {
            try {
                this.stats = this.workflowMeta.getSqlStatements((IProgressMonitor)new ProgressMonitorAdapter(monitor), this.variables);
            }
            catch (HopException e) {
                throw new InvocationTargetException(e, BaseMessages.getString(PKG, (String)"GetJobSQLProgressDialog.RuntimeError.UnableToGenerateSQL.Exception", (String[])new String[]{e.getMessage()}));
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            pmd.run(false, op);
        }
        catch (InvocationTargetException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetJobSQLProgressDialog.Dialog.UnableToGenerateSQL.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetJobSQLProgressDialog.Dialog.UnableToGenerateSQL.Message", (String[])new String[0]), e);
            this.stats = null;
        }
        catch (InterruptedException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetJobSQLProgressDialog.Dialog.UnableToGenerateSQL.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetJobSQLProgressDialog.Dialog.UnableToGenerateSQL.Message", (String[])new String[0]), e);
            this.stats = null;
        }
        return this.stats;
    }
}

