/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.plan.resourceprovider;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.flink.agents.api.resource.Resource;
import org.apache.flink.agents.api.resource.ResourceType;
import org.apache.flink.agents.plan.resourceprovider.ResourceProvider;

public class PythonResourceProvider
extends ResourceProvider {
    private final String module;
    private final String clazz;
    private final Map<String, Object> kwargs;

    public PythonResourceProvider(String name, ResourceType type, String module, String clazz, Map<String, Object> kwargs) {
        super(name, type);
        this.module = module;
        this.clazz = clazz;
        this.kwargs = kwargs;
    }

    public String getModule() {
        return this.module;
    }

    public String getClazz() {
        return this.clazz;
    }

    public Map<String, Object> getKwargs() {
        return this.kwargs;
    }

    @Override
    public Resource provide(BiFunction<String, ResourceType, Resource> getResource) throws Exception {
        throw new UnsupportedOperationException("Python resource creation not yet implemented in Java runtime");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PythonResourceProvider that = (PythonResourceProvider)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals((Object)this.getType(), (Object)that.getType()) && Objects.equals(this.module, that.module) && Objects.equals(this.clazz, that.clazz) && Objects.equals(this.kwargs, that.kwargs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getType(), this.module, this.clazz, this.kwargs});
    }
}

