/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.agents.api.AgentBuilder;
import org.apache.flink.agents.api.configuration.Configuration;
import org.apache.flink.agents.api.resource.ResourceDescriptor;
import org.apache.flink.agents.api.resource.ResourceType;
import org.apache.flink.agents.api.resource.SerializableResource;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;

public abstract class AgentsExecutionEnvironment {
    protected final Map<ResourceType, Map<String, Object>> resources = new HashMap<ResourceType, Map<String, Object>>();

    protected AgentsExecutionEnvironment() {
        for (ResourceType type : ResourceType.values()) {
            this.resources.put(type, new HashMap());
        }
    }

    public static AgentsExecutionEnvironment getExecutionEnvironment(StreamExecutionEnvironment env, @Nullable StreamTableEnvironment tEnv) {
        if (env == null) {
            try {
                Class<?> localEnvClass = Class.forName("org.apache.flink.agents.runtime.env.LocalExecutionEnvironment");
                return (AgentsExecutionEnvironment)localEnvClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create LocalExecutionEnvironment", e);
            }
        }
        try {
            Class<?> remoteEnvClass = Class.forName("org.apache.flink.agents.runtime.env.RemoteExecutionEnvironment");
            return (AgentsExecutionEnvironment)remoteEnvClass.getDeclaredConstructor(StreamExecutionEnvironment.class, StreamTableEnvironment.class).newInstance(env, tEnv);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create RemoteExecutionEnvironment", e);
        }
    }

    public static AgentsExecutionEnvironment getExecutionEnvironment(StreamExecutionEnvironment env) {
        return AgentsExecutionEnvironment.getExecutionEnvironment(env, null);
    }

    public static AgentsExecutionEnvironment getExecutionEnvironment() {
        return AgentsExecutionEnvironment.getExecutionEnvironment(null);
    }

    public abstract Configuration getConfig();

    public abstract AgentBuilder fromList(List<Object> var1);

    public abstract <T, K> AgentBuilder fromDataStream(DataStream<T> var1, KeySelector<T, K> var2);

    public <T> AgentBuilder fromDataStream(DataStream<T> input) {
        return this.fromDataStream(input, null);
    }

    public abstract <K> AgentBuilder fromTable(Table var1, KeySelector<Object, K> var2);

    public AgentBuilder fromTable(Table input) {
        return this.fromTable(input, null);
    }

    public abstract void execute() throws Exception;

    public AgentsExecutionEnvironment addResource(String name, ResourceType type, Object instance) {
        if (this.resources.get((Object)type).containsKey(name)) {
            throw new IllegalArgumentException(String.format("%s %s already defined.", new Object[]{type, name}));
        }
        if (instance instanceof SerializableResource) {
            this.resources.get((Object)type).put(name, instance);
        } else if (instance instanceof ResourceDescriptor) {
            this.resources.get((Object)type).put(name, instance);
        } else {
            throw new IllegalArgumentException(String.format("Unsupported resource %s", instance.getClass().getName()));
        }
        return this;
    }
}

