/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.websocket.jakarta.common;

import jakarta.websocket.EncodeException;
import jakarta.websocket.RemoteEndpoint;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.ee10.websocket.jakarta.common.JakartaWebSocketRemoteEndpoint;
import org.eclipse.jetty.ee10.websocket.jakarta.common.JakartaWebSocketSession;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.OpCode;
import org.eclipse.jetty.websocket.core.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JakartaWebSocketBasicRemote
extends JakartaWebSocketRemoteEndpoint
implements RemoteEndpoint.Basic {
    private static final Logger LOG = LoggerFactory.getLogger(JakartaWebSocketBasicRemote.class);

    protected JakartaWebSocketBasicRemote(JakartaWebSocketSession session, CoreSession coreSession) {
        super(session, coreSession);
    }

    public OutputStream getSendStream() throws IOException {
        return this.newMessageOutputStream();
    }

    public Writer getSendWriter() throws IOException {
        return this.newMessageWriter();
    }

    public void sendBinary(ByteBuffer data) throws IOException {
        this.assertMessageNotNull(data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBinary({})", (Object)BufferUtil.toDetailString(data));
        }
        FutureCallback b = new FutureCallback();
        this.sendFrame(new Frame(2).setPayload(data), b, false);
        b.block();
    }

    public void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
        this.assertMessageNotNull(partialByte);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBinary({},{})", (Object)BufferUtil.toDetailString(partialByte), (Object)isLast);
        }
        Frame frame = switch (this.messageType) {
            case -1 -> new Frame(2);
            case 1 -> throw new IllegalStateException("Cannot send a partial BINARY message: TEXT message in progress");
            case 2 -> new Frame(0);
            default -> throw new IllegalStateException("Cannot send a partial BINARY message: unrecognized active message type " + OpCode.name(this.messageType));
        };
        frame.setPayload(partialByte);
        frame.setFin(isLast);
        FutureCallback b = new FutureCallback();
        this.sendFrame(frame, b, false);
        b.block();
    }

    public void sendObject(Object data) throws IOException, EncodeException {
        FutureCallback b = new FutureCallback();
        super.sendObject(data, b);
        b.block();
    }

    public void sendText(String text) throws IOException {
        this.assertMessageNotNull(text);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendText({})", (Object)TextUtils.hint(text));
        }
        FutureCallback b = new FutureCallback();
        this.sendFrame(new Frame(1).setPayload(text), b, false);
        b.block();
    }

    public void sendText(String partialMessage, boolean isLast) throws IOException {
        this.assertMessageNotNull(partialMessage);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendText({},{})", (Object)TextUtils.hint(partialMessage), (Object)isLast);
        }
        Frame frame = switch (this.messageType) {
            case -1 -> new Frame(1);
            case 1 -> new Frame(0);
            case 2 -> throw new IllegalStateException("Cannot send a partial TEXT message: BINARY message in progress");
            default -> throw new IllegalStateException("Cannot send a partial TEXT message: unrecognized active message type " + OpCode.name(this.messageType));
        };
        frame.setPayload(BufferUtil.toBuffer(partialMessage, StandardCharsets.UTF_8));
        frame.setFin(isLast);
        FutureCallback b = new FutureCallback();
        this.sendFrame(frame, b, false);
        b.block();
    }
}

