/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.websocket.api.ExtensionConfig;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.common.JettyExtensionConfig;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeResponse;

class UpgradeResponseDelegate
implements UpgradeResponse {
    private final ServerUpgradeResponse response;
    private final Map<String, List<String>> headers;

    UpgradeResponseDelegate(ServerUpgradeResponse response) {
        this.response = response;
        this.headers = HttpFields.asMap(response.getHeaders());
    }

    @Override
    public String getAcceptedSubProtocol() {
        return this.response.getAcceptedSubProtocol();
    }

    @Override
    public List<ExtensionConfig> getExtensions() {
        return this.response.getExtensions().stream().map(JettyExtensionConfig::new).collect(Collectors.toList());
    }

    @Override
    public String getHeader(String name) {
        return this.response.getHeaders().get(name);
    }

    @Override
    public Set<String> getHeaderNames() {
        return this.response.getHeaders().getFieldNamesCollection();
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.response.getHeaders().getValuesList(name);
    }

    @Override
    public int getStatusCode() {
        return this.response.getStatus();
    }
}

