/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.util.EventListener;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.listener.ContainerInitializer;
import org.eclipse.jetty.websocket.server.NativeWebSocketConfiguration;

public class NativeWebSocketServletContainerInitializer
implements ServletContainerInitializer {
    public static final String ATTR_KEY = NativeWebSocketConfiguration.class.getName();

    public static NativeWebSocketConfiguration initialize(ServletContextHandler context) {
        NativeWebSocketConfiguration configuration = (NativeWebSocketConfiguration)context.getAttribute(ATTR_KEY);
        if (configuration == null) {
            configuration = new NativeWebSocketConfiguration(context.getServletContext());
            context.setAttribute(ATTR_KEY, configuration);
            context.addManaged(configuration);
        }
        return configuration;
    }

    public static void configure(ServletContextHandler context, Configurator configurator) {
        context.addEventListener((EventListener)((Object)ContainerInitializer.asContextListener(new NativeWebSocketServletContainerInitializer()).afterStartup(servletContext -> {
            if (configurator != null) {
                NativeWebSocketConfiguration configuration = (NativeWebSocketConfiguration)servletContext.getAttribute(ATTR_KEY);
                configurator.accept((ServletContext)servletContext, configuration);
            }
        })));
    }

    @Deprecated
    public static NativeWebSocketConfiguration getDefaultFrom(ServletContext context) {
        ServletContextHandler handler = ServletContextHandler.getServletContextHandler(context);
        if (handler == null) {
            throw new IllegalStateException("Unable to find ServletContextHandler for provided ServletContext");
        }
        return NativeWebSocketServletContainerInitializer.initialize(handler);
    }

    public void onStartup(Set<Class<?>> c, ServletContext context) {
        ServletContextHandler handler = ServletContextHandler.getServletContextHandler(context);
        if (handler == null) {
            throw new IllegalStateException("Unable to find ServletContextHandler for provided ServletContext");
        }
        NativeWebSocketServletContainerInitializer.initialize(handler);
    }

    public static interface Configurator {
        public void accept(ServletContext var1, NativeWebSocketConfiguration var2);
    }
}

