/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.runtime;

import java.util.Arrays;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.felix.http.base.internal.runtime.AbstractInfo;
import org.apache.felix.http.base.internal.runtime.WhiteboardServiceInfo;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.ServiceReference;

public class ListenerInfo
extends WhiteboardServiceInfo<EventListener> {
    private static final Set<String> ALLOWED_INTERFACES = new HashSet<String>();
    private final boolean enabled;
    private final String[] types;

    public ListenerInfo(ServiceReference<EventListener> ref) {
        super(ref);
        this.enabled = this.getBooleanProperty(ref, "osgi.http.whiteboard.listener");
        String[] objectClass = (String[])ref.getProperty("objectClass");
        HashSet<String> names = new HashSet<String>();
        for (String name : objectClass) {
            if (!ALLOWED_INTERFACES.contains(name)) continue;
            names.add(name);
        }
        this.types = names.toArray(new String[names.size()]);
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.enabled;
    }

    public String[] getListenerTypes() {
        return this.types;
    }

    public boolean isListenerType(@NotNull String className) {
        for (String t : this.types) {
            if (!t.equals(className)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSame(AbstractInfo<EventListener> other) {
        if (!super.isSame(other)) {
            return false;
        }
        ListenerInfo o = (ListenerInfo)other;
        if (!Arrays.deepEquals(this.types, o.types)) {
            return false;
        }
        return this.enabled == o.enabled;
    }

    static {
        ALLOWED_INTERFACES.add(HttpSessionAttributeListener.class.getName());
        ALLOWED_INTERFACES.add(HttpSessionIdListener.class.getName());
        ALLOWED_INTERFACES.add(HttpSessionListener.class.getName());
        ALLOWED_INTERFACES.add(ServletContextAttributeListener.class.getName());
        ALLOWED_INTERFACES.add(ServletContextListener.class.getName());
        ALLOWED_INTERFACES.add(ServletRequestAttributeListener.class.getName());
        ALLOWED_INTERFACES.add(ServletRequestListener.class.getName());
    }
}

